/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.auto.JDFAutoMessageService;
import org.cip4.jdflib.auto.JDFAutoSignal;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFSubElement;
import org.cip4.jdflib.jmf.JDFMessageService;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.util.StringUtil;

public class WalkMessageService
extends WalkJDFSubElement {
    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && toCheck instanceof JDFMessageService;
    }

    @Override
    public VString getElementNames() {
        return new VString("MessageService", null);
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        map.remove("Acknowledge");
        map.remove("GenericAttributes");
        map.remove("JMFRole");
        String pers = map.remove("Persistent");
        String query = map.get("Query");
        StringArray cm = new StringArray(map.remove("ChannelMode"));
        if (StringUtil.parseBoolean(pers, false)) {
            cm.appendUnique(JDFAutoSignal.EnumChannelMode.FireAndForget.getName());
        }
        if (StringUtil.parseBoolean(query, false)) {
            cm.appendUnique("Response");
        }
        map.putNotNull("ResponseModes", cm.getString());
        map.remove("Registration");
        String urlschemes = map.get("URLSchemes");
        if (urlschemes != null) {
            map.put("URLSchemes", StringUtil.removeToken(urlschemes, "file", null));
        }
        super.updateAttributes(map);
    }

    @Override
    protected void removeUnusedElements(KElement jdf) {
        VElement v = jdf.getChildElementVector(null, null);
        if (v != null) {
            for (KElement e : v) {
                if (!(e instanceof JDFAbstractState)) continue;
                e.deleteNode();
            }
        }
        super.removeUnusedElements(jdf);
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFMessageService ms = (JDFMessageService)jdf;
        JDFAutoMessageService.EnumJMFRole role = ms.getJMFRole();
        if (JDFAutoMessageService.EnumJMFRole.Sender.equals(role)) {
            return null;
        }
        return super.walk(jdf, xjdf);
    }
}

