/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.Collection;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.extensions.xjdfwalker.XJMFTypeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkMessage;
import org.cip4.jdflib.jmf.JDFCommand;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFModifyQueueEntryParams;
import org.cip4.jdflib.jmf.JDFQuery;
import org.cip4.jdflib.jmf.JDFQueueEntryDef;

public class WalkModifyQueueEntry
extends WalkMessage {
    private static final StringArray QUEUE_CONTROL = new StringArray("AbortQueueEntry,HoldQueueEntry,RemoveQueueEntry,ResumeQueueEntry,SetGangQueueEntry,SetQueueEntryPosition,SetQueueEntryPriority,SuspendQueueEntry", ",");

    @Override
    JDFMessage makeTypesafe(JDFMessage m) {
        if ((m = super.makeTypesafe(m)) instanceof JDFQuery || m instanceof JDFCommand) {
            String id = m.getID();
            String originalType = super.getMessageType(m);
            JDFModifyQueueEntryParams.eOperation operation = JDFModifyQueueEntryParams.eOperation.getEnum(originalType);
            if (operation != null) {
                this.updateMQP(m, id, originalType, operation);
            }
        }
        return m;
    }

    void updateMQP(JDFMessage m, String id, String originalType, JDFModifyQueueEntryParams.eOperation operation) {
        String qeid;
        Object oldParams;
        XJMFTypeMap.getMap().put(id, originalType);
        JDFModifyQueueEntryParams modifyParams = (JDFModifyQueueEntryParams)m.getCreateElement("ModifyQueueEntryParams", null, 0);
        modifyParams.setOperation(operation);
        if (JDFMessage.EnumType.SetQueueEntryPriority.getName().equals(originalType)) {
            oldParams = "QueueEntryPriParams";
            op = m.getElement((String)oldParams);
            modifyParams.setAttributes(op);
        } else if (JDFMessage.EnumType.SetQueueEntryPosition.getName().equals(originalType)) {
            oldParams = "QueueEntryPosParams";
            op = m.getElement((String)oldParams);
            modifyParams.setAttributes(op);
            modifyParams.removeAttribute("QueueEntryID");
        } else {
            oldParams = originalType + "Params";
        }
        JDFQueueEntryDef queueEntryDef = (JDFQueueEntryDef)m.getElement("QueueEntryDef", null, 0);
        String string = qeid = queueEntryDef == null ? null : queueEntryDef.getQueueEntryID();
        if (qeid != null) {
            modifyParams.setXPathAttribute("QueueFilter/@QueueEntryIDs", qeid);
            m.removeChild("QueueEntryDef", null, 0);
        }
        this.updateOP(m, operation, modifyParams, (String)oldParams);
    }

    void updateOP(JDFMessage m, JDFModifyQueueEntryParams.eOperation operation, JDFModifyQueueEntryParams modifyParams, String oldParams) {
        KElement op = m.getElement(oldParams);
        if (op != null) {
            String qeid0 = op.getNonEmpty("QueueEntryID");
            if (qeid0 != null) {
                modifyParams.setXPathAttribute("QueueFilter/@QueueEntryIDs", qeid0);
            }
            if (JDFModifyQueueEntryParams.eOperation.Abort.equals((Object)operation)) {
                String endstate = op.getNonEmpty("EndStatus");
                if (JDFElement.EnumNodeStatus.Completed.getName().equals(endstate)) {
                    modifyParams.setOperation(JDFModifyQueueEntryParams.eOperation.Complete);
                }
            }
            modifyParams.moveElement(op.getElement("QueueFilter"), null);
            op.deleteNode();
        }
    }

    @Override
    String getMessageType(JDFMessage m) {
        return "ModifyQueueEntry";
    }

    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && super.matches(toCheck) && WalkModifyQueueEntry.isQueueControl(toCheck.getAttribute("Type"));
    }

    public static boolean isQueueControl(String type) {
        return QUEUE_CONTROL.contains(type);
    }

    public static Collection<String> getQueueControl() {
        return new StringArray(QUEUE_CONTROL);
    }
}

