/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.XJDFEnums;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkResource;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFMedia;

public class WalkMedia
extends WalkResource {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFMedia;
    }

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        JDFResource root;
        KElement rPart = super.walk(e, trackElem);
        if (rPart != null && (root = ((JDFResource)rPart).getResourceRoot()) != null && root != rPart && !root.hasAttribute("MediaType")) {
            root.copyAttribute("MediaType", rPart);
        }
        return rPart;
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("Media", null);
    }

    @Override
    protected void updateAttributes(KElement elem) {
        this.updateCoating((JDFMedia)elem, "Coating", "FrontCoatings");
        this.updateCoating((JDFMedia)elem, "BackCoating", "BackCoatings");
        elem.renameAttribute("CoatingDetail", "FrontCoatings");
        elem.renameAttribute("GlossValue", "FrontGlossValue");
        super.updateAttributes(elem);
    }

    void updateCoating(JDFMedia m, String xjdf, String jdf) {
        XJDFEnums.eCoating c = XJDFEnums.eCoating.getEnum(m.getNonEmpty(xjdf));
        if (c != null) {
            m.removeAttribute(xjdf);
            m.setAttribute(jdf, c.getJDFVal());
        }
    }
}

