/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.StringUtil;

public class WalkXJDF
extends WalkXElement {
    @Override
    public KElement walk(KElement xjdf, KElement jdf) {
        JDFNode jdfNode = this.getParentProduct(xjdf, jdf);
        jdfNode.setAttributes(xjdf);
        jdfNode.setVersion(this.xjdfToJDFImpl.getVersion());
        jdfNode.setMaxVersion(this.xjdfToJDFImpl.getVersion());
        jdfNode.setStatus(JDFElement.EnumNodeStatus.Part);
        this.xjdfToJDFImpl.currentJDFNode = jdfNode;
        this.updateJobID();
        this.setType();
        this.updateAttributes(jdfNode);
        return jdfNode;
    }

    JDFNode getParentProduct(KElement xjdf, KElement jdf) {
        JDFNode childProduct;
        JDFNode jdfNode = (JDFNode)jdf;
        String parentID = xjdf.getNonEmpty("ParentID");
        if (parentID != null && (childProduct = (JDFNode)jdfNode.getChildWithAttribute("JDF", "JobPartID", null, parentID, 0, false)) != null) {
            jdfNode = childProduct;
        }
        return jdfNode;
    }

    private void setType() {
        String t = this.xjdfToJDFImpl.currentJDFNode.getAttribute("Types", null, null);
        if ("Product".equals(t) || StringUtil.isEmpty(t)) {
            this.xjdfToJDFImpl.currentJDFNode.setType(JDFNode.EnumType.Product);
            this.xjdfToJDFImpl.currentJDFNode.removeAttribute("Types");
            this.xjdfToJDFImpl.foundProduct = true;
            this.xjdfToJDFImpl.createProduct = true;
        } else if (StringUtil.tokenize(t, null, false).size() == 1) {
            this.xjdfToJDFImpl.currentJDFNode.setType(t.trim(), false);
        } else {
            this.xjdfToJDFImpl.currentJDFNode.setType(JDFNode.EnumType.ProcessGroup);
        }
    }

    private void updateJobID() {
        JDFNode parentNode = this.xjdfToJDFImpl.currentJDFNode.getParentJDF();
        if (parentNode != null) {
            String jobID = StringUtil.getNonEmpty(parentNode.getJobID(true));
            String myJobID = StringUtil.getNonEmpty(this.xjdfToJDFImpl.currentJDFNode.getJobID(false));
            if (myJobID != null && myJobID.equals(jobID)) {
                this.xjdfToJDFImpl.currentJDFNode.removeAttribute("JobID");
            }
        } else {
            this.xjdfToJDFImpl.currentJDFNode.appendAnchor(null);
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && JDFElement.isInXJDFNameSpaceStatic(toCheck);
    }

    @Override
    protected void updateAttributes(KElement elem) {
        elem.removeAttribute("ParentID");
        super.updateAttributes(elem);
    }

    @Override
    public VString getElementNames() {
        return new VString("XJDF");
    }
}

