/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.goldenticket.MISGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFInterpretingParams;
import org.cip4.jdflib.resource.JDFLayoutPreparationParams;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFDigitalPrintingParams;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFRunList;

public class IDPGoldenTicket
extends MISGoldenTicket {
    public IDPGoldenTicket(IDPGoldenTicket previous, VJDFAttributeMap _vparts) {
        super(previous.misICSLevel, previous.theVersion, previous.jmfICSLevel);
        this.grayBox = false;
        this.partIDKeys = new VString(previous.partIDKeys);
        this.vParts = _vparts == null ? new VJDFAttributeMap(previous.vParts) : _vparts;
        this.icsLevel = previous.icsLevel;
        this.nCols = previous.nCols;
        this.workStyle = previous.workStyle;
        this.thePreviousNode = previous.theNode;
        this.theParentNode = previous.theParentNode;
        this.bUsageCounter = true;
    }

    @Override
    protected void fillCatMaps() {
        super.fillCatMaps();
        this.catMap.put("IDP.DigitalPrinting", new VString("LayoutPreparation Interpreting Rendering DigitalPrinting", null));
        this.setCategory("IDP.DigitalPrinting");
    }

    public IDPGoldenTicket(MISGoldenTicket parent) {
        super(parent);
        this.grayBox = false;
        this.bUsageCounter = true;
    }

    public IDPGoldenTicket(int _icsLevel) {
        this(_icsLevel, null);
    }

    public IDPGoldenTicket(int _icsLevel, JDFElement.EnumVersion version) {
        super(1, version, 2);
        this.grayBox = false;
        this.bUsageCounter = true;
        this.icsLevel = _icsLevel;
    }

    @Override
    public void init() {
        String icsTag = "IDP_L" + this.icsLevel + "-" + this.theVersion.getName();
        this.theNode.appendAttribute("ICSVersions", icsTag, null, " ", true);
        if (!this.theNode.hasAttribute("DescriptiveName")) {
            this.theNode.setDescriptiveName("IDP Golden Ticket Example Job - version: " + JDFAudit.software());
        }
        super.init();
        this.setActivePart(this.vParts, true);
        this.initDocumentRunList();
        this.initOutputComponent();
        this.initInterpretingParams();
        JDFMedia m = this.initPaperMedia();
        this.initDigitalPrintingParams(m);
        this.initLayoutPrep();
    }

    private JDFLayoutPreparationParams initLayoutPrep() {
        JDFLayoutPreparationParams layPP = (JDFLayoutPreparationParams)this.theNode.getCreateResource("LayoutPreparationParams", JDFResourceLink.EnumUsage.Input, 0);
        layPP.setSides(JDFElement.EnumSides.TwoSidedFlipY);
        return layPP;
    }

    private JDFInterpretingParams initInterpretingParams() {
        return (JDFInterpretingParams)this.theNode.getCreateResource("InterpretingParams", JDFResourceLink.EnumUsage.Input, 0);
    }

    private JDFDigitalPrintingParams initDigitalPrintingParams(JDFMedia m) {
        JDFDigitalPrintingParams digiParams = (JDFDigitalPrintingParams)this.theNode.getCreateResource("DigitalPrintingParams", JDFResourceLink.EnumUsage.Input, 0);
        digiParams.setSides(JDFElement.EnumSides.TwoSided);
        if (m != null) {
            digiParams.refElement(m);
        }
        return digiParams;
    }

    @Override
    public void execute(VJDFAttributeMap parts, boolean outputAvailable, boolean bFirst) {
        this.setActivePart(null, bFirst);
        super.execute(null, outputAvailable, bFirst);
    }

    @Override
    protected JDFRunList initDocumentRunList() {
        JDFRunList rl = super.initDocumentRunList();
        this.theNode.getLink((JDFResource)rl, JDFResourceLink.EnumUsage.Input).setProcessUsage((JDFNode.EnumProcessUsage)null);
        return rl;
    }

    @Override
    protected JDFMedia initPaperMedia() {
        super.initPaperMedia();
        this.paperMedia.setDimensionInch(new JDFXYPair(8.5, 11.0));
        return this.paperMedia;
    }
}

