/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import java.io.File;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.auto.JDFAutoRefAnchor;
import org.cip4.jdflib.auto.JDFAutoRepeatDesc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.goldenticket.MISGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.process.JDFConvertingConfig;
import org.cip4.jdflib.resource.process.JDFDieLayout;
import org.cip4.jdflib.resource.process.JDFDieLayoutProductionParams;
import org.cip4.jdflib.resource.process.JDFFileSpec;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFObjectModel;
import org.cip4.jdflib.resource.process.JDFRepeatDesc;
import org.cip4.jdflib.resource.process.JDFShapeDef;
import org.cip4.jdflib.resource.process.JDFShapeDefProductionParams;
import org.cip4.jdflib.resource.process.JDFShapeTemplate;

public class PackagingGoldenTicket
extends MISGoldenTicket {
    public String shapeFile = "\\\\Server\\share\\dir\\CADOutput.cad";

    public PackagingGoldenTicket(int _icsLevel, JDFElement.EnumVersion jdfVersion, int _jmfLevel, int _misLevel, VJDFAttributeMap vPartMap) {
        super(_misLevel, jdfVersion, _jmfLevel);
        this.partIDKeys = null;
        this.vParts = vPartMap;
        this.icsLevel = _icsLevel;
        this.scheduleHours = 168;
        this.scheduleDuration = 48;
    }

    @Override
    public void init() {
        super.init();
        this.theNode.setType(JDFNode.EnumType.ProcessGroup);
        this.setActivePart(this.vParts, true);
    }

    public void createDieLayoutProduction() {
        this.theNode.addTypes(JDFNode.EnumType.DieLayoutProduction);
        JDFShapeDef shapeDef = (JDFShapeDef)this.theNode.getResource("ShapeDef", null, 0);
        if (shapeDef == null) {
            this.makeShapeDef(JDFResourceLink.EnumUsage.Input);
        }
        JDFDieLayoutProductionParams dlp = (JDFDieLayoutProductionParams)this.theNode.addResource("DieLayoutProductionParams", JDFResourceLink.EnumUsage.Input);
        dlp.setPosition(JDFAutoRefAnchor.EAnchor.TopCenter);
        JDFConvertingConfig cc = dlp.appendConvertingConfig();
        cc.setSheetHeightMM(650.0, 750.0);
        cc.setSheetWidthMM(950.0, 1050.0);
        JDFRepeatDesc rd = dlp.appendRepeatDesc();
        rd.setAllowedRotate(JDFAutoRepeatDesc.EnumAllowedRotate.Grain);
        rd.setLayoutStyle("StraightNest");
        JDFDieLayout dl = (JDFDieLayout)this.theNode.addResource("DieLayout", JDFResourceLink.EnumUsage.Output);
        dl.setDescriptiveName("this resource is filled in by the process");
    }

    public void createShapeDefProduction() {
        this.theNode.addTypes(JDFNode.EnumType.ShapeDefProduction);
        JDFShapeDefProductionParams sdpp = (JDFShapeDefProductionParams)this.theNode.addResource("ShapeDefProductionParams", JDFResourceLink.EnumUsage.Input);
        JDFShapeTemplate st = sdpp.appendShapeTemplate();
        JDFShape shape = new JDFShape(100.0, 500.0, 20.0);
        shape.scaleFromMM();
        st.setInnerDimensions(shape);
        st.setDescriptiveName("Box of size 100 * 500 * 20 millimeters");
        st.setStandard("FEFCO");
        st.setName("Type02");
        JDFFileSpec fs = st.appendFileSpec();
        fs.setAbsoluteFileURL(new File("\\\\Server\\share\\dir\\CADFile f\u00fcr mich.cad"), true);
        JDFObjectModel objModel = sdpp.appendObjectModel();
        objModel.appendFileSpec().setURL("http://vrml.file");
        JDFShapeDef sdOut = this.makeShapeDef(JDFResourceLink.EnumUsage.Output);
        JDFMedia m = sdOut.appendMedia();
        m.setDescriptiveName("Details of the box media");
        m.setMediaType(JDFAutoMedia.EnumMediaType.Paper);
        m.setProductID("MediaProductID");
    }

    private JDFShapeDef makeShapeDef(JDFResourceLink.EnumUsage usage) {
        JDFShapeDef shapeDef = (JDFShapeDef)this.theNode.addResource("ShapeDef", usage);
        shapeDef.setGeneralID("ShapeID", "ShapeDefinitionID");
        shapeDef.setGeneralID("ShapeName", "Shape Name");
        JDFShape size = new JDFShape(100.0, 70.0, 30.0);
        size.scaleFromMM();
        shapeDef.setDimensions(size);
        shapeDef.setGrainDirection(JDFAutoMedia.EnumGrainDirection.YDirection);
        JDFFileSpec fso = shapeDef.appendFileSpec();
        fso.setAbsoluteFileURL(new File(this.shapeFile), true);
        return shapeDef;
    }
}

