/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import java.util.Collection;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDeviceFilter;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFDeviceList;
import org.cip4.jdflib.util.EnumUtil;

public class JDFDeviceFilter
extends JDFAutoDeviceFilter {
    private static final long serialVersionUID = 1L;

    public JDFDeviceFilter(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDeviceFilter(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDeviceFilter(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDeviceFilter[  --> " + super.toString() + " ]";
    }

    public void applyTo(JDFDeviceList deviceList) {
        if (deviceList == null) {
            return;
        }
        Collection<JDFDeviceInfo> v = deviceList.getAllDeviceInfo();
        if (v == null) {
            return;
        }
        for (JDFDeviceInfo di : v) {
            JDFDeviceInfo di2 = this.applyTo(di);
            if (di2 != null) continue;
            deviceList.removeChild(di);
        }
    }

    private JDFDeviceInfo applyTo(JDFDeviceInfo deviceInfo) {
        if (deviceInfo != null) {
            JDFDevice dev;
            JDFAutoDeviceFilter.EnumDeviceDetails det = this.getDeviceDetails();
            if (EnumUtil.aLessThanB(det, JDFAutoDeviceFilter.EnumDeviceDetails.Capability) && (dev = deviceInfo.getDevice()) != null) {
                dev.removeChildren("DeviceCap", null, null);
            }
            if (EnumUtil.aLessEqualsThanB(det, JDFAutoDeviceFilter.EnumDeviceDetails.Brief)) {
                deviceInfo.removeChildren("ModuleStatus", null, null);
            }
            if (EnumUtil.aLessEqualsThanB(det, JDFAutoDeviceFilter.EnumDeviceDetails.Brief)) {
                deviceInfo.removeChildren("Device", null, null);
            }
            if (EnumUtil.aLessEqualsThanB(det, JDFAutoDeviceFilter.EnumDeviceDetails.None)) {
                JDFAttributeMap map = new JDFAttributeMap();
                map.putNotNull("DeviceID", deviceInfo.getDeviceID());
                map.putNotNull("DeviceStatus", deviceInfo.getDeviceStatus());
                map.putNotNull("DescriptiveName", deviceInfo.getDescriptiveName());
                deviceInfo.removeAttributes(null);
                deviceInfo.setAttributes(map);
            }
        }
        return deviceInfo;
    }
}

