/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoMessage;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.jmf.JDFAbortQueueEntryParams;
import org.cip4.jdflib.jmf.JDFDeviceFilter;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFEmployeeDef;
import org.cip4.jdflib.jmf.JDFFlushQueueInfo;
import org.cip4.jdflib.jmf.JDFFlushQueueParams;
import org.cip4.jdflib.jmf.JDFFlushResourceParams;
import org.cip4.jdflib.jmf.JDFFlushedResources;
import org.cip4.jdflib.jmf.JDFGangCmdFilter;
import org.cip4.jdflib.jmf.JDFGangInfo;
import org.cip4.jdflib.jmf.JDFGangQuFilter;
import org.cip4.jdflib.jmf.JDFIDInfo;
import org.cip4.jdflib.jmf.JDFJDFController;
import org.cip4.jdflib.jmf.JDFJDFService;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.jmf.JDFKnownMsgQuParams;
import org.cip4.jdflib.jmf.JDFMessageService;
import org.cip4.jdflib.jmf.JDFModifyNodeCmdParams;
import org.cip4.jdflib.jmf.JDFMsgFilter;
import org.cip4.jdflib.jmf.JDFNewJDFCmdParams;
import org.cip4.jdflib.jmf.JDFNewJDFQuParams;
import org.cip4.jdflib.jmf.JDFNodeInfoCmdParams;
import org.cip4.jdflib.jmf.JDFNodeInfoQuParams;
import org.cip4.jdflib.jmf.JDFNodeInfoResp;
import org.cip4.jdflib.jmf.JDFNotificationDef;
import org.cip4.jdflib.jmf.JDFOccupation;
import org.cip4.jdflib.jmf.JDFPipeParams;
import org.cip4.jdflib.jmf.JDFQueue;
import org.cip4.jdflib.jmf.JDFQueueEntry;
import org.cip4.jdflib.jmf.JDFQueueEntryDef;
import org.cip4.jdflib.jmf.JDFQueueEntryPosParams;
import org.cip4.jdflib.jmf.JDFQueueEntryPriParams;
import org.cip4.jdflib.jmf.JDFQueueFilter;
import org.cip4.jdflib.jmf.JDFQueueSubmissionParams;
import org.cip4.jdflib.jmf.JDFRequestQueueEntryParams;
import org.cip4.jdflib.jmf.JDFResourceCmdParams;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.jmf.JDFResourcePullParams;
import org.cip4.jdflib.jmf.JDFResourceQuParams;
import org.cip4.jdflib.jmf.JDFResubmissionParams;
import org.cip4.jdflib.jmf.JDFReturnQueueEntryParams;
import org.cip4.jdflib.jmf.JDFShutDownCmdParams;
import org.cip4.jdflib.jmf.JDFSignal;
import org.cip4.jdflib.jmf.JDFStatusQuParams;
import org.cip4.jdflib.jmf.JDFStopPersChParams;
import org.cip4.jdflib.jmf.JDFSubmissionMethods;
import org.cip4.jdflib.jmf.JDFSubscriptionFilter;
import org.cip4.jdflib.jmf.JDFSubscriptionInfo;
import org.cip4.jdflib.jmf.JDFTrackFilter;
import org.cip4.jdflib.jmf.JDFTrackResult;
import org.cip4.jdflib.jmf.JDFUpdateJDFCmdParams;
import org.cip4.jdflib.jmf.JDFWakeUpCmdParams;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFDeviceList;
import org.cip4.jdflib.resource.JDFQueueEntryDefList;
import org.cip4.jdflib.resource.process.JDFNotificationFilter;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class JDFMessage
extends JDFAutoMessage {
    private static final long serialVersionUID = 1L;
    private static boolean strictValidation = true;
    private static VString families = null;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[2];
    private static ElemInfoTable[] elemInfoTable;
    private static final String[] commandTypeObjString;
    private static final String[] registrationTypeObjString;
    private static final String[] queryTypeObjString;
    private static final String[] responseTypeObjString;
    private static String[] signalTypeObjString;
    private static String[] elemArray;

    public static boolean isStrictValidation() {
        return strictValidation;
    }

    public static void setStrictValidation(boolean strictValidation) {
        JDFMessage.strictValidation = strictValidation;
    }

    public JDFMessage(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFMessage(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFMessage(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    @Deprecated
    public boolean isMessageElement() {
        return true;
    }

    @Override
    public boolean init() {
        this.appendAnchor(null);
        return super.init();
    }

    @Override
    public String getIDPrefix() {
        return "m";
    }

    public EnumFamily getFamily() {
        return EnumFamily.getEnum(this.getLocalName());
    }

    @Override
    public String getType() {
        return this.getAttribute("Type", null, "");
    }

    @Override
    public void setType(String typ) {
        this.removeAttribute("type", "http://www.w3.org/2001/XMLSchema-instance");
        this.setAttribute("Type", typ, null);
        if (JDFMessage.xmlnsPrefix(typ) == null) {
            this.setXSIType(this.getLocalName() + typ);
        }
    }

    public void setQuery(JDFMessage q) {
        EnumFamily f = this.getFamily();
        if (f == null || f.equals(EnumFamily.Query) || f.equals(EnumFamily.Command) || f.equals(EnumFamily.Registration)) {
            String message = f == null ? "JDFMessage.setQuery: illegal family type " : "JDFMessage.setQuery: illegal family type " + f.getName();
            throw new JDFException(message);
        }
        if (q != null) {
            this.setVersion(q.getVersion(true));
            this.setrefID(q.getID());
            this.setType(q.getType());
        }
    }

    public static String typeString(EnumType value) {
        return value.toString();
    }

    @Deprecated
    public static String typeString() {
        String enums = "Unknown,Events,KnownControllers,KnownDevices,KnownJDFServices,KnownMessages,RepeatMessages,StopPersistentChannel,Occupation,Resource,Status,Track,PipeClose,PipePull,PipePush,PipePause,AbortQueueEntry,HoldQueueEntry,removeQueueEntry,ResubmitQueueEntry,ResumeQueueEntry,SetQueueEntryPosition,SetQueueEntryPriority,SubmitQueueEntry,CloseQueue,FlushQueue,HoldQueue,OpenQueue,QueueEntryStatus,QueueStatus,ResumeQueue,SubmissionMethods";
        return "Unknown,Events,KnownControllers,KnownDevices,KnownJDFServices,KnownMessages,RepeatMessages,StopPersistentChannel,Occupation,Resource,Status,Track,PipeClose,PipePull,PipePush,PipePause,AbortQueueEntry,HoldQueueEntry,removeQueueEntry,ResubmitQueueEntry,ResumeQueueEntry,SetQueueEntryPosition,SetQueueEntryPriority,SubmitQueueEntry,CloseQueue,FlushQueue,HoldQueue,OpenQueue,QueueEntryStatus,QueueStatus,ResumeQueue,SubmissionMethods";
    }

    @Deprecated
    public void setEnumType(EnumType value) {
        this.setType(value);
    }

    public void setType(EnumType value) {
        String typeName = value == null ? null : value.getName();
        this.setType(typeName);
    }

    public JDFJMF createResponse() {
        EnumFamily family = this.getFamily();
        if (family == null) {
            throw new JDFException("createResponse: creating resp from undefined message family");
        }
        JDFJMF jmf = JDFJMF.createJMF(EnumFamily.Response, null);
        jmf.getResponse(0).setQuery(this);
        return jmf;
    }

    public JDFJMF createSignal() {
        EnumFamily family = this.getFamily();
        if (family == null) {
            throw new JDFException("createResponse: creating resp from undefined message family");
        }
        JDFJMF jmf = JDFJMF.createJMF(EnumFamily.Signal, null);
        JDFSignal signal = jmf.getSignal(0);
        signal.setQuery(this);
        jmf.setVersion(this.getVersion(true));
        signal.copyElements(this.getChildElementVector(null, null), null);
        signal.removeChild("Subscription", null, 0);
        return jmf;
    }

    public boolean isValidMessageElement(String elementName, int iSkip) {
        boolean isFamilyTypeString;
        if (!JDFMessage.isInJDFNameSpaceStatic(this)) {
            return true;
        }
        String sTyp = this.getType();
        if (KElement.xmlnsPrefix(sTyp) != null || !JDFMessage.isInJDFNameSpaceStatic(this) || StringUtil.getNonEmpty(sTyp) == null) {
            return true;
        }
        if (elementName.equals("GeneralID") || elementName.equals("Comment")) {
            return true;
        }
        Object[] familyTypeObj = this.familyTypeObj();
        boolean bl = isFamilyTypeString = familyTypeObj == null ? false : ArrayUtils.contains((Object[])familyTypeObj, (Object)elementName);
        if (!isFamilyTypeString) {
            return false;
        }
        if (elementName.equals("Notification")) {
            return true;
        }
        EnumType typ = this.getEnumType();
        if (typ == null) {
            return false;
        }
        Set<EnumType> validList = this.getValidTypeVector(elementName, iSkip);
        return validList.contains(typ);
    }

    Set<EnumType> getValidTypeVector(String elementName, int iSkip) {
        HashSet<EnumType> validList = new HashSet<EnumType>();
        if (elementName.equals("FlushQueueParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.FlushQueue);
            }
        } else if (elementName.equals("FlushQueueInfo")) {
            if (iSkip == 0) {
                validList.add(EnumType.FlushQueue);
            }
        } else if (elementName.equals("FlushResourceParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.FlushResources);
            }
        } else if (elementName.equals("NewJDFCmdParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.NewJDF);
            }
        } else if (elementName.equals("NodeInfoCmdParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.NodeInfo);
            }
        } else if (elementName.equals("PipeParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.PipeClose);
                validList.add(EnumType.PipePush);
                validList.add(EnumType.PipePull);
                validList.add(EnumType.PipePause);
            }
        } else if (elementName.equals("QueueEntryDef")) {
            if (iSkip == 0) {
                validList.add(EnumType.AbortQueueEntry);
                validList.add(EnumType.HoldQueueEntry);
                validList.add(EnumType.RemoveQueueEntry);
                validList.add(EnumType.ResumeQueueEntry);
                validList.add(EnumType.SuspendQueueEntry);
            }
        } else if (elementName.equals("QueueEntryPriParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.SetQueueEntryPriority);
            }
        } else if (elementName.equals("QueueEntryPosParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.SetQueueEntryPosition);
            }
        } else if (elementName.equals("QueueFilter")) {
            if (iSkip == 0) {
                validList.add(EnumType.AbortQueueEntry);
                validList.add(EnumType.CloseQueue);
                validList.add(EnumType.FlushQueue);
                validList.add(EnumType.FlushResources);
                validList.add(EnumType.HoldQueue);
                validList.add(EnumType.HoldQueueEntry);
                validList.add(EnumType.OpenQueue);
                validList.add(EnumType.RemoveQueueEntry);
                validList.add(EnumType.ResourcePull);
                validList.add(EnumType.ResubmitQueueEntry);
                validList.add(EnumType.ResumeQueue);
                validList.add(EnumType.ResumeQueueEntry);
                validList.add(EnumType.SetQueueEntryPosition);
                validList.add(EnumType.SetQueueEntryPriority);
                validList.add(EnumType.ShutDown);
                validList.add(EnumType.SubmitQueueEntry);
                validList.add(EnumType.SuspendQueueEntry);
                validList.add(EnumType.QueueStatus);
            }
        } else if (elementName.equals("AbortQueueEntryParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.AbortQueueEntry);
            }
        } else if (elementName.equals("HoldQueueEntryParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.HoldQueueEntry);
            }
        } else if (elementName.equals("ResumeQueueEntryParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.ResumeQueueEntry);
            }
        } else if (elementName.equals("RemoveQueueEntryParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.RemoveQueueEntry);
            }
        } else if (elementName.equals("QueueSubmissionParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.SubmitQueueEntry);
            }
        } else if (elementName.equals("RequestQueueEntryParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.RequestQueueEntry);
            }
        } else if (elementName.equals("ResourceCmdParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.Resource);
            }
        } else if (elementName.equals("ResourcePullParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.ResourcePull);
            }
        } else if (elementName.equals("ResubmissionParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.ResubmitQueueEntry);
            }
        } else if (elementName.equals("ReturnQueueEntryParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.ReturnQueueEntry);
            }
        } else if (elementName.equals("ShutDownCmdParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.ShutDown);
            }
        } else if (elementName.equals("StopPersChParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.StopPersistentChannel);
            }
        } else if (elementName.equals("WakeUpCmdParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.WakeUp);
            }
        } else if (elementName.equals("DeviceFilter")) {
            if (iSkip == 0) {
                validList.add(EnumType.KnownDevices);
            }
        } else if (elementName.equals("EmployeeDef")) {
            validList.add(EnumType.Occupation);
        } else if (elementName.equals("KnownMsgQuParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.KnownMessages);
            }
        } else if (elementName.equals("MsgFilter")) {
            if (iSkip == 0) {
                validList.add(EnumType.RepeatMessages);
            }
        } else if (elementName.equals("NewJDFQuParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.NewJDF);
            }
        } else if (elementName.equals("NodeInfoQuParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.NodeInfo);
            }
        } else if (elementName.equals("NotificationFilter")) {
            if (iSkip == 0) {
                validList.add(EnumType.Events);
                validList.add(EnumType.Notification);
            }
        } else if (elementName.equals("QueueEntryDefList")) {
            if (iSkip == 0) {
                validList.add(EnumType.QueueEntryStatus);
            }
        } else if (elementName.equals("ResourceQuParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.Resource);
            }
        } else if (elementName.equals("StatusQuParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.Status);
            }
        } else if (elementName.equals("TrackFilter")) {
            if (iSkip == 0) {
                validList.add(EnumType.Track);
            }
        } else if (elementName.equals("DeviceList")) {
            if (iSkip == 0) {
                validList.add(EnumType.KnownDevices);
            }
        } else if (elementName.equals("DeviceInfo")) {
            if (iSkip == 0) {
                validList.add(EnumType.ShutDown);
                validList.add(EnumType.WakeUp);
            }
            validList.add(EnumType.Status);
        } else if (elementName.equals("FlushedResources")) {
            if (iSkip == 0) {
                validList.add(EnumType.FlushResources);
            }
        } else if (elementName.equals("IDInfo")) {
            validList.add(EnumType.NewJDF);
        } else if (elementName.equals("JDFController")) {
            validList.add(EnumType.KnownControllers);
        } else if (elementName.equals("JDFService")) {
            validList.add(EnumType.KnownJDFServices);
        } else if (elementName.equals("JobPhase")) {
            if (iSkip == 0) {
                validList.add(EnumType.PipeClose);
                validList.add(EnumType.PipePush);
                validList.add(EnumType.PipePull);
                validList.add(EnumType.PipePause);
            }
        } else if (elementName.equals("MessageService")) {
            validList.add(EnumType.KnownMessages);
        } else if (elementName.equals("NodeInfoResp")) {
            validList.add(EnumType.NodeInfo);
        } else if (elementName.equals("NotificationDef")) {
            validList.add(EnumType.Events);
        } else if (elementName.equals("Occupation")) {
            validList.add(EnumType.Occupation);
        } else if (elementName.equals("Queue")) {
            if (iSkip == 0) {
                validList.add(EnumType.AbortQueueEntry);
                validList.add(EnumType.CloseQueue);
                validList.add(EnumType.FlushQueue);
                validList.add(EnumType.HoldQueue);
                validList.add(EnumType.HoldQueueEntry);
                validList.add(EnumType.OpenQueue);
                validList.add(EnumType.QueueStatus);
                validList.add(EnumType.RemoveQueueEntry);
                validList.add(EnumType.ResourcePull);
                validList.add(EnumType.ResumeQueue);
                validList.add(EnumType.ResubmitQueueEntry);
                validList.add(EnumType.ResumeQueueEntry);
                validList.add(EnumType.SetQueueEntryPosition);
                validList.add(EnumType.SetQueueEntryPriority);
                validList.add(EnumType.ShutDown);
                validList.add(EnumType.Status);
                validList.add(EnumType.SubmitQueueEntry);
                validList.add(EnumType.SuspendQueueEntry);
            }
        } else if (elementName.equals("QueueEntry")) {
            if (iSkip == 0) {
                validList.add(EnumType.ResourcePull);
                validList.add(EnumType.SubmitQueueEntry);
            }
            validList.add(EnumType.QueueEntryStatus);
        } else if (elementName.equals("ResourceInfo")) {
            validList.add(EnumType.Resource);
        } else if (elementName.equals("SubmissionMethods")) {
            if (iSkip == 0) {
                validList.add(EnumType.SubmissionMethods);
            }
        } else if (elementName.equals("SubscriptionFilter")) {
            if (iSkip == 0) {
                validList.add(EnumType.KnownSubscriptions);
            }
        } else if (elementName.equals("SubscriptionInfo")) {
            validList.add(EnumType.KnownSubscriptions);
        } else if (elementName.equals("TrackResult")) {
            validList.add(EnumType.Track);
        } else if (elementName.equals("UpdateJDFCmdParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.UpdateJDF);
            }
        } else if (elementName.equals("ModifyNodeCmdParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.ModifyNode);
            }
        } else if (elementName.equals("AuthenticationCmdParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.RequestForAuthentication);
            }
        } else if (elementName.equals("AuthenticationQuParams")) {
            if (iSkip == 0) {
                validList.add(EnumType.RequestForAuthentication);
            }
        } else if (elementName.equals("AuthenticationResp")) {
            if (iSkip == 0) {
                validList.add(EnumType.RequestForAuthentication);
            }
        } else if (elementName.equals("ControllerFilter")) {
            if (iSkip == 0) {
                validList.add(EnumType.KnownControllers);
            }
        } else if (elementName.equals("GangInfo")) {
            validList.add(EnumType.GangStatus);
        } else if (elementName.equals("GangQuFilter")) {
            if (iSkip == 0) {
                validList.add(EnumType.GangStatus);
            }
        } else if (elementName.equals("GangCmdFilter")) {
            if (iSkip == 0) {
                validList.add(EnumType.ForceGang);
            }
        } else if (EnumFamily.getEnum(elementName) != null) {
            validList.add(EnumType.RepeatMessages);
        }
        return validList;
    }

    public EnumType getEnumType() {
        return EnumType.getEnum(this.getAttribute("Type", null, null));
    }

    private String[] familyTypeObj() {
        EnumFamily family = this.getFamily();
        if (family == null) {
            return null;
        }
        if (family.equals(EnumFamily.Command)) {
            return commandTypeObjString;
        }
        if (family.equals(EnumFamily.Registration)) {
            return registrationTypeObjString;
        }
        if (family.equals(EnumFamily.Query)) {
            return queryTypeObjString;
        }
        if (family.equals(EnumFamily.Response) || family.equals(EnumFamily.Acknowledge)) {
            return responseTypeObjString;
        }
        if (family.equals(EnumFamily.Signal)) {
            return signalTypeObjString;
        }
        return null;
    }

    private static String[] initSignal() {
        VString v = new VString(queryTypeObjString);
        v.addAll(responseTypeObjString);
        v.unify();
        return v.toArray(new String[v.size()]);
    }

    public KElement appendValidElement(String elementName, String nameSpaceURI) {
        int iSkip;
        if (strictValidation && !this.isValidMessageElement(elementName, iSkip = this.numChildElements(elementName, nameSpaceURI))) {
            throw new JDFException("AppendValidElement: illegal element: " + elementName);
        }
        return this.appendElement(elementName, nameSpaceURI);
    }

    @Deprecated
    public KElement appendValidElement(String elementName) {
        return this.appendValidElement(elementName, null);
    }

    public KElement getValidElement(String nodeName, String nameSpaceURI, int iSkip) {
        if (strictValidation && !this.isValidMessageElement(nodeName, iSkip)) {
            throw new JDFException("getValidElement: illegal element :" + nodeName + " Family=" + this.getLocalName() + " Type=" + this.getType() + " ID=" + this.getID());
        }
        return this.getElement_JDFElement(nodeName, nameSpaceURI, iSkip);
    }

    public KElement getCreateValidElement(String nodeName, String nameSpaceURI, int iSkip) {
        if (strictValidation && !this.isValidMessageElement(nodeName, iSkip)) {
            throw new JDFException("getCreateValidElement: illegal element :" + nodeName);
        }
        return this.getCreateElement_KElement(nodeName, nameSpaceURI, iSkip);
    }

    public JDFDevice getCreateDevice(int iSkip) {
        JDFDevice e = (JDFDevice)this.getCreateValidElement("Device", null, iSkip);
        return e;
    }

    public JDFDevice appendDevice() {
        JDFDevice e = (JDFDevice)this.appendValidElement("Device", null);
        return e;
    }

    public JDFDevice getDevice(int iSkip) {
        return (JDFDevice)this.getValidElement("Device", null, iSkip);
    }

    public JDFDeviceFilter getCreateDeviceFilter(int iSkip) {
        JDFDeviceFilter e = (JDFDeviceFilter)this.getCreateValidElement("DeviceFilter", null, iSkip);
        return e;
    }

    public JDFDeviceFilter appendDeviceFilter() {
        return (JDFDeviceFilter)this.appendValidElement("DeviceFilter", null);
    }

    public JDFDeviceFilter getDeviceFilter(int iSkip) {
        return (JDFDeviceFilter)this.getValidElement("DeviceFilter", null, iSkip);
    }

    public JDFDeviceInfo getCreateDeviceInfo(int iSkip) {
        return (JDFDeviceInfo)this.getCreateValidElement("DeviceInfo", null, iSkip);
    }

    public JDFDeviceInfo appendDeviceInfo() {
        return (JDFDeviceInfo)this.appendValidElement("DeviceInfo", null);
    }

    public JDFDeviceInfo getDeviceInfo(int iSkip) {
        return (JDFDeviceInfo)this.getValidElement("DeviceInfo", null, iSkip);
    }

    public JDFDeviceInfo getDeviceInfo(String deviceID) {
        JDFDevice dev;
        if (strictValidation && !this.isValidMessageElement("DeviceInfo", 0)) {
            throw new JDFException("getValidElement: illegal element :DeviceInfo");
        }
        JDFDeviceInfo d = (JDFDeviceInfo)this.getChildWithAttribute("DeviceInfo", "DeviceID", null, deviceID, 0, true);
        if (d == null && (dev = (JDFDevice)this.getChildWithAttribute("Device", "DeviceID", null, deviceID, 0, false)) != null) {
            d = (JDFDeviceInfo)dev.getParentNode_KElement();
        }
        return d;
    }

    public JDFDeviceInfo getCreateDeviceInfo(String deviceID) {
        JDFDeviceInfo d = this.getDeviceInfo(deviceID);
        if (d == null) {
            d = this.appendDeviceInfo();
            d.setDeviceID(deviceID);
        }
        return d;
    }

    public JDFDeviceList getCreateDeviceList(int iSkip) {
        return (JDFDeviceList)this.getCreateValidElement("DeviceList", null, iSkip);
    }

    public JDFDeviceList appendDeviceList() {
        return (JDFDeviceList)this.appendValidElement("DeviceList", null);
    }

    public JDFDeviceList getDeviceList(int iSkip) {
        return (JDFDeviceList)this.getValidElement("DeviceList", null, iSkip);
    }

    public JDFEmployeeDef getCreateEmployeeDef(int iSkip) {
        return (JDFEmployeeDef)this.getCreateValidElement("EmployeeDef", null, iSkip);
    }

    public JDFEmployeeDef appendEmployeeDef() {
        return (JDFEmployeeDef)this.appendValidElement("EmployeeDef", null);
    }

    public JDFEmployeeDef getEmployeeDef(int iSkip) {
        return (JDFEmployeeDef)this.getValidElement("EmployeeDef", null, iSkip);
    }

    public JDFJDFController getCreateJDFController(int iSkip) {
        return (JDFJDFController)this.getCreateValidElement("JDFController", null, iSkip);
    }

    public JDFJDFController appendJDFController() {
        return (JDFJDFController)this.appendValidElement("JDFController", null);
    }

    public JDFJDFController getJDFController(int iSkip) {
        return (JDFJDFController)this.getValidElement("JDFController", null, iSkip);
    }

    public JDFJDFService getCreateJDFService(int iSkip) {
        return (JDFJDFService)this.getCreateValidElement("JDFService", null, iSkip);
    }

    public JDFJDFService appendJDFService() {
        return (JDFJDFService)this.appendValidElement("JDFService", null);
    }

    public JDFJDFService getJDFService(int iSkip) {
        return (JDFJDFService)this.getValidElement("JDFService", null, iSkip);
    }

    public JDFGangInfo getCreateGangInfo(int iSkip) {
        return (JDFGangInfo)this.getCreateValidElement("GangInfo", null, iSkip);
    }

    public JDFGangInfo appendGangInfo() {
        return (JDFGangInfo)this.appendValidElement("GangInfo", null);
    }

    public JDFGangInfo getGangInfo(int iSkip) {
        return (JDFGangInfo)this.getValidElement("GangInfo", null, iSkip);
    }

    public JDFJobPhase getCreateJobPhase(int iSkip) {
        return (JDFJobPhase)this.getValidElement("JobPhase", null, iSkip);
    }

    public JDFJobPhase appendJobPhase() {
        return (JDFJobPhase)this.appendValidElement("JobPhase", null);
    }

    public JDFJobPhase getJobPhase(int iSkip) {
        return (JDFJobPhase)this.getValidElement("JobPhase", null, iSkip);
    }

    public JDFKnownMsgQuParams getCreateKnownMsgQuParams(int iSkip) {
        return (JDFKnownMsgQuParams)this.getCreateValidElement("KnownMsgQuParams", null, iSkip);
    }

    public JDFKnownMsgQuParams appendKnownMsgQuParams() {
        return (JDFKnownMsgQuParams)this.appendValidElement("KnownMsgQuParams", null);
    }

    public JDFKnownMsgQuParams getKnownMsgQuParams(int iSkip) {
        return (JDFKnownMsgQuParams)this.getValidElement("KnownMsgQuParams", null, iSkip);
    }

    public JDFMessageService getCreateMessageService(int iSkip) {
        return (JDFMessageService)this.getCreateValidElement("MessageService", null, iSkip);
    }

    public JDFMessageService appendMessageService() {
        return (JDFMessageService)this.appendValidElement("MessageService", null);
    }

    public JDFMessageService getMessageService(int iSkip) {
        return (JDFMessageService)this.getValidElement("MessageService", null, iSkip);
    }

    public JDFMsgFilter getCreateMsgFilter(int iSkip) {
        return (JDFMsgFilter)this.getCreateValidElement("MsgFilter", null, iSkip);
    }

    public JDFMsgFilter appendMsgFilter() {
        return (JDFMsgFilter)this.appendValidElement("MsgFilter", null);
    }

    public JDFMsgFilter getMsgFilter(int iSkip) {
        return (JDFMsgFilter)this.getValidElement("MsgFilter", null, iSkip);
    }

    public JDFNotificationDef getCreateNotificationDef(int iSkip) {
        return (JDFNotificationDef)this.getCreateValidElement("NotificationDef", null, iSkip);
    }

    public JDFNotificationDef appendNotificationDef() {
        return (JDFNotificationDef)this.appendValidElement("NotificationDef", null);
    }

    public JDFNotificationDef getNotificationDef(int iSkip) {
        return (JDFNotificationDef)this.getValidElement("NotificationDef", null, iSkip);
    }

    public JDFNotificationFilter getCreateNotificationFilter(int iSkip) {
        return (JDFNotificationFilter)this.getCreateValidElement("NotificationFilter", null, iSkip);
    }

    public JDFNotificationFilter appendNotificationFilter() {
        return (JDFNotificationFilter)this.appendValidElement("NotificationFilter", null);
    }

    public JDFNotificationFilter getNotificationFilter(int iSkip) {
        return (JDFNotificationFilter)this.getValidElement("NotificationFilter", null, iSkip);
    }

    public JDFOccupation getCreateOccupation(int iSkip) {
        return (JDFOccupation)this.getCreateValidElement("Occupation", null, iSkip);
    }

    public JDFOccupation appendOccupation() {
        return (JDFOccupation)this.appendValidElement("Occupation", null);
    }

    public JDFOccupation getOccupation(int iSkip) {
        return (JDFOccupation)this.getValidElement("Occupation", null, iSkip);
    }

    public JDFPipeParams getCreatePipeParams(int iSkip) {
        return (JDFPipeParams)this.getCreateValidElement("PipeParams", null, iSkip);
    }

    public JDFPipeParams appendPipeParams() {
        return (JDFPipeParams)this.appendValidElement("PipeParams", null);
    }

    public JDFPipeParams getPipeParams() {
        return (JDFPipeParams)this.getValidElement("PipeParams", null, 0);
    }

    @Deprecated
    public JDFPipeParams getPipeParams(int iSkip) {
        return (JDFPipeParams)this.getValidElement("PipeParams", null, iSkip);
    }

    public JDFQueue getCreateQueue(int iSkip) {
        return (JDFQueue)this.getCreateValidElement("Queue", null, iSkip);
    }

    public JDFQueue appendQueue() {
        return (JDFQueue)this.appendValidElement("Queue", null);
    }

    public JDFQueue getQueue(int iSkip) {
        return (JDFQueue)this.getValidElement("Queue", null, iSkip);
    }

    public JDFQueueEntry getCreateQueueEntry(int iSkip) {
        return (JDFQueueEntry)this.getCreateValidElement("QueueEntry", null, iSkip);
    }

    public JDFQueueEntry appendQueueEntry() {
        return (JDFQueueEntry)this.appendValidElement("QueueEntry", null);
    }

    public JDFQueueEntry getQueueEntry(int iSkip) {
        return (JDFQueueEntry)this.getValidElement("QueueEntry", null, iSkip);
    }

    public JDFQueueEntryDef getCreateQueueEntryDef(int iSkip) {
        return (JDFQueueEntryDef)this.getCreateValidElement("QueueEntryDef", null, iSkip);
    }

    public JDFQueueEntryDef appendQueueEntryDef() {
        return (JDFQueueEntryDef)this.appendValidElement("QueueEntryDef", null);
    }

    public JDFQueueEntryDef getQueueEntryDef(int iSkip) {
        return (JDFQueueEntryDef)this.getValidElement("QueueEntryDef", null, iSkip);
    }

    public JDFQueueEntryDefList getCreateQueueEntryDefList(int iSkip) {
        return (JDFQueueEntryDefList)this.getCreateValidElement("QueueEntryDefList", null, iSkip);
    }

    public JDFQueueEntryDefList appendQueueEntryDefList() {
        return (JDFQueueEntryDefList)this.appendValidElement("QueueEntryDefList", null);
    }

    public JDFQueueEntryDefList getQueueEntryDefList(int iSkip) {
        return (JDFQueueEntryDefList)this.getValidElement("QueueEntryDefList", null, iSkip);
    }

    public JDFQueueEntryPriParams getCreateQueueEntryPriParams(int iSkip) {
        return (JDFQueueEntryPriParams)this.getCreateValidElement("QueueEntryPriParams", null, iSkip);
    }

    public JDFQueueEntryPriParams appendQueueEntryPriParams() {
        return (JDFQueueEntryPriParams)this.appendValidElement("QueueEntryPriParams", null);
    }

    public JDFQueueEntryPriParams getQueueEntryPriParams(int iSkip) {
        return (JDFQueueEntryPriParams)this.getValidElement("QueueEntryPriParams", null, iSkip);
    }

    public JDFQueueEntryPosParams getCreateQueueEntryPosParams(int iSkip) {
        return (JDFQueueEntryPosParams)this.getCreateValidElement("QueueEntryPosParams", null, iSkip);
    }

    public JDFQueueEntryPosParams appendQueueEntryPosParams() {
        return (JDFQueueEntryPosParams)this.appendValidElement("QueueEntryPosParams", null);
    }

    public JDFQueueEntryPosParams getQueueEntryPosParams(int iSkip) {
        return (JDFQueueEntryPosParams)this.getValidElement("QueueEntryPosParams", null, iSkip);
    }

    public JDFQueueSubmissionParams getCreateQueueSubmissionParams(int iSkip) {
        return (JDFQueueSubmissionParams)this.getCreateValidElement("QueueSubmissionParams", null, iSkip);
    }

    public JDFQueueSubmissionParams appendQueueSubmissionParams() {
        return (JDFQueueSubmissionParams)this.appendValidElement("QueueSubmissionParams", null);
    }

    public JDFQueueSubmissionParams getQueueSubmissionParams(int iSkip) {
        return (JDFQueueSubmissionParams)this.getValidElement("QueueSubmissionParams", null, iSkip);
    }

    public JDFResourceCmdParams getCreateResourceCmdParams(int iSkip) {
        return (JDFResourceCmdParams)this.getCreateValidElement("ResourceCmdParams", null, iSkip);
    }

    public JDFResourceCmdParams appendResourceCmdParams() {
        return (JDFResourceCmdParams)this.appendValidElement("ResourceCmdParams", null);
    }

    public JDFResourceCmdParams getResourceCmdParams(int iSkip) {
        return (JDFResourceCmdParams)this.getValidElement("ResourceCmdParams", null, iSkip);
    }

    public JDFResourceQuParams getCreateResourceQuParams(int iSkip) {
        return (JDFResourceQuParams)this.getCreateValidElement("ResourceQuParams", null, iSkip);
    }

    public JDFResourceQuParams appendResourceQuParams() {
        return (JDFResourceQuParams)this.appendValidElement("ResourceQuParams", null);
    }

    @Deprecated
    public JDFResourceQuParams getResourceQuParams(int iSkip) {
        return (JDFResourceQuParams)this.getValidElement("ResourceQuParams", null, iSkip);
    }

    public JDFResourceQuParams getResourceQuParams() {
        return (JDFResourceQuParams)this.getValidElement("ResourceQuParams", null, 0);
    }

    public JDFResourceInfo getCreateResourceInfo(int iSkip) {
        return (JDFResourceInfo)this.getCreateValidElement("ResourceInfo", null, iSkip);
    }

    public JDFResourceInfo appendResourceInfo() {
        return (JDFResourceInfo)this.appendValidElement("ResourceInfo", null);
    }

    public JDFResourceInfo getResourceInfo(int iSkip) {
        return (JDFResourceInfo)this.getValidElement("ResourceInfo", null, iSkip);
    }

    public JDFStatusQuParams getCreateStatusQuParams(int iSkip) {
        return (JDFStatusQuParams)this.getCreateValidElement("StatusQuParams", null, iSkip);
    }

    public JDFStatusQuParams appendStatusQuParams() {
        return (JDFStatusQuParams)this.appendValidElement("StatusQuParams", null);
    }

    @Deprecated
    public JDFStatusQuParams getStatusQuParams(int iSkip) {
        return (JDFStatusQuParams)this.getValidElement("StatusQuParams", null, iSkip);
    }

    public JDFStatusQuParams getStatusQuParams() {
        return (JDFStatusQuParams)this.getValidElement("StatusQuParams", null, 0);
    }

    public JDFStopPersChParams getCreateStopPersChParams(int iSkip) {
        return (JDFStopPersChParams)this.getCreateValidElement("StopPersChParams", null, iSkip);
    }

    public JDFStopPersChParams appendStopPersChParams() {
        return (JDFStopPersChParams)this.appendValidElement("StopPersChParams", null);
    }

    public JDFStopPersChParams getStopPersChParams(int iSkip) {
        return (JDFStopPersChParams)this.getValidElement("StopPersChParams", null, iSkip);
    }

    public JDFSubmissionMethods getCreateSubmissionMethods(int iSkip) {
        return (JDFSubmissionMethods)this.getCreateValidElement("SubmissionMethods", null, iSkip);
    }

    public JDFSubmissionMethods appendSubmissionMethods() {
        return (JDFSubmissionMethods)this.appendValidElement("SubmissionMethods", null);
    }

    public JDFSubmissionMethods getSubmissionMethods(int iSkip) {
        return (JDFSubmissionMethods)this.getValidElement("SubmissionMethods", null, iSkip);
    }

    public JDFTrackFilter getCreateTrackFilter(int iSkip) {
        return (JDFTrackFilter)this.getCreateValidElement("TrackFilter", null, iSkip);
    }

    public JDFTrackFilter appendTrackFilter() {
        return (JDFTrackFilter)this.appendValidElement("TrackFilter", null);
    }

    public JDFTrackFilter getTrackFilter(int iSkip) {
        return (JDFTrackFilter)this.getValidElement("TrackFilter", null, iSkip);
    }

    public JDFTrackResult getCreateTrackResult(int iSkip) {
        return (JDFTrackResult)this.getCreateValidElement("TrackResult", null, iSkip);
    }

    public JDFTrackResult appendTrackResult() {
        return (JDFTrackResult)this.appendValidElement("TrackResult", null);
    }

    public JDFTrackResult getTrackResult(int iSkip) {
        return (JDFTrackResult)this.getValidElement("TrackResult", null, iSkip);
    }

    public int getReturnCode() {
        return this.getIntAttribute("ReturnCode", null, 0);
    }

    public JDFIDInfo getCreateIDInfo(int iSkip) {
        return (JDFIDInfo)this.getCreateValidElement("IDInfo", null, iSkip);
    }

    public JDFIDInfo appendIDInfo() {
        return (JDFIDInfo)this.appendValidElement("IDInfo", null);
    }

    public JDFIDInfo getIDInfo(int iSkip) {
        return (JDFIDInfo)this.getValidElement("IDInfo", null, iSkip);
    }

    public JDFGangQuFilter appendGangQuFilter() {
        return (JDFGangQuFilter)this.appendValidElement("GangQuFilter", null);
    }

    public JDFGangQuFilter getJDFGangQuFilter(int iSkip) {
        return (JDFGangQuFilter)this.getValidElement("GangQuFilter", null, iSkip);
    }

    public JDFGangCmdFilter appendGangCmdFilter() {
        return (JDFGangCmdFilter)this.appendValidElement("GangCmdFilter", null);
    }

    public JDFGangCmdFilter getJDFGangCmdFilter(int iSkip) {
        return (JDFGangCmdFilter)this.getValidElement("GangCmdFilter", null, iSkip);
    }

    public JDFFlushedResources getCreateFlushedResources(int iSkip) {
        return (JDFFlushedResources)this.getCreateValidElement("FlushedResources", null, iSkip);
    }

    public JDFFlushedResources appendFlushedResources() {
        return (JDFFlushedResources)this.appendValidElement("FlushedResources", null);
    }

    public JDFFlushedResources getFlushedResources(int iSkip) {
        return (JDFFlushedResources)this.getValidElement("FlushedResources", null, iSkip);
    }

    public JDFFlushQueueParams getCreateFlushQueueParams(int iSkip) {
        return (JDFFlushQueueParams)this.getCreateValidElement("FlushQueueParams", null, iSkip);
    }

    public JDFFlushQueueInfo getCreateFlushQueueInfo(int iSkip) {
        return (JDFFlushQueueInfo)this.getCreateValidElement("FlushQueueInfo", null, iSkip);
    }

    public JDFFlushQueueInfo getFlushQueueInfo(int iSkip) {
        return (JDFFlushQueueInfo)this.getValidElement("FlushQueueInfo", null, iSkip);
    }

    public JDFAbortQueueEntryParams appendAbortQueueEntryParams() {
        return (JDFAbortQueueEntryParams)this.appendValidElement("AbortQueueEntryParams", null);
    }

    public JDFAbortQueueEntryParams getAbortQueueEntryParams() {
        return (JDFAbortQueueEntryParams)this.getValidElement("AbortQueueEntryParams", null, 0);
    }

    public JDFAbortQueueEntryParams getCreateAbortQueueEntryParams() {
        return (JDFAbortQueueEntryParams)this.getCreateValidElement("AbortQueueEntryParams", null, 0);
    }

    public JDFFlushQueueParams appendFlushQueueParams() {
        return (JDFFlushQueueParams)this.appendValidElement("FlushQueueParams", null);
    }

    public JDFFlushQueueInfo appendFlushQueueInfo() {
        return (JDFFlushQueueInfo)this.appendValidElement("FlushQueueInfo", null);
    }

    public JDFFlushQueueParams getFlushQueueParams(int iSkip) {
        return (JDFFlushQueueParams)this.getValidElement("FlushQueueParams", null, iSkip);
    }

    public JDFFlushResourceParams getCreateFlushResourceParams(int iSkip) {
        return (JDFFlushResourceParams)this.getCreateValidElement("FlushResourceParams", null, iSkip);
    }

    public JDFFlushResourceParams appendFlushResourceParams() {
        return (JDFFlushResourceParams)this.appendValidElement("FlushResourceParams", null);
    }

    public JDFFlushResourceParams getFlushResourceParams(int iSkip) {
        return (JDFFlushResourceParams)this.getValidElement("FlushResourceParams", null, iSkip);
    }

    public JDFNewJDFCmdParams getCreateNewJDFCmdParams(int iSkip) {
        return (JDFNewJDFCmdParams)this.getCreateValidElement("NewJDFCmdParams", null, iSkip);
    }

    public JDFNewJDFCmdParams appendNewJDFCmdParams() {
        return (JDFNewJDFCmdParams)this.appendValidElement("NewJDFCmdParams", null);
    }

    public JDFNewJDFCmdParams getNewJDFCmdParams(int iSkip) {
        return (JDFNewJDFCmdParams)this.getValidElement("NewJDFCmdParams", null, iSkip);
    }

    public JDFNewJDFQuParams getCreateNewJDFQuParams(int iSkip) {
        return (JDFNewJDFQuParams)this.getCreateValidElement("NewJDFQuParams", null, iSkip);
    }

    public JDFNewJDFQuParams appendNewJDFQuParams() {
        return (JDFNewJDFQuParams)this.appendValidElement("NewJDFQuParams", null);
    }

    public JDFNewJDFQuParams getNewJDFQuParams(int iSkip) {
        return (JDFNewJDFQuParams)this.getValidElement("NewJDFQuParams", null, iSkip);
    }

    public JDFNodeInfoCmdParams getCreateNodeInfoCmdParams(int iSkip) {
        return (JDFNodeInfoCmdParams)this.getCreateValidElement("NodeInfoCmdParams", null, iSkip);
    }

    public JDFNodeInfoCmdParams appendNodeInfoCmdParams() {
        return (JDFNodeInfoCmdParams)this.appendValidElement("NodeInfoCmdParams", null);
    }

    public JDFNodeInfoCmdParams getNodeInfoCmdParams(int iSkip) {
        return (JDFNodeInfoCmdParams)this.getValidElement("NodeInfoCmdParams", null, iSkip);
    }

    public JDFNodeInfoQuParams getCreateNodeInfoQuParams(int iSkip) {
        return (JDFNodeInfoQuParams)this.getCreateValidElement("NodeInfoQuParams", null, iSkip);
    }

    public JDFNodeInfoQuParams appendNodeInfoQuParams() {
        return (JDFNodeInfoQuParams)this.appendValidElement("NodeInfoQuParams", null);
    }

    public JDFNodeInfoQuParams getNodeInfoQuParams(int iSkip) {
        return (JDFNodeInfoQuParams)this.getValidElement("NodeInfoQuParams", null, iSkip);
    }

    public JDFNodeInfoResp getCreateNodeInfoResp(int iSkip) {
        return (JDFNodeInfoResp)this.getCreateValidElement("NodeInfoResp", null, iSkip);
    }

    public JDFNodeInfoResp appendNodeInfoResp() {
        return (JDFNodeInfoResp)this.appendValidElement("NodeInfoResp", null);
    }

    public JDFNodeInfoResp getNodeInfoResp(int iSkip) {
        return (JDFNodeInfoResp)this.getValidElement("NodeInfoResp", null, iSkip);
    }

    public JDFQueueFilter getCreateQueueFilter(int iSkip) {
        return (JDFQueueFilter)this.getCreateValidElement("QueueFilter", null, iSkip);
    }

    public JDFQueueFilter appendQueueFilter() {
        return (JDFQueueFilter)this.appendValidElement("QueueFilter", null);
    }

    public JDFQueueFilter getQueueFilter(int iSkip) {
        return (JDFQueueFilter)this.getValidElement("QueueFilter", null, iSkip);
    }

    public JDFRequestQueueEntryParams getCreateRequestQueueEntryParams(int iSkip) {
        return (JDFRequestQueueEntryParams)this.getCreateValidElement("RequestQueueEntryParams", null, iSkip);
    }

    public JDFRequestQueueEntryParams appendRequestQueueEntryParams() {
        return (JDFRequestQueueEntryParams)this.appendValidElement("RequestQueueEntryParams", null);
    }

    public JDFRequestQueueEntryParams getRequestQueueEntryParams(int iSkip) {
        return (JDFRequestQueueEntryParams)this.getValidElement("RequestQueueEntryParams", null, iSkip);
    }

    JDFResourcePullParams getCreateResourcePullParams(int iSkip) {
        return (JDFResourcePullParams)this.getCreateValidElement("ResourcePullParams", null, iSkip);
    }

    public JDFResourcePullParams appendResourcePullParams() {
        return (JDFResourcePullParams)this.appendValidElement("ResourcePullParams", null);
    }

    public JDFResourcePullParams getResourcePullParams(int iSkip) {
        return (JDFResourcePullParams)this.getValidElement("ResourcePullParams", null, iSkip);
    }

    public JDFResubmissionParams getCreateResubmissionParams(int iSkip) {
        return (JDFResubmissionParams)this.getCreateValidElement("ResubmissionParams", null, iSkip);
    }

    public JDFResubmissionParams appendResubmissionParams() {
        return (JDFResubmissionParams)this.appendValidElement("ResubmissionParams", null);
    }

    public JDFResubmissionParams getResubmissionParams(int iSkip) {
        return (JDFResubmissionParams)this.getValidElement("ResubmissionParams", null, iSkip);
    }

    public JDFReturnQueueEntryParams getCreateReturnQueueEntryParams(int iSkip) {
        return (JDFReturnQueueEntryParams)this.getCreateValidElement("ReturnQueueEntryParams", null, iSkip);
    }

    public JDFReturnQueueEntryParams appendReturnQueueEntryParams() {
        return (JDFReturnQueueEntryParams)this.appendValidElement("ReturnQueueEntryParams", null);
    }

    public JDFReturnQueueEntryParams getReturnQueueEntryParams(int iSkip) {
        return (JDFReturnQueueEntryParams)this.getValidElement("ReturnQueueEntryParams", null, iSkip);
    }

    public JDFSubscriptionInfo getCreateSubscriptionInfo(int iSkip) {
        return (JDFSubscriptionInfo)this.getCreateValidElement("SubscriptionInfo", null, iSkip);
    }

    public JDFSubscriptionInfo appendSubscriptionInfo() {
        return (JDFSubscriptionInfo)this.appendValidElement("SubscriptionInfo", null);
    }

    public JDFSubscriptionInfo getSubscriptionInfo(int iSkip) {
        return (JDFSubscriptionInfo)this.getValidElement("SubscriptionInfo", null, iSkip);
    }

    public JDFSubscriptionFilter getSubscriptionFilter() {
        return (JDFSubscriptionFilter)this.getValidElement("SubscriptionFilter", null, 0);
    }

    public JDFSubscriptionFilter getCreateSubscriptionFilter() {
        return (JDFSubscriptionFilter)this.getCreateValidElement("SubscriptionFilter", null, 0);
    }

    public JDFSubscriptionFilter appendSubscriptionFilter() {
        return (JDFSubscriptionFilter)this.appendValidElement("SubscriptionFilter", null);
    }

    public JDFShutDownCmdParams getCreateShutDownCmdParams(int iSkip) {
        return (JDFShutDownCmdParams)this.getCreateValidElement("ShutDownCmdParams", null, iSkip);
    }

    public JDFShutDownCmdParams appendShutDownCmdParams() {
        return (JDFShutDownCmdParams)this.appendValidElement("ShutDownCmdParams", null);
    }

    public JDFShutDownCmdParams getShutDownCmdParams(int iSkip) {
        return (JDFShutDownCmdParams)this.getValidElement("ShutDownCmdParams", null, iSkip);
    }

    public JDFWakeUpCmdParams getCreateWakeUpCmdParams() {
        return (JDFWakeUpCmdParams)this.getCreateValidElement("WakeUpCmdParams", null, 0);
    }

    public JDFWakeUpCmdParams appendWakeUpCmdParams() {
        return (JDFWakeUpCmdParams)this.appendValidElement("WakeUpCmdParams", null);
    }

    public JDFWakeUpCmdParams getWakeUpCmdParams() {
        return (JDFWakeUpCmdParams)this.getValidElement("WakeUpCmdParams", null, 0);
    }

    public JDFModifyNodeCmdParams getCreateModifyNodeCmdParams() {
        return (JDFModifyNodeCmdParams)this.getCreateValidElement("ModifyNodeCmdParams", null, 0);
    }

    public JDFModifyNodeCmdParams appendModifyNodeCmdParams() {
        return (JDFModifyNodeCmdParams)this.appendValidElement("ModifyNodeCmdParams", null);
    }

    public JDFModifyNodeCmdParams getModifyNodeCmdParams() {
        return (JDFModifyNodeCmdParams)this.getValidElement("ModifyNodeCmdParams", null, 0);
    }

    public JDFUpdateJDFCmdParams getCreateUpdateJDFCmdParams() {
        return (JDFUpdateJDFCmdParams)this.getCreateValidElement("UpdateJDFCmdParams", null, 0);
    }

    public JDFUpdateJDFCmdParams appendUpdateJDFCmdParams() {
        return (JDFUpdateJDFCmdParams)this.appendValidElement("UpdateJDFCmdParams", null);
    }

    public JDFUpdateJDFCmdParams getUpdateJDFCmdParams() {
        return (JDFUpdateJDFCmdParams)this.getValidElement("UpdateJDFCmdParams", null, 0);
    }

    public String getrefID() {
        return this.getAttribute("refID");
    }

    public void setrefID(String refID) {
        this.setAttribute("refID", refID);
    }

    @Override
    public VString getInvalidElements(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        String[] elementArray;
        int nElem = 0;
        VString vElem = super.getInvalidElements(level, bIgnorePrivate, nMax);
        int n = vElem.size();
        if (n >= nMax) {
            return vElem;
        }
        KElement[] ae = this.getChildElementArray();
        if (ae == null || ae.length == 0) {
            return vElem;
        }
        HashSet<String> s = new HashSet<String>();
        for (KElement element : ae) {
            s.add(element.getLocalName());
        }
        block3: for (String element2 : elementArray = this.getElementArray()) {
            String element = element2;
            if (!s.contains(element)) continue;
            nElem = this.numChildElements(element, null);
            for (int i = 0; i < nElem; ++i) {
                KElement child = null;
                boolean bCatch = false;
                try {
                    child = this.getValidElement(element, null, i);
                }
                catch (JDFException e) {
                    bCatch = true;
                }
                if (!bCatch && child != null && (!(child instanceof JDFElement) || ((JDFElement)child).isValid(level))) continue;
                vElem.appendUnique(element);
                if (++n < nMax) continue block3;
                return vElem;
            }
        }
        return vElem;
    }

    private String[] getElementArray() {
        if (elemArray == null) {
            VString v = new VString(queryTypeObjString);
            v.addAll(responseTypeObjString);
            v.addAll(commandTypeObjString);
            v.unify();
            elemArray = v.toArray(new String[v.size()]);
        }
        return elemArray;
    }

    @Override
    public VString optionalElements() {
        VString s = super.optionalElements();
        EnumType t = this.getEnumType();
        String[] vObjs = this.familyTypeObj();
        if (vObjs == null) {
            return s;
        }
        for (String vObj : vObjs) {
            Set<EnumType> vt = this.getValidTypeVector(vObj, 0);
            if (!vt.contains(t)) continue;
            s.appendUnique(vObj);
        }
        return s;
    }

    @Override
    public VString getInvalidAttributes(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        VString s = super.getInvalidAttributes(level, bIgnorePrivate, nMax);
        if (s.contains("xsi:type")) {
            return s;
        }
        if (!this.hasAttribute("xsi:type")) {
            return s;
        }
        String t = this.getType();
        if (JDFMessage.xmlnsPrefix(t) != null) {
            return s;
        }
        String xs = this.getXSIType();
        if (xs != null && !xs.equals(this.getLocalName() + t)) {
            s.add("xsi:type");
        }
        return s;
    }

    @Override
    public VString getICSVersions() {
        String s = this.getAttribute("ICSVersions", null, null);
        if (s != null) {
            return StringUtil.tokenize(s, null, false);
        }
        KElement parentJMF = this.getParentNode_KElement();
        if (parentJMF instanceof JDFJMF) {
            return ((JDFJMF)parentJMF).getICSVersions();
        }
        return null;
    }

    @Override
    public String getSenderID() {
        if (this.hasAttribute("SenderID")) {
            return this.getAttribute("SenderID");
        }
        JDFJMF parentJMF = this.getJMFRoot();
        return parentJMF == null ? null : parentJMF.getSenderID();
    }

    @Override
    public VString getDeprecatedElements(int nMax) {
        VString v = super.getDeprecatedElements(nMax);
        if (EnumUtil.aLessThanB(JDFElement.EnumVersion.Version_1_1, this.getVersion(true)) && this.hasChildElement("JDFService", null)) {
            v.add("JDFService");
        }
        return v;
    }

    @Override
    public JDFElement.EnumVersion getLastVersion(String eaName, boolean bElement) {
        if ("JDFService".equals(eaName) && bElement) {
            return JDFElement.EnumVersion.Version_1_1;
        }
        return super.getLastVersion(eaName, bElement);
    }

    @Override
    public JDFDate getTime() {
        JDFDate time = super.getTime();
        if (time == null) {
            JDFJMF jmf = this.getJMFRoot();
            return jmf == null ? null : jmf.getTimeStamp();
        }
        return time;
    }

    static {
        JDFMessage.atrInfoTable[0] = new AtrInfoTable("xsi:type", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFMessage.atrInfoTable[1] = new AtrInfoTable("SenderID", 0x33333111L, AttributeInfo.EnumAttributeType.shortString, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFMessage.elemInfoTable[0] = new ElemInfoTable("Employee", 0x33331111L);
        commandTypeObjString = new String[]{"AuthenticationCmdParams", "AbortQueueEntryParams", "HoldQueueEntryParams", "ResumeQueueEntryParams", "RemoveQueueEntryParams", "FlushQueueParams", "FlushResourceParams", "GangCmdFilter", "ModifyNodeCmdParams", "NewJDFCmdParams", "NodeInfoCmdParams", "PipeParams", "QueueEntryDef", "QueueEntryPriParams", "QueueEntryPosParams", "QueueFilter", "QueueSubmissionParams", "RequestQueueEntryParams", "ResourceCmdParams", "ResourcePullParams", "ResubmissionParams", "ReturnQueueEntryParams", "ShutDownCmdParams", "StopPersChParams", "UpdateJDFCmdParams", "WakeUpCmdParams"};
        registrationTypeObjString = new String[]{"PipeParams", "ResourceCmdParams", "ResourcePullParams"};
        queryTypeObjString = new String[]{"AuthenticationQuParams", "DeviceFilter", "EmployeeDef", "GangQuFilter", "KnownMsgQuParams", "MsgFilter", "ModifyNodeCmdParams", "NewJDFQuParams", "NodeInfoQuParams", "NotificationFilter", "QueueEntryDefList", "QueueFilter", "ResourceQuParams", "StatusQuParams", "SubscriptionFilter", "TrackFilter", "UpdateJDFCmdParams"};
        responseTypeObjString = new String[]{"DeviceList", "DeviceInfo", "FlushQueueInfo", "FlushedResources", "GangInfo", "IDInfo", "JDFController", "JDFService", "JobPhase", "MessageService", "NodeInfoResp", "NotificationDef", "Notification", "Occupation", "Queue", "QueueEntry", "ResourceInfo", "SubscriptionInfo", "SubmissionMethods", "TrackResult", "Command", "Query", "Acknowledge", "Response", "Signal", "Registration"};
        signalTypeObjString = JDFMessage.initSignal();
        elemArray = null;
    }

    public static class EnumFamily
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumFamily Query = new EnumFamily("Query");
        public static final EnumFamily Signal = new EnumFamily("Signal");
        public static final EnumFamily Command = new EnumFamily("Command");
        public static final EnumFamily Response = new EnumFamily("Response");
        public static final EnumFamily Acknowledge = new EnumFamily("Acknowledge");
        public static final EnumFamily Registration = new EnumFamily("Registration");

        private EnumFamily(String name) {
            super(name, m_startValue++);
        }

        public static EnumFamily getEnum(String enumName) {
            return (EnumFamily)EnumFamily.getEnum(EnumFamily.class, enumName);
        }

        public static EnumFamily getEnum(int enumValue) {
            return (EnumFamily)EnumFamily.getEnum(EnumFamily.class, enumValue);
        }

        public static Map<String, EnumFamily> getEnumMap() {
            return EnumFamily.getEnumMap(EnumFamily.class);
        }

        public static List<EnumFamily> getEnumList() {
            return EnumFamily.getEnumList(EnumFamily.class);
        }

        public static VString getFamilies() {
            if (families == null) {
                families = new VString();
                List enumList = EnumFamily.getEnumList(EnumFamily.class);
                for (EnumFamily f : enumList) {
                    families.add(f.getName());
                }
                families.sort();
            }
            return families;
        }

        public static Iterator<EnumFamily> iterator() {
            return EnumFamily.iterator(EnumFamily.class);
        }
    }

    public static class EnumType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumType AbortQueueEntry = new EnumType("AbortQueueEntry");
        public static final EnumType CloseQueue = new EnumType("CloseQueue");
        public static final EnumType FlushQueue = new EnumType("FlushQueue");
        public static final EnumType FlushResources = new EnumType("FlushResources");
        public static final EnumType Events = new EnumType("Events");
        public static final EnumType ForceGang = new EnumType("ForceGang");
        public static final EnumType GangStatus = new EnumType("GangStatus");
        public static final EnumType HoldQueue = new EnumType("HoldQueue");
        public static final EnumType HoldQueueEntry = new EnumType("HoldQueueEntry");
        public static final EnumType KnownControllers = new EnumType("KnownControllers");
        public static final EnumType KnownDevices = new EnumType("KnownDevices");
        public static final EnumType KnownJDFServices = new EnumType("KnownJDFServices");
        public static final EnumType KnownMessages = new EnumType("KnownMessages");
        public static final EnumType KnownSubscriptions = new EnumType("KnownSubscriptions");
        public static final EnumType ModifyNode = new EnumType("ModifyNode");
        public static final EnumType NewJDF = new EnumType("NewJDF");
        public static final EnumType NodeInfo = new EnumType("NodeInfo");
        public static final EnumType Notification = new EnumType("Notification");
        public static final EnumType Occupation = new EnumType("Occupation");
        public static final EnumType OpenQueue = new EnumType("OpenQueue");
        public static final EnumType PipeClose = new EnumType("PipeClose");
        public static final EnumType PipePull = new EnumType("PipePull");
        public static final EnumType PipePush = new EnumType("PipePush");
        public static final EnumType PipePause = new EnumType("PipePause");
        public static final EnumType QueueEntryStatus = new EnumType("QueueEntryStatus");
        public static final EnumType QueueStatus = new EnumType("QueueStatus");
        public static final EnumType RequestForAuthentication = new EnumType("RequestForAuthentication");
        public static final EnumType RequestQueueEntry = new EnumType("RequestQueueEntry");
        public static final EnumType RemoveQueueEntry = new EnumType("RemoveQueueEntry");
        public static final EnumType RepeatMessages = new EnumType("RepeatMessages");
        public static final EnumType Resource = new EnumType("Resource");
        public static final EnumType ResourcePull = new EnumType("ResourcePull");
        public static final EnumType ResumeQueue = new EnumType("ResumeQueue");
        public static final EnumType ResumeQueueEntry = new EnumType("ResumeQueueEntry");
        public static final EnumType ResubmitQueueEntry = new EnumType("ResubmitQueueEntry");
        public static final EnumType ReturnQueueEntry = new EnumType("ReturnQueueEntry");
        public static final EnumType SetQueueEntryPosition = new EnumType("SetQueueEntryPosition");
        public static final EnumType SetQueueEntryPriority = new EnumType("SetQueueEntryPriority");
        public static final EnumType ShutDown = new EnumType("ShutDown");
        public static final EnumType Status = new EnumType("Status");
        public static final EnumType StopPersistentChannel = new EnumType("StopPersistentChannel");
        public static final EnumType SubmissionMethods = new EnumType("SubmissionMethods");
        public static final EnumType SubmitQueueEntry = new EnumType("SubmitQueueEntry");
        public static final EnumType SuspendQueueEntry = new EnumType("SuspendQueueEntry");
        public static final EnumType Track = new EnumType("Track");
        public static final EnumType UpdateJDF = new EnumType("UpdateJDF");
        public static final EnumType WakeUp = new EnumType("WakeUp");

        private EnumType(String name) {
            super(name, m_startValue++);
        }

        public static EnumType getEnum(String enumName) {
            return (EnumType)EnumType.getEnum(EnumType.class, enumName);
        }

        public static EnumType getEnum(int enumValue) {
            return (EnumType)EnumType.getEnum(EnumType.class, enumValue);
        }

        public static Map<String, EnumType> getEnumMap() {
            return EnumType.getEnumMap(EnumType.class);
        }

        public static List<EnumType> getEnumList() {
            return EnumType.getEnumList(EnumType.class);
        }

        public static Iterator<EnumType> iterator() {
            return EnumType.iterator(EnumType.class);
        }
    }
}

