/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.node;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.cip4.jdflib.node.LinkInfo;
import org.cip4.jdflib.node.LinkValidatorMap;
import org.cip4.jdflib.util.ContainerUtil;

public class LinkInfoMap
extends HashMap<String, LinkInfo> {
    static final String[] exchangeSet = new String[]{"Component", "RunList", "ExposedMedia"};
    private static final long serialVersionUID = 1L;

    LinkInfoMap() {
    }

    LinkInfoMap(LinkInfoMap info) {
        Collection<String> keys = ContainerUtil.getKeyArray(info);
        if (keys != null) {
            for (String key : keys) {
                this.put(key, new LinkInfo((LinkInfo)info.get(key)));
            }
        }
    }

    @Override
    public LinkInfo put(String key, LinkInfo value) {
        LinkInfo old = (LinkInfo)this.get(key);
        if (old != null) {
            old.merge(value);
            return old;
        }
        return super.put(key, value);
    }

    void merge(LinkInfoMap typeLinkInfo) {
        Collection<String> resNames;
        if (typeLinkInfo != null && (resNames = ContainerUtil.getKeyArray(typeLinkInfo)) != null) {
            for (String resName : resNames) {
                LinkInfo li = (LinkInfo)this.get(resName);
                LinkInfo li2 = (LinkInfo)typeLinkInfo.get(resName);
                if (li != null && li2 != null) {
                    if (LinkValidatorMap.getLinkValidatorMap().getGenericLinkNames().contains(resName) && li.equals(li2)) continue;
                    if (li.hasOutput(null) && li2.hasInput(null)) {
                        li.makeOptional(false, true);
                        li2 = new LinkInfo(li2);
                        li2.makeOptional(true, false);
                    }
                    li.merge(li2);
                    continue;
                }
                if (li2 == null) continue;
                this.put(resName, new LinkInfo(li2));
            }
        }
    }

    public LinkInfo getStar(String key) {
        return this.getStar(key, false);
    }

    public LinkInfo getStar(String key, boolean exchangeOnly) {
        boolean wantStar;
        LinkInfo li = (LinkInfo)super.get(key);
        boolean bl = wantStar = !exchangeOnly || Arrays.binarySearch(exchangeSet, key) >= 0;
        if (wantStar) {
            LinkInfo li2 = (LinkInfo)super.get("*");
            if (li == null) {
                if (li2 != null) {
                    li = new LinkInfo(li2);
                }
            } else {
                li = new LinkInfo(li);
                li.merge(li2);
            }
        }
        return li;
    }
}

