/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.pool;

import java.util.List;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoAncestorPool;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFCustomerInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFAttributeMapArray;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.node.JDFAncestor;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.StringUtil;

public class JDFAncestorPool
extends JDFAutoAncestorPool {
    private static final long serialVersionUID = 1L;

    public JDFAncestorPool(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAncestorPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFAncestorPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public String getAncestorAttribute(String attrib, String nameSpaceURI, String def) {
        VElement v = this.getPoolChildren(null);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFAncestor ancestor = (JDFAncestor)v.elementAt(i);
            if (!ancestor.hasAttribute(attrib, nameSpaceURI, false)) continue;
            return ancestor.getAttribute(attrib, nameSpaceURI, "");
        }
        return def;
    }

    @Deprecated
    public KElement getAncestorElement(String element, String nameSpaceURI) {
        return this.getAncestorElement(element, nameSpaceURI, null);
    }

    public KElement getAncestorElement(String element, String nameSpaceURI, String xPath) {
        VElement v = this.getPoolChildren(null);
        boolean bWildCard = JDFAncestorPool.isWildCard(xPath);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFAncestor ancestor = (JDFAncestor)v.elementAt(i);
            KElement e = ancestor.getElement(element, nameSpaceURI, 0);
            if (e == null || !bWildCard && !e.hasXPathNode(xPath)) continue;
            return e;
        }
        return null;
    }

    @Override
    public String getGeneralID(String idUsage, int iPos) {
        VElement v = this.getPoolChildren(null);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFAncestor ancestor = (JDFAncestor)v.elementAt(i);
            String s = ancestor.getGeneralID(idUsage, iPos);
            if (StringUtil.isEmpty(s)) continue;
            return s;
        }
        return null;
    }

    public boolean hasAncestorElement(String attrib, String nameSpaceURI) {
        return this.getAncestorElement(attrib, nameSpaceURI, null) != null;
    }

    public VElement getLinkedResources(JDFAttributeMap mResAtt, boolean bFollowRefs) {
        VElement vChild = this.getPoolChildren(mResAtt);
        VElement vElem = new VElement();
        for (int i = 0; i < vChild.size(); ++i) {
            JDFAncestor anc = (JDFAncestor)vChild.elementAt(i);
            vElem.appendUnique(anc.getLinkedResources(mResAtt, bFollowRefs));
        }
        return vElem;
    }

    @Deprecated
    public void copyNodeData(JDFNode parentNode) {
        this.copyNodeData(parentNode, true, true, true);
    }

    public void copyNodeData(JDFNode parentNode, boolean bCopyNodeInfo, boolean bCopyCustomerInfo, boolean bCopyComments) {
        int i;
        VElement vAncestors = this.getPoolChildren(null);
        JDFNode node = parentNode;
        JDFNode thisParentNode = this.getParentJDF();
        for (i = vAncestors.size() - 1; i >= 0; --i) {
            JDFNode node2;
            JDFAncestor ancestor = (JDFAncestor)vAncestors.elementAt(i);
            if (!node.getID().equals(ancestor.getNodeID())) {
                throw new JDFException("JDFAncestorPool::CopyNodeData: Invalid pairing");
            }
            ancestor.setAttributes(node);
            ancestor.removeAttribute("xsi:type");
            ancestor.renameAttribute("ID", "NodeID", null, null);
            if (!thisParentNode.getID().equals(node.getID())) {
                this.copyNodeInfo(bCopyNodeInfo, node, ancestor);
                this.copyCustomerInfo(bCopyCustomerInfo, node, ancestor);
                this.copyComments(bCopyComments, node, ancestor);
            }
            if ((node2 = node.getParentJDF()) == null) {
                --i;
                break;
            }
            node = node2;
        }
        if (i >= 0) {
            VElement parentAncestors = node.getAncestorPool().getPoolChildren(null);
            int parentAncestorSize = parentAncestors.size();
            if (parentAncestorSize < i + 1) {
                throw new JDFException("JDFAncestorPool.CopyNodeData: Invalid AncestorPool pairing");
            }
            while (i >= 0) {
                JDFAncestor ancestor = (JDFAncestor)vAncestors.elementAt(i);
                JDFAncestor parentAncestor = (JDFAncestor)parentAncestors.elementAt(i);
                ancestor.mergeElement(parentAncestor, false);
                --i;
            }
        }
    }

    void copyComments(boolean bCopyComments, JDFNode node, JDFAncestor ancestor) {
        if (bCopyComments) {
            List<JDFComment> vc = node.getChildArrayByClass(JDFComment.class, false, 0);
            for (KElement kElement : vc) {
                ancestor.copyElement(kElement, null);
            }
        }
        List<JDFGeneralID> vgid = node.getChildArrayByClass(JDFGeneralID.class, false, 0);
        for (KElement kElement : vgid) {
            ancestor.copyElement(kElement, null);
        }
    }

    void copyCustomerInfo(boolean bCopyCustomerInfo, JDFNode node, JDFAncestor ancestor) {
        JDFCustomerInfo customerInfo;
        if (bCopyCustomerInfo && (customerInfo = node.getCustomerInfo()) != null) {
            if (customerInfo.getParentNode_KElement() instanceof JDFResourcePool) {
                JDFRefElement re = (JDFRefElement)ancestor.appendElement("CustomerInfoRef");
                re.setrRef(customerInfo.getID());
                re.setPartMap(customerInfo.getPartMap());
            } else {
                ancestor.copyElement(customerInfo, null);
            }
        }
    }

    void copyNodeInfo(boolean bCopyNodeInfo, JDFNode node, JDFAncestor ancestor) {
        JDFNodeInfo nodeInfo;
        if (bCopyNodeInfo && (nodeInfo = node.getNodeInfo()) != null) {
            if (nodeInfo.getParentNode_KElement() instanceof JDFResourcePool) {
                JDFRefElement re = (JDFRefElement)ancestor.appendElement("NodeInfoRef");
                re.setrRef(nodeInfo.getID());
                re.setPartMap(nodeInfo.getPartMap());
            } else {
                ancestor.copyElement(nodeInfo, null);
            }
        }
    }

    public VElement getPoolChildren(JDFAttributeMap mAttrib) {
        return this.getPoolChildrenGeneric("Ancestor", mAttrib, null);
    }

    public JDFAncestor getPoolChild(int i, JDFAttributeMap mAttrib) {
        return (JDFAncestor)this.getPoolChildGeneric(i, "Ancestor", mAttrib, "");
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public JDFAttributeMapArray getPartMapArray() {
        return super.getPartMapArray();
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    public boolean hasAncestorAttribute(String attrib, String nameSpaceURI) {
        return this.getAncestorAttribute(attrib, nameSpaceURI, null) != null;
    }

    public String getAncestorElementAttribute(String element, String attrib, String nameSpaceURI, String def) {
        VElement v = this.getPoolChildren(null);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFAncestor ancestor = (JDFAncestor)v.elementAt(i);
            KElement e = ancestor.getElement(element, nameSpaceURI, 0);
            if (e == null || !e.hasAttribute(attrib, nameSpaceURI, false)) continue;
            return e.getAttribute(attrib, nameSpaceURI, "");
        }
        return def;
    }

    public boolean isPartitioned() {
        VJDFAttributeMap partMapVector = this.getPartMapVector();
        return partMapVector != null && partMapVector.size() > 0;
    }
}

