/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.pool;

import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoStatusPool;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFPartStatus;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.node.JDFNode;

public class JDFStatusPool
extends JDFAutoStatusPool {
    private static final long serialVersionUID = 1L;

    public JDFStatusPool(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFStatusPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFStatusPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFStatusPool[ -->" + super.toString() + "]";
    }

    public JDFElement.EnumNodeStatus getStatus(JDFAttributeMap mPart) {
        JDFNode n = this.getParentJDF();
        if (!n.getStatus().equals(JDFElement.EnumNodeStatus.Pool)) {
            return n.getStatus();
        }
        JDFPartStatus ps = this.getPartStatus(mPart);
        if (ps == null) {
            return this.getStatus();
        }
        return ps.getStatus();
    }

    public JDFPartStatus getPartStatus(JDFAttributeMap mPart) {
        VElement vPartStatus = this.getChildElementVector("PartStatus", null, null, true, 0, false);
        int nSep = 0;
        JDFPartStatus retPartStatus = null;
        for (int i = vPartStatus.size() - 1; i >= 0; --i) {
            JDFPartStatus ps = (JDFPartStatus)vPartStatus.elementAt(i);
            JDFAttributeMap mapPart = ps.getPartMap();
            if (mPart == null || !mPart.subMap(mapPart) || mapPart.size() <= nSep) continue;
            nSep = mapPart.size();
            retPartStatus = ps;
        }
        return retPartStatus;
    }

    public JDFPartStatus getCreatePartStatus(JDFAttributeMap mPart) {
        JDFPartStatus p = this.getPartStatus(mPart);
        if (p == null) {
            p = this.appendPartStatus();
            p.setPartMap(mPart);
        }
        return p;
    }

    public VElement getPartStatusVector(Vector vmPart) {
        if (vmPart == null) {
            return this.getChildElementVector("PartStatus", null, null, true, -1, false);
        }
        VElement vPartStatus = new VElement();
        for (int i = 0; i < vmPart.size(); ++i) {
            JDFPartStatus ps = this.getPartStatus((JDFAttributeMap)vmPart.elementAt(i));
            if (ps == null) continue;
            vPartStatus.add(ps);
        }
        return vPartStatus;
    }

    public VElement getMatchingPartStatusVector(JDFAttributeMap mPart) {
        VElement vPartStatus = this.getChildElementVector("PartStatus", null, null, true, 0, false);
        VElement vPS = new VElement();
        for (int i = 0; i < vPartStatus.size(); ++i) {
            JDFPartStatus ps = (JDFPartStatus)vPartStatus.elementAt(i);
            JDFAttributeMap mapPart = ps.getPartMap();
            if (!mapPart.subMap(mPart)) continue;
            vPS.add(ps);
        }
        return vPS;
    }

    public VElement getCreatePartStatusVector(Vector vmPart) {
        VElement vPartStatus = new VElement();
        for (int i = 0; i < vmPart.size(); ++i) {
            JDFPartStatus ps = this.getCreatePartStatus((JDFAttributeMap)vmPart.elementAt(i));
            if (ps == null) continue;
            vPartStatus.add(ps);
        }
        return vPartStatus;
    }

    public VElement getPoolChildren(JDFAttributeMap mAttrib) {
        return this.getPoolChildrenGeneric("PartStatus", mAttrib, "");
    }

    public JDFPartStatus getPoolChild(int i, JDFAttributeMap mAttrib) {
        return (JDFPartStatus)this.getPoolChildGeneric(i, "PartStatus", mAttrib, "");
    }

    @Override
    public void setStatus(JDFElement.EnumNodeStatus s) {
        JDFNode n = (JDFNode)this.getParentNode_KElement();
        n.setStatus(JDFElement.EnumNodeStatus.Pool);
        super.setStatus(s);
    }

    public void setStatus(VJDFAttributeMap vmPart, JDFElement.EnumNodeStatus s, String statusDetails) {
        for (int i = 0; i < vmPart.size(); ++i) {
            this.setStatus(vmPart.elementAt(i), s, statusDetails);
        }
    }

    public void setStatus(JDFAttributeMap mPart, JDFElement.EnumNodeStatus s, String statusDetails) {
        if (mPart != null && !mPart.isEmpty()) {
            JDFPartStatus ps = this.getCreatePartStatus(mPart);
            ps.setStatus(s);
            if (statusDetails != null && !statusDetails.equals("")) {
                ps.setStatusDetails(statusDetails);
            }
        } else {
            this.setStatus(s);
            if (statusDetails != null && !statusDetails.equals("")) {
                this.setStatusDetails(statusDetails);
            }
        }
    }

    public boolean validStatus() {
        if (!super.validAttribute("Status", null, JDFElement.EnumValidationLevel.Complete)) {
            return false;
        }
        return !this.getStatus().equals(JDFElement.EnumNodeStatus.Pool);
    }
}

