/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoProcessRun;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.resource.JDFPhaseTime;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.w3c.dom.DOMException;

public class JDFProcessRun
extends JDFAutoProcessRun {
    private static final long serialVersionUID = 1L;

    public JDFProcessRun(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFProcessRun(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFProcessRun(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFProcessRun[  --> " + super.toString() + " ]";
    }

    public void setDurationSeconds(long seconds) throws JDFException {
        if (seconds < 0L) {
            throw new JDFException("parameter must be >= 0");
        }
        JDFDuration d = new JDFDuration();
        d.setDuration(seconds);
        this.setAttribute("Duration", d.getDurationISO());
    }

    public long getDurationSeconds() {
        JDFDuration d = this.getDuration();
        if (d == null) {
            return 0L;
        }
        return d.getDuration();
    }

    @Override
    public JDFDuration getDuration() {
        JDFDuration dur = super.getDuration();
        if (dur != null) {
            return dur;
        }
        JDFDate dStart = this.getStart();
        JDFDate dEnd = this.getEnd();
        if (dStart == null || dEnd == null) {
            return null;
        }
        dur = new JDFDuration(dStart, dEnd);
        return dur;
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    public void addPhase(JDFPhaseTime pt) {
        JDFDate end;
        JDFDate start2;
        JDFDate start;
        if (pt == null) {
            return;
        }
        JDFElement.EnumNodeStatus status = pt.getStatus();
        if (status == null || status.equals(JDFElement.EnumNodeStatus.Ready) || status.equals(JDFElement.EnumNodeStatus.Completed) || status.equals(JDFElement.EnumNodeStatus.FailedTestRun) || status.equals(JDFElement.EnumNodeStatus.Spawned) || status.equals(JDFElement.EnumNodeStatus.Stopped) || status.equals(JDFElement.EnumNodeStatus.Suspended) || status.equals(JDFElement.EnumNodeStatus.Waiting)) {
            return;
        }
        JDFDuration dur = pt.getDuration();
        if (dur != null) {
            this.addDuration(dur.getDuration());
        }
        if ((start = pt.getStart()) != null && ((start2 = this.getStart()) == null || start.isEarlier(start2))) {
            this.setStart(start);
        }
        if ((end = pt.getEnd()) != null && end.isLater(this.getEnd())) {
            this.setEnd(end);
        }
    }

    public void ensureNotLonger() {
        JDFDuration total;
        JDFDate start = this.getStart();
        JDFDate end = this.getEnd();
        if (start != null && end != null && (total = new JDFDuration(start, end)).compareTo(this.getDuration()) < 0) {
            this.setDuration(total);
        }
    }

    public void addDuration(long seconds) {
        JDFDuration dur = this.getDuration();
        long l = dur == null ? 0L : dur.getDuration();
        this.setDurationSeconds(l + seconds);
    }

    @Override
    public boolean init() {
        this.setEnd(null);
        return super.init();
    }

    public boolean matches(JDFAudit audit) {
        KElement prev;
        if (audit == null) {
            return false;
        }
        if (!ContainerUtil.equals(audit.getParentNode(), this.getParentNode())) {
            return false;
        }
        for (prev = this.getPreviousSiblingElement(); prev != null; prev = prev.getPreviousSiblingElement()) {
            if (prev instanceof JDFProcessRun) {
                prev = null;
                break;
            }
            if (prev == audit) break;
        }
        if (prev != audit) {
            return false;
        }
        if (!ContainerUtil.equals(this.getQueueEntryID(), audit.getQueueEntryID())) {
            return false;
        }
        VJDFAttributeMap vMap = this.getPartMapVector();
        return vMap == null || vMap.overlapsMap(audit.getPartMapVector());
    }
}

