/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.auto.JDFAutoDevCaps;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.ifaces.ICapabilityElement;
import org.cip4.jdflib.jmf.JDFMessageService;
import org.cip4.jdflib.resource.devicecapability.JDFBooleanState;
import org.cip4.jdflib.resource.devicecapability.JDFDateTimeState;
import org.cip4.jdflib.resource.devicecapability.JDFDevCap;
import org.cip4.jdflib.resource.devicecapability.JDFDevCaps;
import org.cip4.jdflib.resource.devicecapability.JDFDeviceCap;
import org.cip4.jdflib.resource.devicecapability.JDFDurationState;
import org.cip4.jdflib.resource.devicecapability.JDFIntegerState;
import org.cip4.jdflib.resource.devicecapability.JDFLoc;
import org.cip4.jdflib.resource.devicecapability.JDFMatrixState;
import org.cip4.jdflib.resource.devicecapability.JDFModuleCap;
import org.cip4.jdflib.resource.devicecapability.JDFModulePool;
import org.cip4.jdflib.resource.devicecapability.JDFNumberState;
import org.cip4.jdflib.resource.devicecapability.JDFShapeState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.resource.devicecapability.JDFValueLoc;
import org.cip4.jdflib.resource.devicecapability.JDFXYPairState;
import org.cip4.jdflib.resource.intent.JDFIntentResource;
import org.cip4.jdflib.span.JDFSpanBase;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.Node;

public abstract class JDFAbstractState
extends JDFElement
implements JDFBaseDataTypes,
ICapabilityElement {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[16];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    public JDFAbstractState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAbstractState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFAbstractState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public abstract void addValue(String var1, JDFBaseDataTypes.EnumFitsValue var2);

    public abstract boolean fitsValue(String var1, JDFBaseDataTypes.EnumFitsValue var2);

    public final String getNamePath() {
        JDFAutoDevCaps.EnumContext context;
        Object namePath = this.getParentPath();
        JDFDevCaps dcs = this.getParentDevCaps();
        if (dcs != null && JDFAutoDevCaps.EnumContext.Link.equals(context = dcs.getContext())) {
            namePath = (String)namePath + "Link";
        }
        if (this.getListType().equals(JDFAutoBasicPreflightTest.EnumListType.Span)) {
            return (String)namePath + "/" + this.getName();
        }
        return (String)namePath + "/@" + this.getName();
    }

    private String getParentPath() {
        String namePath = null;
        KElement parent = this.getParentNode_KElement();
        if (parent instanceof JDFDevCap) {
            JDFDevCap devCap = this.getParentDevCap();
            namePath = devCap.getNamePath(true);
        } else if (parent instanceof JDFDeviceCap) {
            namePath = "JDF";
        } else if (parent instanceof JDFMessageService) {
            namePath = "JMF";
        }
        return namePath;
    }

    @Override
    public final VString getNamePathVector() {
        return this.getNamePathVector(true);
    }

    public final VString getNamePathVector(boolean bRecurse) {
        JDFAutoDevCaps.EnumContext context;
        VString vNamePath = this.getParentPathVector(bRecurse);
        JDFDevCaps dcs = this.getParentDevCaps();
        if (dcs != null && JDFAutoDevCaps.EnumContext.Link.equals(context = dcs.getContext())) {
            StringUtil.concatStrings(vNamePath, "Link");
        }
        if (this.getListType().equals(JDFAutoBasicPreflightTest.EnumListType.Span)) {
            StringUtil.concatStrings(vNamePath, "/" + this.getName());
        } else {
            StringUtil.concatStrings(vNamePath, "/@" + this.getName());
        }
        return vNamePath;
    }

    private VString getParentPathVector(boolean recurse) {
        KElement parent = this.getParentNode_KElement();
        if (parent instanceof JDFDevCap) {
            return ((JDFDevCap)parent).getNamePathVector(recurse);
        }
        return new VString(this.getParentPath(), null);
    }

    public JDFDevCaps getParentDevCaps() {
        return (JDFDevCaps)this.getDeepParent("DevCaps", 0);
    }

    @Override
    public void setAvailability(JDFDeviceCap.EnumAvailability value) {
        this.setAttribute("Availability", value, null);
    }

    @Override
    public JDFDeviceCap.EnumAvailability getAvailability() {
        JDFDevCap par;
        JDFDeviceCap.EnumAvailability avail = JDFDeviceCap.EnumAvailability.getEnum(this.getAttribute("Availability", null, null));
        if (avail == null && (par = this.getParentDevCap()) != null) {
            avail = par.getAvailability();
        }
        return avail == null ? JDFDeviceCap.EnumAvailability.Installed : avail;
    }

    public JDFDevCap getParentDevCap() {
        Node parentNode = this.getParentNode();
        return parentNode instanceof JDFDevCap ? (JDFDevCap)parentNode : null;
    }

    public void setDevNS(String value) {
        this.setAttribute("DevNS", value);
    }

    public String getDevNS() {
        return this.getAttribute("DevNS", null, JDFElement.getSchemaURL());
    }

    public void setHasDefault(boolean value) {
        this.setAttribute("HasDefault", value, null);
    }

    public boolean getHasDefault() {
        return this.getBoolAttribute("HasDefault", null, true);
    }

    public void setMaxOccurs(int value) {
        this.setAttribute("MaxOccurs", value, (String)null);
    }

    public int getMaxOccurs() {
        String s = this.getAttribute("MaxOccurs", null, null);
        if ("unbounded".equals(s)) {
            return Integer.MAX_VALUE;
        }
        return StringUtil.parseInt(s, 1);
    }

    public void setMinOccurs(int value) {
        this.setAttribute("MinOccurs", value, (String)null);
    }

    public int getMinOccurs() {
        return this.getIntAttribute("MinOccurs", "", 1);
    }

    public void setName(String value) {
        this.setAttribute("Name", value);
    }

    public String getName() {
        return this.getAttribute("Name", null, "");
    }

    public void setRequired(boolean value) {
        this.setAttribute("Required", value, null);
    }

    public boolean getRequired() {
        return this.getBoolAttribute("Required", "", false);
    }

    public void setListType(JDFAutoBasicPreflightTest.EnumListType value) {
        this.setAttribute("ListType", value, null);
    }

    public JDFAutoBasicPreflightTest.EnumListType getListType() {
        return JDFAutoBasicPreflightTest.EnumListType.getEnum(this.getAttribute("ListType", null, JDFAutoBasicPreflightTest.EnumListType.SingleValue.getName()));
    }

    public void setActionRefs(VString value) {
        this.setAttribute("ActionRefs", value, (String)null);
    }

    public VString getActionRefs() {
        String strActionRefs = this.getAttribute("ActionRefs", null, "");
        return StringUtil.tokenize(strActionRefs, ",", false);
    }

    public void setEditable(boolean value) {
        this.setAttribute("Editable", value, null);
    }

    public boolean getEditable() {
        return this.getBoolAttribute("Editable", "", true);
    }

    public void setMacroRefs(VString value) {
        StringBuffer strMacroRefs = new StringBuffer(100);
        for (int i = 0; i < value.size(); ++i) {
            strMacroRefs.append(value.elementAt(i));
        }
        this.setAttribute("MacroRefs", strMacroRefs.toString());
    }

    public VString getMacroRefs() {
        String strMacroRef = this.getAttribute("MacroRefs", null, "");
        return StringUtil.tokenize(strMacroRef, ",", false);
    }

    public void setDependentMacroRef(String value) {
        this.setAttribute("DependentMacroRef", value);
    }

    public String getDependentMacroRef() {
        return this.getAttribute("DependentMacroRef", null, "");
    }

    public void setUserDisplay(EnumUserDisplay value) {
        this.setAttribute("UserDisplay", value, null);
    }

    public EnumUserDisplay getUserDisplay() {
        return EnumUserDisplay.getEnum(this.getAttribute("UserDisplay", null, EnumUserDisplay.Display.getName()));
    }

    public JDFLoc getCreateLoc(int iSkip) {
        return (JDFLoc)this.getCreateElement("Loc", "", iSkip);
    }

    public JDFLoc getLoc(int iSkip) {
        JDFLoc e = (JDFLoc)this.getElement("Loc", "", iSkip);
        return e;
    }

    public JDFLoc appendLoc() {
        return (JDFLoc)this.appendElement("Loc", null);
    }

    protected void setAllowedLength(JDFIntegerRange value) {
        this.setAttribute("AllowedLength", value.toString());
    }

    protected JDFIntegerRange getAllowedLength() {
        try {
            String len = this.getAttribute("AllowedLength", null, null);
            if (len == null) {
                return null;
            }
            JDFIntegerRange ir = new JDFIntegerRange(len);
            return ir;
        }
        catch (DataFormatException dfe) {
            throw new JDFException("JDFAbstractState.getAllowedLength: Attribute ALLOWEDLENGTH is not capable to create JDFIntegerRange");
        }
    }

    protected void setPresentLength(JDFIntegerRange value) {
        this.setAttribute("PresentLength", value.toString());
    }

    protected JDFIntegerRange getPresentLength() {
        if (this.hasAttribute("PresentLength")) {
            try {
                JDFIntegerRange ir = new JDFIntegerRange(this.getAttribute("PresentLength"));
                return ir;
            }
            catch (DataFormatException dfe) {
                throw new JDFException("JDFAbstractState.getPresentLength: Attribute PRESENTLENGTH is not capable to create JDFIntegerRange");
            }
        }
        return this.getAllowedLength();
    }

    protected final boolean fitsLength(String str, JDFBaseDataTypes.EnumFitsValue length) {
        JDFIntegerRange lengthlist = length.equals(JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedLength() : this.getPresentLength();
        if (lengthlist != null) {
            int len = str.length();
            return lengthlist.inRange(len);
        }
        return true;
    }

    public Object getMatchingObjectInNode(KElement element) {
        String nam = this.getName();
        if (this.getListType().equals(JDFAutoBasicPreflightTest.EnumListType.Span)) {
            return element.getElement(nam, this.getDevNS(), 0);
        }
        return element.getAttribute(nam, this.getDevNS(), null);
    }

    public boolean setDefaultsFromCaps(KElement element, boolean bAll) {
        String prefix;
        Object theValue;
        String def = this.getAttribute("DefaultValue", null, null);
        if (!bAll && def == null) {
            return false;
        }
        if (def == null) {
            def = this.getAttribute("CurrentValue", null, null);
        }
        if (def == null) {
            def = this.getAttribute("AllowedValueList", null, null);
            if (def != null && (def.indexOf("~") >= 0 || def.indexOf(" ") >= 0)) {
                String lt = this.getListType().getName();
                if (!lt.endsWith("List") && def.indexOf(" ") >= 0) {
                    def = StringUtil.token(def, 0, " ");
                } else if (lt.indexOf("Range") < 0 && def.indexOf("~") >= 0) {
                    def = null;
                }
            }
            if (def == null) {
                def = this.getXPathAttribute("Value/@AllowedValue", null);
            }
        }
        if (def == null) {
            def = this instanceof JDFIntegerState || this instanceof JDFNumberState ? "1" : (this instanceof JDFXYPairState ? "1 1" : (this instanceof JDFBooleanState ? "true" : (this instanceof JDFMatrixState ? JDFMatrix.getUnitMatrix().toString() : (this instanceof JDFShapeState ? "1 2 3" : (this instanceof JDFDateTimeState ? new JDFDate().getDateTimeISO() : (this instanceof JDFDurationState ? new JDFDuration(42L).getDurationISO() : "some_value"))))));
        }
        if ((theValue = this.getMatchingObjectInNode(element)) != null) {
            return false;
        }
        Object nam = this.getName();
        String nsURI = this.getDevNS();
        if (nsURI.equals(JDFElement.getSchemaURL())) {
            nsURI = null;
        }
        if (nsURI != null && (prefix = KElement.xmlnsPrefix((String)nam)) == null) {
            nam = StringUtil.token(nsURI, -1, "/") + ":" + (String)nam;
        }
        if (this.getListType().equals(JDFAutoBasicPreflightTest.EnumListType.Span)) {
            JDFIntentResource ir = (JDFIntentResource)element;
            JDFSpanBase span = ir.appendSpan((String)nam, null);
            span.setAttribute("Preferred", def);
        } else {
            element.setAttribute((String)nam, def, nsURI);
        }
        return true;
    }

    protected final boolean fitsListType(String value) {
        JDFNameRangeList rangelist;
        if (value == null) {
            return true;
        }
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        try {
            rangelist = new JDFNameRangeList(value);
        }
        catch (DataFormatException e) {
            return false;
        }
        catch (JDFException e) {
            return false;
        }
        if (listType == null || listType.equals(JDFAutoBasicPreflightTest.EnumListType.SingleValue)) {
            return value.indexOf(" ") == -1;
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.RangeList) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.Span)) {
            return true;
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.Range)) {
            return rangelist.size() == 1;
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.List) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteList) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return rangelist.isList();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.OrderedList)) {
            return rangelist.isList() && ((JDFRangeList)rangelist).isOrdered();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueList)) {
            return rangelist.isList() && rangelist.isUnique();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedList)) {
            return rangelist.isList() && ((JDFRangeList)rangelist).isUniqueOrdered();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.OrderedRangeList)) {
            return ((JDFRangeList)rangelist).isOrdered();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueRangeList)) {
            return rangelist.isUnique();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedRangeList)) {
            return ((JDFRangeList)rangelist).isUniqueOrdered();
        }
        throw new JDFException("JDFDateTimeState.fitsListType illegal ListType attribute");
    }

    protected VString getInvalidAttributesImpl(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        VString v = super.getInvalidAttributes(level, bIgnorePrivate, nMax);
        if (nMax > 0 && v.size() >= nMax) {
            return v;
        }
        if (!this.fitsListType(this.getAttribute("DefaultValue"))) {
            v.appendUnique("DefaultValue");
        }
        if (!this.fitsListType(this.getAttribute("CurrentValue"))) {
            v.appendUnique("CurrentValue");
        }
        return v;
    }

    public JDFLoc getValueLocLoc(int iSkip, int jSkip) {
        JDFValueLoc val = this.getValueLoc(iSkip);
        if (val == null) {
            return null;
        }
        return val.getLoc(jSkip);
    }

    public final JDFValueLoc getValueLoc(int iSkip) {
        return (JDFValueLoc)this.getElement("ValueLoc", null, iSkip);
    }

    public JDFLoc appendValueLocLoc(int iSkip) {
        JDFValueLoc val = this.getValueLoc(iSkip);
        if (val == null) {
            return null;
        }
        return val.appendLoc();
    }

    public final JDFValueLoc appendValueLoc() {
        return (JDFValueLoc)this.appendElement("ValueLoc", null);
    }

    protected final boolean fitsRegExp(String str, JDFBaseDataTypes.EnumFitsValue regexp) {
        String rExp = regexp.equals(JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedRegExp() : this.getPresentRegExp();
        if (rExp.length() == 0) {
            return true;
        }
        return StringUtil.matches(str, rExp);
    }

    protected String getPresentRegExp() {
        return null;
    }

    protected String getAllowedRegExp() {
        return null;
    }

    public JDFDeviceCap.EnumAvailability getModuleAvailability() {
        return JDFModulePool.getModuleAvailability(this);
    }

    @Override
    public JDFModulePool getModulePool() {
        return (JDFModulePool)this.getParentPool("ModulePool");
    }

    @Override
    public JDFModulePool getCreateModulePool() {
        return (JDFModulePool)this.getCreateParentPool("ModulePool");
    }

    private KElement getParentPool(String poolName) {
        KElement parent = this.getPoolParent();
        return parent.getElement(poolName);
    }

    private KElement getCreateParentPool(String poolName) {
        KElement parent = this.getPoolParent();
        return parent.getCreateElement(poolName);
    }

    private KElement getPoolParent() {
        KElement parent = this.getDeepParent("DeviceCap", 0);
        if (parent == null) {
            parent = this.getDeepParent("MessageService", 0);
        }
        if (!(parent instanceof JDFDeviceCap) && !(parent instanceof JDFMessageService)) {
            throw new JDFException("JDFDevCap.getParentPool - invalid parent context");
        }
        return parent;
    }

    @Override
    public VString getModuleRefs() {
        return StringUtil.tokenize(this.getAttribute("ModuleRefs", null, null), " ", false);
    }

    @Override
    public JDFModuleCap appendModuleRef(String id) {
        return JDFModulePool.appendModuleRef(this, id);
    }

    @Override
    public boolean init() {
        this.appendAnchor(null);
        return super.init();
    }

    @Override
    protected String getIDPrefix() {
        return "d";
    }

    @Override
    public abstract JDFTerm.EnumTerm getEvaluationType();

    static {
        JDFAbstractState.atrInfoTable[0] = new AtrInfoTable("Availability", 0x33333311L, AttributeInfo.EnumAttributeType.enumeration, JDFDeviceCap.EnumAvailability.getEnum(0), null);
        JDFAbstractState.atrInfoTable[1] = new AtrInfoTable("ActionRefs", 0x33333311L, AttributeInfo.EnumAttributeType.IDREFS, null, null);
        JDFAbstractState.atrInfoTable[2] = new AtrInfoTable("DependentMacroRef", 0x33333311L, AttributeInfo.EnumAttributeType.IDREF, null, null);
        JDFAbstractState.atrInfoTable[3] = new AtrInfoTable("DevNS", 0x33333331L, AttributeInfo.EnumAttributeType.URI, null, "http://www.CIP4.org/JDFSchema_1_1");
        JDFAbstractState.atrInfoTable[4] = new AtrInfoTable("Editable", 0x33333311L, AttributeInfo.EnumAttributeType.boolean_, null, "true");
        JDFAbstractState.atrInfoTable[5] = new AtrInfoTable("HasDefault", 0x33333331L, AttributeInfo.EnumAttributeType.boolean_, null, "true");
        JDFAbstractState.atrInfoTable[6] = new AtrInfoTable("ID", 0x33333311L, AttributeInfo.EnumAttributeType.ID, null, null);
        JDFAbstractState.atrInfoTable[7] = new AtrInfoTable("ListType", 0x33333311L, AttributeInfo.EnumAttributeType.enumeration, JDFAutoBasicPreflightTest.EnumListType.getEnum(0), JDFAutoBasicPreflightTest.EnumListType.SingleValue.getName());
        JDFAbstractState.atrInfoTable[8] = new AtrInfoTable("MacroRefs", 0x33333311L, AttributeInfo.EnumAttributeType.IDREFS, null, null);
        JDFAbstractState.atrInfoTable[9] = new AtrInfoTable("MaxOccurs", 0x33333311L, AttributeInfo.EnumAttributeType.unbounded, null, "1");
        JDFAbstractState.atrInfoTable[10] = new AtrInfoTable("MinOccurs", 0x33333311L, AttributeInfo.EnumAttributeType.integer, null, "1");
        JDFAbstractState.atrInfoTable[11] = new AtrInfoTable("ModuleRefs", 0x33333111L, AttributeInfo.EnumAttributeType.IDREFS, null, null);
        JDFAbstractState.atrInfoTable[12] = new AtrInfoTable("Name", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAbstractState.atrInfoTable[13] = new AtrInfoTable("Required", 0x33333311L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFAbstractState.atrInfoTable[14] = new AtrInfoTable("Span", 0x44444431L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFAbstractState.atrInfoTable[15] = new AtrInfoTable("UserDisplay", 0x33333311L, AttributeInfo.EnumAttributeType.enumeration, EnumUserDisplay.getEnum(0), EnumUserDisplay.Display.getName());
        elemInfoTable = new ElemInfoTable[1];
        JDFAbstractState.elemInfoTable[0] = new ElemInfoTable("Loc", 0x33333311L);
    }

    public static class EnumUserDisplay
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumUserDisplay Display = new EnumUserDisplay("Display");
        public static final EnumUserDisplay Hide = new EnumUserDisplay("Hide");
        public static final EnumUserDisplay Dependent = new EnumUserDisplay("Dependent");

        private EnumUserDisplay(String name) {
            super(name, m_startValue++);
        }

        public static EnumUserDisplay getEnum(String enumName) {
            return (EnumUserDisplay)EnumUserDisplay.getEnum(EnumUserDisplay.class, enumName);
        }

        public static EnumUserDisplay getEnum(int enumValue) {
            return (EnumUserDisplay)EnumUserDisplay.getEnum(EnumUserDisplay.class, enumValue);
        }

        public static Map getEnumMap() {
            return EnumUserDisplay.getEnumMap(EnumUserDisplay.class);
        }

        public static List getEnumList() {
            return EnumUserDisplay.getEnumList(EnumUserDisplay.class);
        }

        public static Iterator iterator() {
            return EnumUserDisplay.iterator(EnumUserDisplay.class);
        }
    }
}

