/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.util.ContainerUtil;

public class JDFBooleanState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[4];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFBooleanState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFBooleanState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFBooleanState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFBooleanState[ --> " + super.toString() + " ]";
    }

    public void setCurrentValue(boolean value) {
        this.setAttribute("CurrentValue", value, null);
    }

    public boolean getCurrentValue() {
        return this.getBoolAttribute("CurrentValue", "", false);
    }

    public void setDefaultValue(boolean value) {
        this.setAttribute("DefaultValue", value, null);
    }

    public boolean getDefaultValue() {
        return this.getBoolAttribute("DefaultValue", "", false);
    }

    public Vector getAllowedValueList() {
        Vector<JDFElement.EnumBoolean> enumerationsAttribute = this.getEnumerationsAttribute("AllowedValueList", null, JDFElement.EnumBoolean.True, false);
        return (Vector)ContainerUtil.getNonEmpty(enumerationsAttribute);
    }

    public void setAllowedValueList(Vector value) {
        this.setEnumerationsAttribute("AllowedValueList", value, null);
    }

    public Vector getPresentValueList() {
        if (this.hasAttribute("PresentValueList")) {
            return this.getEnumerationsAttribute("PresentValueList", null, JDFElement.EnumBoolean.True, false);
        }
        return this.getAllowedValueList();
    }

    public void setPresentValueList(Vector value) {
        this.setEnumerationsAttribute("PresentValueList", value, null);
    }

    @Override
    public final boolean fitsValue(String valueStr, JDFBaseDataTypes.EnumFitsValue testlists) {
        if (this.fitsListType(valueStr)) {
            VString value = new VString(valueStr, null);
            for (int i = 0; i < value.size(); ++i) {
                if (this.fitsValueList(value.elementAt(i), testlists)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final boolean fitsValueList(String value, JDFBaseDataTypes.EnumFitsValue valuelist) {
        JDFElement.EnumBoolean eb = JDFElement.EnumBoolean.getEnum(value);
        if (eb == null) {
            return false;
        }
        Vector v = valuelist.equals(JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueList() : this.getPresentValueList();
        if (v == null) {
            return true;
        }
        return v.contains(eb);
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        Vector list;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        JDFElement.EnumBoolean b = JDFElement.EnumBoolean.getEnum(value);
        if (b == null) {
            return;
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals(testlists)) {
            list = this.getAllowedValueList();
            if (list == null) {
                list = new Vector();
            }
            list.add(b);
            this.setAllowedValueList(list);
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Present.equals(testlists)) {
            list = this.getPresentValueList();
            if (list == null || !this.hasAttribute("PresentValueList")) {
                list = new Vector();
            }
            list.add(b);
            this.setPresentValueList(list);
        }
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.BooleanEvaluation;
    }

    static {
        JDFBooleanState.atrInfoTable[0] = new AtrInfoTable("AllowedValueList", 0x33333331L, AttributeInfo.EnumAttributeType.enumerations, JDFElement.EnumBoolean.getEnum(0), null);
        JDFBooleanState.atrInfoTable[1] = new AtrInfoTable("CurrentValue", 0x33333331L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFBooleanState.atrInfoTable[2] = new AtrInfoTable("DefaultValue", 0x33333331L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFBooleanState.atrInfoTable[3] = new AtrInfoTable("PresentValueList", 0x33333331L, AttributeInfo.EnumAttributeType.enumerations, JDFElement.EnumBoolean.getEnum(0), null);
        elemInfoTable = new ElemInfoTable[1];
        JDFBooleanState.elemInfoTable[0] = new ElemInfoTable("ValueLoc", 0x33333311L);
    }
}

