/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;
import org.cip4.jdflib.util.StringUtil;

public class JDFIntegerEvaluation
extends JDFEvaluation {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[2];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFIntegerEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFIntegerEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFIntegerEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFIntegerEvaluation[ --> " + super.toString() + " ]";
    }

    public void setValueList(JDFIntegerRangeList value) {
        this.setAttribute("ValueList", value.toString(), null);
    }

    public void appendValueList(int value) {
        JDFIntegerRangeList irl = this.getCreateValueList();
        irl.append(value);
        this.setValueList(irl);
    }

    public JDFIntegerRangeList getCreateValueList() {
        JDFIntegerRangeList irl = this.getValueList();
        if (irl == null) {
            irl = new JDFIntegerRangeList();
        }
        return irl;
    }

    public JDFIntegerRangeList getValueList() {
        return JDFIntegerRangeList.createIntegerRangeList(this.getAttribute("ValueList", null, ""));
    }

    public void setValueMod(JDFXYPair value) {
        this.setAttribute("ValueMod", value.toString());
    }

    public JDFXYPair getValueMod() {
        return JDFXYPair.createXYPair(this.getAttribute("ValueMod"));
    }

    @Override
    public boolean fitsValue(String value) {
        if (this.fitsListType(value)) {
            JDFIntegerRangeList rangelist = null;
            try {
                rangelist = new JDFIntegerRangeList(value);
            }
            catch (DataFormatException dfe) {
                return false;
            }
            return this.fitsValueList(rangelist) && this.fitsValueMod(rangelist);
        }
        return false;
    }

    private final boolean fitsListType(String value) {
        JDFIntegerRangeList rangelist;
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        try {
            rangelist = new JDFIntegerRangeList(value);
        }
        catch (DataFormatException e) {
            return false;
        }
        catch (JDFException e) {
            return false;
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.SingleValue) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.getEnum(0))) {
            return StringUtil.isInteger(value);
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.RangeList) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.Span)) {
            return true;
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.List) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteList) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return rangelist.isList();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.OrderedList)) {
            return rangelist.isList() && rangelist.isOrdered();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueList)) {
            return rangelist.isList() && rangelist.isUnique();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedList)) {
            return rangelist.isList() && rangelist.isUniqueOrdered();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.OrderedRangeList)) {
            return rangelist.isOrdered();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueRangeList)) {
            return rangelist.isUnique();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedRangeList)) {
            return rangelist.isUniqueOrdered();
        }
        throw new JDFException("JDFIntegerEvaluation.fitsListType illegal ListType attribute");
    }

    private final boolean fitsValueList(JDFIntegerRangeList rangelist) {
        if (!this.hasAttribute("ValueList")) {
            return true;
        }
        JDFIntegerRangeList valuelist = this.getValueList();
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(rangelist, valuelist);
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(rangelist, valuelist);
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(rangelist, valuelist);
        }
        int siz = rangelist.size();
        for (int i = 0; i < siz; ++i) {
            if (valuelist.isPartOfRange(rangelist.at(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsValueMod(JDFIntegerRangeList rangelist) {
        if (!this.hasAttribute("ValueMod")) {
            return true;
        }
        JDFXYPair mod = this.getValueMod();
        int divi = (int)(mod.getX() + 0.5);
        int shift = (int)(mod.getY() + 0.5);
        if (divi == 0) {
            return false;
        }
        JDFIntegerList v = rangelist.getIntegerList();
        int[] vi = v.getIntArray();
        int siz = vi.length;
        for (int i = 0; i < siz; ++i) {
            if ((vi[i] % divi - shift) % divi == 0) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteList(JDFIntegerRangeList value, JDFIntegerRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        JDFIntegerRangeList valueList = new JDFIntegerRangeList(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.at(i).equals(valueList.at(j))) continue;
                valueList.erase(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(JDFIntegerRangeList value, JDFIntegerRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.at(i).equals(value.at(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(JDFIntegerRangeList value, JDFIntegerRangeList list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.at(i).equals(list.at(j))) continue;
                return true;
            }
        }
        return false;
    }

    static {
        JDFIntegerEvaluation.atrInfoTable[0] = new AtrInfoTable("ValueList", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFIntegerEvaluation.atrInfoTable[1] = new AtrInfoTable("ValueMod", 0x33333333L, AttributeInfo.EnumAttributeType.XYPair, null, null);
    }
}

