/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;
import org.cip4.jdflib.util.StringUtil;

public class JDFNameEvaluation
extends JDFEvaluation {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[2];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFNameEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFNameEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFNameEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFNameEvaluation[ --> " + super.toString() + " ]";
    }

    public VString getValueList() {
        return StringUtil.tokenize("ValueList", " ", false);
    }

    public void setValueList(VString vs) {
        this.setAttribute("ValueList", StringUtil.setvString(vs, " ", null, null), null);
    }

    public void setRegExp(String value) {
        this.setAttribute("RegExp", value);
    }

    public String getRegExp() {
        return this.getAttribute("RegExp", null, "");
    }

    @Override
    public boolean fitsValue(String value) {
        if (this.fitsListType(value)) {
            return this.fitsValueList(value) && this.fitsRegExp(value);
        }
        return false;
    }

    private final boolean fitsValueList(String value) {
        if (!this.hasAttribute("ValueList")) {
            return true;
        }
        VString vs = new VString(value, null);
        VString list = this.getValueList();
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(vs, list);
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(vs, list);
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(vs, list);
        }
        int v_size = vs.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            boolean bFound = false;
            for (int j = 0; j < l_size; ++j) {
                String str_j;
                String str_i = vs.elementAt(i);
                if (str_i.compareTo(str_j = list.elementAt(j)) != 0) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsRegExp(String str) {
        if (!this.hasAttribute("RegExp")) {
            return true;
        }
        return StringUtil.matches(str, this.getRegExp());
    }

    private final boolean fitsListType(String value) {
        if (!StringUtil.isNMTOKENS(value, false)) {
            return false;
        }
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType == null) {
            return true;
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.SingleValue) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.getEnum(0))) {
            return StringUtil.isNMTOKEN(value);
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.List) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.Span) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteList) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return true;
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueList)) {
            VString v = new VString(value, null);
            return this.isUnique(v);
        }
        throw new JDFException("JDFNameEvaluation.fitsListType illegal ListType attribute");
    }

    private final boolean fitsCompleteList(VString value, VString list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!this.isUnique(value)) {
            return false;
        }
        VString valueList = new VString(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.elementAt(i).equals(valueList.elementAt(j))) continue;
                valueList.remove(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(VString value, VString list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!this.isUnique(value)) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.elementAt(i).equals(value.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(VString value, VString list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.elementAt(i).equals(list.elementAt(j))) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean isUnique(VString v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                String sj;
                String si;
                if (j == i || (si = v.elementAt(i)).compareTo(sj = v.elementAt(j)) != 0) continue;
                return false;
            }
        }
        return true;
    }

    static {
        JDFNameEvaluation.atrInfoTable[0] = new AtrInfoTable("RegExp", 0x33333333L, AttributeInfo.EnumAttributeType.RegExp, null, null);
        JDFNameEvaluation.atrInfoTable[1] = new AtrInfoTable("ValueList", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
    }
}

