/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFNumberList;
import org.cip4.jdflib.datatypes.JDFNumberRange;
import org.cip4.jdflib.datatypes.JDFNumberRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.util.StringUtil;

public class JDFNumberState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[11];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFNumberState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFNumberState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFNumberState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFNumberState[ --> " + super.toString() + " ]";
    }

    public void setDefaultValue(double value) {
        this.setAttribute("DefaultValue", value, null);
    }

    public void setDefaultValue(JDFNumberList value) {
        this.setAttribute("DefaultValue", (JDFNumList)value, (String)null);
    }

    public void setCurrentValue(JDFNumberList value) {
        this.setAttribute("CurrentValue", (JDFNumList)value, (String)null);
    }

    public JDFNumberList getDefaultValue() {
        return this.getNumberList("DefaultValue");
    }

    public void setCurrentValue(double value) {
        this.setAttribute("CurrentValue", value, null);
    }

    public JDFNumberList getCurrentValue() {
        return this.getNumberList("CurrentValue");
    }

    public void setAllowedValueList(JDFNumberRangeList value) {
        this.setAttribute("AllowedValueList", value.toString(), null);
    }

    public JDFNumberRangeList getAllowedValueList() {
        return this.getNumberRangeList("AllowedValueList");
    }

    public void setPresentValueList(JDFNumberRangeList value) {
        this.setAttribute("PresentValueList", value.toString(), null);
    }

    public JDFNumberRangeList getPresentValueList() {
        JDFNumberRangeList nl = this.getNumberRangeList("PresentValueList");
        return nl == null ? this.getAllowedValueList() : nl;
    }

    public void setAllowedValueMax(double value) {
        this.setAttribute("AllowedValueMax", value, null);
    }

    public double getAllowedValueMax() {
        return this.getRealAttribute("AllowedValueMax", null, 0.0);
    }

    public void setPresentValueMax(double value) {
        this.setAttribute("PresentValueMax", value, null);
    }

    public double getPresentValueMax() {
        if (this.hasAttribute("PresentValueMax")) {
            return this.getRealAttribute("PresentValueMax", null, 0.0);
        }
        return this.getAllowedValueMax();
    }

    public void setAllowedValueMin(double value) {
        this.setAttribute("AllowedValueMin", value, null);
    }

    public double getAllowedValueMin() {
        return this.getRealAttribute("AllowedValueMin", null, 0.0);
    }

    public void setPresentValueMin(double value) {
        this.setAttribute("PresentValueMin", value, null);
    }

    public double getPresentValueMin() {
        if (this.hasAttribute("PresentValueMin")) {
            return this.getRealAttribute("PresentValueMin", null, 0.0);
        }
        return this.getAllowedValueMin();
    }

    public void setAllowedValueMod(JDFXYPair value) {
        this.setAttribute("AllowedValueMod", value.toString(), null);
    }

    public JDFXYPair getAllowedValueMod() {
        try {
            return new JDFXYPair(this.getAttribute("AllowedValueMod"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFNumberState.setAllowedValueMod: Attribute allowvaluemod is not applicable to create JDFXYPair");
        }
    }

    public void setPresentValueMod(JDFXYPair value) {
        this.setAttribute("PresentValueMod", value.toString());
    }

    public JDFXYPair getPresentValueMod() {
        try {
            if (this.hasAttribute("PresentValueMod")) {
                return new JDFXYPair(this.getAttribute("PresentValueMod"));
            }
            return this.getAllowedValueMod();
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFNumberState.setAllowedValueMod: The XYPair value is invalid!");
        }
    }

    public String getUnitType() {
        return this.getAttribute("UnitType");
    }

    public void setUnitType(String value) {
        this.setAttribute("UnitType", value);
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        JDFNumberRangeList list;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        if (!StringUtil.isNumber(value)) {
            return;
        }
        double d = StringUtil.parseDouble(value, 0.0);
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals(testlists)) {
            list = this.getAllowedValueList();
            if (list == null) {
                list = new JDFNumberRangeList();
            }
            list.append(d);
            this.setAllowedValueList(list);
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Present.equals(testlists)) {
            list = this.getPresentValueList();
            if (list == null || !this.hasAttribute("PresentValueList")) {
                list = new JDFNumberRangeList();
            }
            list.append(d);
            this.setPresentValueList(list);
        }
    }

    @Override
    public boolean fitsValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        if (this.fitsListType(value)) {
            JDFNumberRangeList rangelist = null;
            try {
                rangelist = new JDFNumberRangeList(value);
            }
            catch (DataFormatException dfe) {
                return false;
            }
            return this.fitsValueList(rangelist, testlists) && this.fitsValueMod(rangelist, testlists);
        }
        return false;
    }

    private final boolean fitsValueList(JDFNumberRangeList rangelist, JDFBaseDataTypes.EnumFitsValue valuelist) {
        JDFNumberRangeList list = valuelist.equals(JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueList() : this.getPresentValueList();
        if (list == null) {
            return true;
        }
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(rangelist, list);
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(rangelist, list);
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(rangelist, list);
        }
        int siz = rangelist.size();
        for (int i = 0; i < siz; ++i) {
            JDFNumberRange range = (JDFNumberRange)rangelist.at(i);
            if (list.isPartOfRange(range)) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsValueMod(JDFNumberRangeList rangelist, JDFBaseDataTypes.EnumFitsValue valuemod) {
        if (valuemod.equals(JDFBaseDataTypes.EnumFitsValue.Allowed) ? !this.hasAttribute("AllowedValueMod") : !this.hasAttribute("AllowedValueMod") && !this.hasAttribute("PresentValueMod")) {
            return true;
        }
        JDFXYPair mod = valuemod.equals(JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueMod() : this.getPresentValueMod();
        int i = 0;
        int siz = rangelist.size();
        if (i < siz) {
            double right;
            JDFNumberRange range = (JDFNumberRange)rangelist.at(i);
            double left = range.getLeft();
            if (left != (right = range.getRight())) {
                return false;
            }
            double elem = left;
            double divi = mod.getX();
            double shift = mod.getY();
            if (divi == 0.0) {
                return false;
            }
            double n = elem - divi * (double)((int)(elem / divi)) - shift;
            if (Math.abs(n) < 1.0E-6 * Math.abs(divi)) {
                return true;
            }
            double m = n - divi * (double)((int)(n / divi));
            return Math.abs(m) < 1.0E-6 * Math.abs(divi);
        }
        return true;
    }

    private final boolean fitsCompleteList(JDFNumberRangeList value, JDFNumberRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        JDFNumberRangeList valueList = new JDFNumberRangeList(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.at(i).equals(valueList.at(j))) continue;
                valueList.erase(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(JDFNumberRangeList value, JDFNumberRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.at(i).equals(value.at(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(JDFNumberRangeList value, JDFNumberRangeList list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.at(i).equals(list.at(j))) continue;
                return true;
            }
        }
        return false;
    }

    private JDFNumberList getNumberList(String listName) {
        try {
            String attribute = this.getAttribute(listName, null, null);
            if (attribute == null) {
                return null;
            }
            return new JDFNumberList(attribute);
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFNumberState.getNumberList, Unable to create JDFIntegerRangeList from Attribute value: " + listName);
        }
    }

    private JDFNumberRangeList getNumberRangeList(String listName) {
        try {
            String attribute = this.getAttribute(listName, null, null);
            if (attribute == null) {
                return null;
            }
            return new JDFNumberRangeList(attribute);
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFIntegerState.getIntegerRangeList, Unable to create JDFIntegerRangeList from Attribute value: " + listName);
        }
    }

    @Override
    public VString getInvalidAttributes(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        return this.getInvalidAttributesImpl(level, bIgnorePrivate, nMax);
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.NumberEvaluation;
    }

    static {
        JDFNumberState.atrInfoTable[0] = new AtrInfoTable("AllowedValueList", 0x33333331L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        JDFNumberState.atrInfoTable[1] = new AtrInfoTable("AllowedValueMax", 0x44444431L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFNumberState.atrInfoTable[2] = new AtrInfoTable("AllowedValueMin", 0x44444431L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFNumberState.atrInfoTable[3] = new AtrInfoTable("AllowedValueMod", 0x33333311L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFNumberState.atrInfoTable[4] = new AtrInfoTable("CurrentValue", 0x33333331L, AttributeInfo.EnumAttributeType.NumberList, null, null);
        JDFNumberState.atrInfoTable[5] = new AtrInfoTable("DefaultValue", 0x33333331L, AttributeInfo.EnumAttributeType.NumberList, null, null);
        JDFNumberState.atrInfoTable[6] = new AtrInfoTable("PresentValueList", 0x33333331L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        JDFNumberState.atrInfoTable[7] = new AtrInfoTable("PresentValueMax", 0x44444431L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFNumberState.atrInfoTable[8] = new AtrInfoTable("PresentValueMin", 0x44444431L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFNumberState.atrInfoTable[9] = new AtrInfoTable("PresentValueMod", 0x33333311L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFNumberState.atrInfoTable[10] = new AtrInfoTable("UnitType", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFNumberState.elemInfoTable[0] = new ElemInfoTable("ValueLoc", 0x33333311L);
    }
}

