/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFNumberRange;
import org.cip4.jdflib.datatypes.JDFNumberRangeList;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.datatypes.JDFShapeRange;
import org.cip4.jdflib.datatypes.JDFShapeRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;
import org.w3c.dom.DOMException;

public class JDFShapeEvaluation
extends JDFEvaluation {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[5];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFShapeEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFShapeEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFShapeEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFShapeEvaluation[  --> " + super.toString() + " ]";
    }

    public void setValueList(JDFShapeRangeList value) {
        this.setAttribute("ValueList", value.toString());
    }

    public JDFShapeRangeList getValueList() {
        try {
            JDFShapeRangeList srl = new JDFShapeRangeList(this.getAttribute("ValueList"));
            return srl;
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeEvaluation.getValueList: Attribute VALUELIST is not capable to create JDFShapeRangeList");
        }
    }

    public void setX(JDFNumberRangeList value) {
        this.setAttribute("X", value.toString(), null);
    }

    public JDFNumberRangeList getX() {
        try {
            JDFNumberRangeList nrl = new JDFNumberRangeList(this.getAttribute("X"));
            return nrl;
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeEvaluation.getX: Attribute X is not capable to create JDFNumberRangeList");
        }
    }

    public void setY(JDFNumberRangeList value) {
        this.setAttribute("Y", value.toString(), null);
    }

    public JDFNumberRangeList getY() {
        try {
            JDFNumberRangeList nrl = new JDFNumberRangeList(this.getAttribute("Y"));
            return nrl;
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeEvaluation.getY: Attribute Y is not capable to create JDFNumberRangeList");
        }
    }

    public void setZ(JDFNumberRangeList value) {
        this.setAttribute("Z", value.toString(), null);
    }

    public JDFNumberRangeList getZ() {
        try {
            JDFNumberRangeList nrl = new JDFNumberRangeList(this.getAttribute("Z"));
            return nrl;
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFShapeEvaluation.getZ: Attribute Z is not capable to create JDFNumberRangeList");
        }
    }

    public void setTolerance(JDFXYPair value) {
        this.setAttribute("Tolerance", value.toString(), null);
    }

    @Override
    public JDFXYPair getTolerance() {
        return super.getTolerance();
    }

    @Override
    public boolean fitsValue(String value) {
        if (!this.fitsListType(value)) {
            return false;
        }
        JDFShapeRangeList rrl = null;
        try {
            rrl = new JDFShapeRangeList(value);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        int siz = rrl.size();
        for (int i = 0; i < siz; ++i) {
            JDFShapeRange range = (JDFShapeRange)rrl.at(i);
            if (this.fitsValueList(range) && this.fitsXYZ(range)) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsListType(String value) {
        JDFShapeRangeList rangelist;
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        try {
            rangelist = new JDFShapeRangeList(value);
        }
        catch (DataFormatException e) {
            return false;
        }
        catch (JDFException e) {
            return false;
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.SingleValue) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.getEnum(0))) {
            try {
                new JDFShape(value);
            }
            catch (JDFException e) {
                return false;
            }
            catch (DataFormatException e) {
                return false;
            }
            return true;
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.RangeList) || listType.equals(JDFAutoBasicPreflightTest.EnumListType.Span)) {
            return true;
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.List)) {
            return rangelist.isList();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.OrderedList)) {
            return rangelist.isList() && rangelist.isOrdered();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueList)) {
            return rangelist.isList() && rangelist.isUnique();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedList)) {
            return rangelist.isList() && rangelist.isUniqueOrdered();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.OrderedRangeList)) {
            return rangelist.isOrdered();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueRangeList)) {
            return rangelist.isUnique();
        }
        if (listType.equals(JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedRangeList)) {
            return rangelist.isUniqueOrdered();
        }
        throw new JDFException("JDFShapeEvaluation.fitsListType illegal ListType attribute");
    }

    private final boolean fitsValueList(JDFShapeRange range) {
        if (!this.hasAttribute("ValueList")) {
            return true;
        }
        JDFShapeRangeList rangelist = this.getValueList();
        if (this.hasAttribute("Tolerance")) {
            return this.fitsTolerance(rangelist).isPartOfRange(range);
        }
        return rangelist.isPartOfRange(range);
    }

    private JDFShapeRangeList fitsTolerance(JDFShapeRangeList origRangeList) {
        double nt = this.getTolerance().getX();
        double pt = this.getTolerance().getY();
        if (nt == 0.0 && pt == 0.0) {
            return origRangeList;
        }
        JDFShapeRangeList rangeList = new JDFShapeRangeList(origRangeList);
        JDFShapeRangeList tolRangeList = new JDFShapeRangeList();
        int size = rangeList.size();
        for (int i = 0; i < size; ++i) {
            JDFShapeRange range = (JDFShapeRange)rangeList.at(i);
            JDFShape left = range.getLeft();
            double leftX = left.getY();
            double leftY = left.getX();
            double leftZ = left.getZ();
            left.setY(leftX - nt);
            left.setX(leftY - nt);
            left.setZ(leftZ - nt);
            JDFShape right = range.getRight();
            double rightX = right.getY();
            double rightY = right.getX();
            double rightZ = right.getZ();
            right.setY(rightX + pt);
            right.setX(rightY + pt);
            right.setZ(rightZ + pt);
            range.setLeft(left);
            range.setRight(right);
            tolRangeList.append(range);
        }
        return tolRangeList;
    }

    private boolean fitsXYZ(JDFShapeRange range) {
        JDFShape left = range.getLeft();
        JDFShape right = range.getRight();
        double leftX = left.getY();
        double rightX = right.getY();
        JDFNumberRange rangeX = new JDFNumberRange(leftX, rightX);
        double leftY = left.getX();
        double rightY = right.getX();
        JDFNumberRange rangeY = new JDFNumberRange(leftY, rightY);
        double leftZ = left.getZ();
        double rightZ = right.getZ();
        JDFNumberRange rangeZ = new JDFNumberRange(leftZ, rightZ);
        JDFNumberRangeList x = this.getX();
        JDFNumberRangeList y = this.getY();
        JDFNumberRangeList z = this.getZ();
        if (this.hasAttribute("Tolerance")) {
            x = this.fitsXYZTolerance(x);
            y = this.fitsXYZTolerance(y);
            z = this.fitsXYZTolerance(z);
        }
        boolean bFit = true;
        if (x.size() != 0) {
            bFit = x.isPartOfRange(rangeX);
        }
        if (!bFit) {
            return false;
        }
        if (y.size() != 0) {
            bFit = y.isPartOfRange(rangeY);
        }
        if (!bFit) {
            return false;
        }
        if (z.size() != 0) {
            bFit = z.isPartOfRange(rangeZ);
        }
        return bFit;
    }

    public JDFNumberRangeList fitsXYZTolerance(JDFNumberRangeList origRangeList) {
        double nt = this.getTolerance().getX();
        double pt = this.getTolerance().getY();
        if (nt == 0.0 && pt == 0.0) {
            return origRangeList;
        }
        JDFNumberRangeList rangeList = new JDFNumberRangeList(origRangeList);
        JDFNumberRangeList tolRangeList = new JDFNumberRangeList();
        int size = rangeList.size();
        for (int i = 0; i < size; ++i) {
            JDFNumberRange range = (JDFNumberRange)rangeList.at(i);
            JDFNumberRange r = new JDFNumberRange();
            r.setLeft(range.getLeft() - nt);
            r.setRight(range.getRight() + pt);
            tolRangeList.append(r);
        }
        return tolRangeList;
    }

    static {
        JDFShapeEvaluation.atrInfoTable[0] = new AtrInfoTable("Tolerance", 0x33333333L, AttributeInfo.EnumAttributeType.XYPair, null, "0 0");
        JDFShapeEvaluation.atrInfoTable[1] = new AtrInfoTable("ValueList", 0x33333333L, AttributeInfo.EnumAttributeType.ShapeRangeList, null, null);
        JDFShapeEvaluation.atrInfoTable[2] = new AtrInfoTable("X", 0x33333333L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        JDFShapeEvaluation.atrInfoTable[3] = new AtrInfoTable("Y", 0x33333333L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
        JDFShapeEvaluation.atrInfoTable[4] = new AtrInfoTable("Z", 0x33333333L, AttributeInfo.EnumAttributeType.NumberRangeList, null, null);
    }
}

