/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.auto.JDFAutoDefect;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFSurfaceMark;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.w3c.dom.DOMException;

public class JDFComponent
extends JDFAutoComponent {
    private static final long serialVersionUID = 1L;

    public JDFComponent(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFComponent(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFComponent(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFComponent[  --> " + super.toString() + " ]";
    }

    public void setDimensions(JDFXYPair dimension) {
        if (dimension != null) {
            JDFShape s = new JDFShape(dimension.getX(), dimension.getY());
            super.setDimensions(s);
        }
    }

    public JDFSurfaceMark getCreateSurfaceMark(JDFAutoDefect.EFace face) {
        JDFSurfaceMark sm = this.getSurfaceMark(face);
        if (sm == null) {
            sm = this.appendSurfaceMark(face);
        }
        return sm;
    }

    public JDFSurfaceMark getSurfaceMark(JDFAutoDefect.EFace face) {
        return this.getChildWithAttribute(JDFSurfaceMark.class, "Surface", face.name());
    }

    public JDFSurfaceMark appendSurfaceMark(JDFAutoDefect.EFace face) {
        JDFSurfaceMark sm = this.appendSurfaceMark();
        sm.setSurface(face);
        return sm;
    }

    public void setComponentType(JDFAutoComponent.EnumComponentType partialFinal, JDFAutoComponent.EnumComponentType sheetWebProof) {
        Vector<JDFAutoComponent.EnumComponentType> v = new Vector<JDFAutoComponent.EnumComponentType>();
        if (partialFinal != null) {
            v.add(partialFinal);
        }
        if (sheetWebProof != null) {
            v.add(sheetWebProof);
        }
        if (v.size() == 0) {
            v = null;
        }
        this.setComponentType(v);
    }

    public boolean isComponentType(JDFAutoComponent.EnumComponentType typ) {
        Vector<JDFAutoComponent.EnumComponentType> v = this.getComponentType();
        return v != null && typ != null && v.contains(typ);
    }

    @Override
    public JDFMedia getMedia() {
        JDFMedia m = (JDFMedia)this.getElement("Media");
        if (m != null) {
            return m;
        }
        JDFLayout lo = this.getLayout();
        if (lo == null) {
            return null;
        }
        m = (lo = (JDFLayout)lo.getPartition(this.getPartMap(), JDFResource.EnumPartUsage.Implicit)).getMedia(JDFAutoMedia.EnumMediaType.Paper);
        if (m == null) {
            m = lo.getMedia(0);
        }
        return m;
    }
}

