/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoComChannel;
import org.cip4.jdflib.auto.JDFAutoContact;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.resource.process.JDFAddress;
import org.cip4.jdflib.resource.process.JDFComChannel;
import org.cip4.jdflib.resource.process.JDFPerson;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFContact
extends JDFAutoContact
implements IMatches {
    private static final long serialVersionUID = 1L;

    public JDFContact(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFContact(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFContact(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFContact[  --> " + super.toString() + " ]";
    }

    @Deprecated
    public void setExtendedContactTypes(VString value) {
        this.setContactTypes(value);
    }

    @Deprecated
    public VString getExtendedContactTypes() {
        return this.getContactTypes();
    }

    public void setContactTypes(EnumContactType typ) {
        if (typ == null) {
            this.removeAttribute("ContactTypes");
        } else {
            this.setAttribute("ContactTypes", typ.getName(), null);
        }
    }

    public void setContactTypes(String typ) {
        this.setAttribute("ContactTypes", typ, null);
    }

    public void addContactTypes(EnumContactType typ) {
        if (typ != null) {
            this.appendAttribute("ContactTypes", typ.getName(), null, " ", true);
        }
    }

    public JDFComChannel getComChannel(JDFAutoComChannel.EnumChannelType ct) {
        JDFComChannel cc = JDFComChannel.getChannelByType(this, ct);
        if (cc == null) {
            return JDFComChannel.getChannelByType(this.getPerson(), ct);
        }
        return cc;
    }

    public JDFComChannel appendComChannel(JDFAutoComChannel.EnumChannelType ct, String locator) {
        return JDFComChannel.appendChannel(this, ct, locator);
    }

    public JDFComChannel appendComChannel(JDFAutoComChannel.EnumChannelType channelType) {
        JDFComChannel comCh = this.appendComChannel();
        comCh.setChannelType(channelType);
        return comCh;
    }

    public JDFPerson setPerson(String firstName, String familyName) {
        JDFPerson p = null;
        if (firstName != null || familyName != null) {
            p = this.getCreatePerson();
            p.setFirstName(firstName);
            p.setFamilyName(familyName);
        }
        return p;
    }

    public void merge(JDFContact other) {
        if (other == null || this.equals(other)) {
            return;
        }
        if (this.getPerson() == null) {
            this.copyElement(other.getPerson(), null);
        }
        if (this.getAddress() == null) {
            this.copyElement(other.getAddress(), null);
        }
        if (this.getCompany() == null) {
            this.copyElement(other.getCompany(), null);
        }
        this.mergeComChannels(other);
        this.mergeContactTypes(other);
    }

    private void mergeComChannels(JDFContact other) {
        Collection<JDFComChannel> cso;
        Collection<JDFComChannel> cs = this.getAllComChannel();
        if (cs == null) {
            cs = new Vector<JDFComChannel>();
        }
        if ((cso = other.getAllComChannel()) != null) {
            for (JDFComChannel occ : cso) {
                if (ContainerUtil.getMatch(cs, occ, 0) != null) continue;
                this.copyElement(occ, null);
                cs.add(occ);
            }
        }
    }

    private void mergeContactTypes(JDFContact other) {
        VString contactTypes = this.getContactTypes();
        int s0 = contactTypes.size();
        Collection<String> vs = ContainerUtil.addAll(contactTypes, other.getContactTypes());
        ContainerUtil.unify(vs);
        if (vs != null && vs.size() > s0) {
            VString nct = new VString();
            nct.addAll(vs);
            this.setContactTypes(nct);
        }
    }

    @Override
    public boolean matches(Object subset) {
        boolean matches = false;
        if (subset instanceof String) {
            String subString = StringUtil.normalize((String)subset, true);
            matches = subString == null ? false : subString.equalsIgnoreCase(this.getUserID());
        } else if (subset instanceof JDFContact) {
            JDFContact other = (JDFContact)subset;
            String userID = StringUtil.normalize(this.getUserID(), true);
            String otherUserID = StringUtil.normalize(other.getUserID(), true);
            if (userID != null && otherUserID != null) {
                matches = userID.equals(otherUserID);
            } else {
                matches = this.hasChildElement("Address", null) || this.hasChildElement("Company", null) || this.hasChildElement("Person", null);
                matches = matches && ContainerUtil.matchesExisting(this.getAddress(), other.getAddress());
                matches = matches && ContainerUtil.matchesExisting(this.getCompany(), other.getCompany());
                matches = matches && ContainerUtil.matchesExisting(this.getPerson(), other.getPerson());
            }
        }
        return matches;
    }

    @Override
    public JDFAddress getAddress() {
        JDFPerson p;
        JDFAddress a = super.getAddress();
        if (a == null && (p = this.getPerson()) != null) {
            a = p.getAddress();
        }
        return a;
    }

    @Override
    public JDFAddress getCreateAddress() {
        JDFAddress address = this.getAddress();
        return address == null ? this.appendAddress() : address;
    }

    public static final class EnumContactType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumContactType Accounting = new EnumContactType("Accounting");
        public static final EnumContactType Administrator = new EnumContactType("Administrator");
        public static final EnumContactType Agency = new EnumContactType("Agency");
        public static final EnumContactType Approver = new EnumContactType("Approver");
        public static final EnumContactType ArtReturn = new EnumContactType("ArtReturn");
        public static final EnumContactType Author = new EnumContactType("Author");
        public static final EnumContactType Billing = new EnumContactType("Billing");
        public static final EnumContactType Customer = new EnumContactType("Customer");
        public static final EnumContactType Delivery = new EnumContactType("Delivery");
        public static final EnumContactType DeliveryCharge = new EnumContactType("DeliveryCharge");
        public static final EnumContactType Designer = new EnumContactType("Designer");
        public static final EnumContactType Editor = new EnumContactType("Editor");
        public static final EnumContactType Employee = new EnumContactType("Employee");
        public static final EnumContactType Illustrator = new EnumContactType("Illustrator");
        public static final EnumContactType Owner = new EnumContactType("Owner");
        public static final EnumContactType Photographer = new EnumContactType("Photographer");
        public static final EnumContactType Pickup = new EnumContactType("Pickup");
        public static final EnumContactType Sender = new EnumContactType("Sender");
        public static final EnumContactType Supplier = new EnumContactType("Supplier");
        public static final EnumContactType SurplusReturn = new EnumContactType("SurplusReturn");
        public static final EnumContactType TelephoneSanitizer = new EnumContactType("TelephoneSanitizer");

        private EnumContactType(String name) {
            super(name, m_startValue++);
        }

        public static EnumContactType getEnum(String enumName) {
            return (EnumContactType)EnumContactType.getEnum(EnumContactType.class, enumName);
        }

        public static EnumContactType getEnum(int enumValue) {
            return (EnumContactType)EnumContactType.getEnum(EnumContactType.class, enumValue);
        }

        public static Map getEnumMap() {
            return EnumContactType.getEnumMap(EnumContactType.class);
        }

        public static List getEnumList() {
            return EnumContactType.getEnumList(EnumContactType.class);
        }

        public static Iterator iterator() {
            return EnumContactType.iterator(EnumContactType.class);
        }
    }
}

