/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPageData;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.resource.JDFPageList;
import org.cip4.jdflib.resource.process.JDFContentData;
import org.cip4.jdflib.resource.process.JDFPageElement;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFPageData
extends JDFAutoPageData {
    private static final long serialVersionUID = 1L;

    public JDFPageData(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPageData(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPageData(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public void refContentData(JDFContentData letter) {
        JDFPageElement pe = this.appendPageElement();
        if (letter != null) {
            pe.setContentListIndex(letter.getIndex());
        }
    }

    @Override
    public JDFIntegerRangeList getPageIndex() {
        JDFIntegerRangeList pi = super.getPageIndex();
        if (pi != null && pi.size() > 0) {
            return pi;
        }
        int n = 0;
        for (JDFPageData prev = (JDFPageData)this.getPreviousSiblingElement("PageData", null); prev != null; prev = (JDFPageData)prev.getPreviousSiblingElement("PageData", null)) {
            ++n;
            if (!prev.hasNonEmpty("PageIndex")) continue;
            JDFIntegerRangeList ppi = prev.getPageIndex();
            n += ppi.getIntegerList().getInt(-1);
            break;
        }
        JDFIntegerRangeList integerRangeList = new JDFIntegerRangeList();
        integerRangeList.append(n);
        return integerRangeList;
    }

    @Override
    public VString getAssemblyIDs() {
        if (this.hasNonEmpty("AssemblyIDs")) {
            return super.getAssemblyIDs();
        }
        if (this.hasNonEmpty("AssemblyID")) {
            return new VString(super.getAssemblyID());
        }
        JDFPageList parent = this.getPageList();
        if (parent != null) {
            return parent.getAssemblyIDs();
        }
        return super.getAssemblyIDs();
    }

    @Override
    public String getAssemblyID() {
        VString ids;
        if (this.hasNonEmpty("AssemblyID")) {
            return super.getAssemblyID();
        }
        if (this.hasNonEmpty("AssemblyIDs") && !StringUtil.isEmpty(ids = super.getAssemblyIDs())) {
            return ids.get(0);
        }
        JDFPageList parent = this.getPageList();
        if (parent != null) {
            return parent.getAssemblyID();
        }
        return super.getAssemblyID();
    }

    public JDFPageList getPageList() {
        KElement parent = this.getParentNode_KElement();
        return parent instanceof JDFPageList ? (JDFPageList)parent : null;
    }

    public void setPageIndex(int value) {
        this.setAttribute("PageIndex", value, (String)null);
    }
}

