/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPreview;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.resource.process.JDFFileSpec;
import org.cip4.jdflib.util.UrlUtil;
import org.w3c.dom.DOMException;

public class JDFPreview
extends JDFAutoPreview
implements IURLSetter {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[1];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFPreview(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPreview(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPreview(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public InputStream getURLInputStream() {
        return this.getURLInputStream(this.getURL());
    }

    @Override
    public String toString() {
        return "JDFPreview[  --> " + super.toString() + " ]";
    }

    @Override
    public String getUserFileName() {
        return null;
    }

    public void setPreviewFileType(EnumPreviewFileType enumPreviewFileType) {
        super.setPreviewFileType(enumPreviewFileType == null ? null : enumPreviewFileType.getName());
    }

    public EnumPreviewFileType getEnumPreviewFileType() {
        return EnumPreviewFileType.getEnum(this.getAttribute("PreviewFileType", null, EnumPreviewFileType.PNG.getName()));
    }

    public JDFFileSpec getCreateFileSpec() {
        return (JDFFileSpec)this.getCreateElement_KElement("FileSpec", null, 0);
    }

    public JDFFileSpec getFileSpec() {
        return (JDFFileSpec)this.getElement("FileSpec");
    }

    public String getFileURL() {
        JDFFileSpec fspec = this.getFileSpec();
        if (fspec == null) {
            return null;
        }
        return UrlUtil.getURLWithDirectory(this.getDirectory(), fspec.getURL());
    }

    public boolean setFileSpecURL(String url) {
        JDFFileSpec fspec = this.getCreateFileSpec();
        fspec.setMimeURL(url);
        return true;
    }

    static {
        JDFPreview.atrInfoTable[0] = new AtrInfoTable("URL", 0x22222222L, AttributeInfo.EnumAttributeType.URL, null, null);
    }

    public static class EnumPreviewFileType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPreviewFileType PNG = new EnumPreviewFileType("PNG");
        public static final EnumPreviewFileType CIP3Multiple = new EnumPreviewFileType("CIP3Multiple");
        public static final EnumPreviewFileType CIP3Single = new EnumPreviewFileType("CIP3Single");

        private EnumPreviewFileType(String name) {
            super(name, m_startValue++);
        }

        public static EnumPreviewFileType getEnum(String enumName) {
            return (EnumPreviewFileType)EnumPreviewFileType.getEnum(EnumPreviewFileType.class, enumName);
        }

        public static EnumPreviewFileType getEnum(int enumValue) {
            return (EnumPreviewFileType)EnumPreviewFileType.getEnum(EnumPreviewFileType.class, enumValue);
        }

        public static Map getEnumMap() {
            return EnumPreviewFileType.getEnumMap(EnumPreviewFileType.class);
        }

        public static List getEnumList() {
            return EnumPreviewFileType.getEnumList(EnumPreviewFileType.class);
        }

        public static Iterator iterator() {
            return EnumPreviewFileType.iterator(EnumPreviewFileType.class);
        }
    }
}

