/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoRunList;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.resource.JDFPageList;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFFileSpec;
import org.cip4.jdflib.resource.process.JDFLayoutElement;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.w3c.dom.DOMException;

public class JDFRunList
extends JDFAutoRunList {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[1];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFRunList(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFRunList(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFRunList(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFRunList[ --> " + super.toString() + " ]";
    }

    @Deprecated
    public JDFRunList addRun(String fileName) {
        return this.addRun(fileName, 0, -1);
    }

    @Deprecated
    public JDFRunList addRun(String fileName, int first) {
        return this.addRun(fileName, first, -1);
    }

    public JDFRunList addRun(String fileName, int first, int last) {
        String runID = "Run" + JDFRunList.uniqueID(0);
        JDFRunList r = (JDFRunList)this.addPartition(JDFResource.EnumPartIDKey.Run, runID);
        JDFIntegerRangeList irl = new JDFIntegerRangeList();
        irl.append(first, last);
        r.setPages(irl);
        JDFLayoutElement loe = (JDFLayoutElement)r.appendElement("LayoutElement", null);
        loe.setMimeURL(fileName);
        r.updateNPage(first, last, true);
        return r;
    }

    private void updateNPage(int first, int last, boolean bLeaf) {
        if (first < 0 || last < 0) {
            return;
        }
        if (bLeaf) {
            npage = 0;
        } else {
            String s = this.getAttribute_KElement("NPage", null, null);
            npage = StringUtil.parseInt(s, 0);
        }
        int n = Math.abs(last - first);
        this.setNPage(npage += n + 1);
        JDFRunList parent = (JDFRunList)this.getParentPartition();
        if (parent != null) {
            parent.updateNPage(first, last, false);
        }
    }

    @Deprecated
    public JDFRunList addPDF(String fileName) {
        return this.addPDF(fileName, 0, -1);
    }

    @Deprecated
    public JDFRunList addPDF(String fileName, int first) {
        return this.addPDF(fileName, first, -1);
    }

    public JDFRunList addPDF(String fileName, int first, int last) {
        JDFRunList r = this.addRun(fileName, first, last);
        JDFFileSpec fs = r.getLayoutElement().getFileSpec();
        fs.setMimeType("application/pdf");
        return r;
    }

    @Deprecated
    public JDFRunList addSepRun(Vector fileNames, Vector sepNames) {
        return this.addSepRun(fileNames, sepNames, 0, 1, true);
    }

    @Deprecated
    public JDFRunList addSepRun(Vector fileNames, Vector sepNames, int first) {
        return this.addSepRun(fileNames, sepNames, first, 1, true);
    }

    @Deprecated
    public JDFRunList addSepRun(Vector fileNames, Vector sepNames, int first, int n) {
        return this.addSepRun(fileNames, sepNames, first, n, true);
    }

    @Deprecated
    public JDFRunList addSepRun(Vector fileNames, Vector sepNames, int first, boolean pageMajor) {
        return this.addSepRun(fileNames, sepNames, first, 1, pageMajor);
    }

    @Deprecated
    public JDFRunList addSepRun(Vector fileNames, Vector sepNames, boolean pageMajor) {
        return this.addSepRun(fileNames, sepNames, 0, 1, pageMajor);
    }

    public JDFRunList addSepRun(Vector fileNames, Vector sepNames, int first, int n, boolean pageMajor) {
        JDFRunList r = (JDFRunList)this.addPartition(JDFResource.EnumPartIDKey.Run, "Run" + JDFRunList.uniqueID(0));
        int siz = fileNames.size();
        r.setNPage(n);
        r.setIsPage(true);
        for (int i = 0; i < sepNames.size(); ++i) {
            JDFRunList rs = (JDFRunList)r.addPartition(JDFResource.EnumPartIDKey.Separation, sepNames.elementAt(i).toString());
            JDFLayoutElement lo = rs.appendLayoutElement();
            lo.setMimeURL((String)fileNames.elementAt(Math.min(i, siz - 1)));
            rs.setIsPage(false);
            if (fileNames.size() == sepNames.size()) {
                rs.setFirstPage(first);
                continue;
            }
            if (pageMajor) {
                rs.setSkipPage(sepNames.size() - 1);
                rs.setFirstPage(i + first);
                continue;
            }
            rs.setFirstPage(i * n + first);
        }
        return r;
    }

    @Deprecated
    public JDFRunList addSepRun(VElement fileSpec, Vector sepNames) {
        return this.addSepRun(fileSpec, sepNames, 0, 1, true);
    }

    @Deprecated
    public JDFRunList addSepRun(VElement fileSpec, Vector sepNames, int first) {
        return this.addSepRun(fileSpec, sepNames, first, 1, true);
    }

    @Deprecated
    public JDFRunList addSepRun(VElement fileSpec, Vector sepNames, int first, int n) {
        return this.addSepRun(fileSpec, sepNames, first, n, true);
    }

    @Deprecated
    public JDFRunList addSepRun(VElement fileSpec, Vector sepNames, int first, boolean pageMajor) {
        return this.addSepRun(fileSpec, sepNames, first, 1, pageMajor);
    }

    @Deprecated
    public JDFRunList addSepRun(VElement fileSpec, Vector sepNames, boolean pageMajor) {
        return this.addSepRun(fileSpec, sepNames, 0, 1, pageMajor);
    }

    @Deprecated
    public JDFRunList addSepRun(VElement fileSpec, Vector sepNames, int first, int n, boolean pageMajor) {
        JDFRunList r = (JDFRunList)this.addPartition(JDFResource.EnumPartIDKey.Run, "Run" + JDFRunList.uniqueID(0));
        int siz = fileSpec.size();
        r.setNPage(n);
        for (int i = 0; i < sepNames.size(); ++i) {
            JDFRunList rs = (JDFRunList)r.addPartition(JDFResource.EnumPartIDKey.Separation, sepNames.elementAt(i).toString());
            JDFResource rfspec = (JDFResource)fileSpec.elementAt(Math.min(i, siz - 1));
            rs.refElement(rfspec);
            if (fileSpec.size() == sepNames.size()) {
                rs.setAttribute("FirstPage", first, "");
                continue;
            }
            if (pageMajor) {
                rs.setAttribute("SkipPage", sepNames.size() - 1, "");
                rs.setAttribute("FirstPage", i + first, "");
                continue;
            }
            rs.setAttribute("FirstPage", i * n + first, "");
        }
        return r;
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, ",", false), 0, 1, true);
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames, int first) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, ",", false), first, 1, true);
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames, int first, int n) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, ",", false), first, n, true);
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames, int first, boolean pageMajor) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, ",", false), first, 1, pageMajor);
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames, boolean pageMajor) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, ",", false), 0, 1, pageMajor);
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames, String sep) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, sep, false), 0, 1, true);
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames, int first, String sep) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, sep, false), first, 1, true);
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames, int first, int n, String sep) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, sep, false), first, n, true);
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames, int first, boolean pageMajor, String sep) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, sep, false), first, 1, pageMajor);
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames, boolean pageMajor, String sep) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, sep, false), 0, 1, pageMajor);
    }

    @Deprecated
    public JDFRunList addSepRun(JDFResource fileSpec, String sepNames, int first, int n, boolean pageMajor, String sep) {
        VElement v = new VElement();
        v.add(fileSpec);
        return this.addSepRun(v, (Vector)StringUtil.tokenize(sepNames, sep, false), first, n, pageMajor);
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames) {
        return this.addSepRun(fileNames, sepNames, 0, 1, true, ",");
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames, int first) {
        return this.addSepRun(fileNames, sepNames, first, 1, true, ",");
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames, int first, int n) {
        return this.addSepRun(fileNames, sepNames, first, n, true, ",");
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames, int first, boolean pageMajor) {
        return this.addSepRun(fileNames, sepNames, first, 1, pageMajor, ",");
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames, boolean pageMajor) {
        return this.addSepRun(fileNames, sepNames, 0, 1, pageMajor, ",");
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames, String sep) {
        return this.addSepRun(fileNames, sepNames, 0, 1, true, sep);
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames, int first, String sep) {
        return this.addSepRun(fileNames, sepNames, first, 1, true, sep);
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames, int first, int n, String sep) {
        return this.addSepRun(fileNames, sepNames, first, n, true, sep);
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames, int first, boolean pageMajor, String sep) {
        return this.addSepRun(fileNames, sepNames, first, 1, pageMajor, sep);
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames, boolean pageMajor, String sep) {
        return this.addSepRun(fileNames, sepNames, 0, 1, pageMajor, sep);
    }

    @Deprecated
    public JDFRunList addSepRun(String fileNames, String sepNames, int first, int n, boolean pageMajor, String sep) {
        return this.addSepRun(StringUtil.tokenize(fileNames, sep, false), (Vector)StringUtil.tokenize(sepNames, sep, false), first, n, pageMajor);
    }

    public boolean setFileURL(String url) {
        JDFFileSpec fspec = this.getCreateLayoutElement().getCreateFileSpec();
        fspec.setMimeURL(url);
        return true;
    }

    public boolean setFileSpecURL(String url) {
        JDFFileSpec fspec = this.getCreateFileSpec();
        fspec.setMimeURL(url);
        return true;
    }

    public JDFFileSpec getCreateFileSpec() {
        return (JDFFileSpec)this.getCreateElement_KElement("FileSpec", null, 0);
    }

    public boolean setByteMapURL(String url) {
        JDFFileSpec fspec = this.getCreateByteMap().getCreateFileSpec(0);
        fspec.setResourceUsage("RasterFileLocation");
        fspec.setMimeURL(url);
        return true;
    }

    public String getFileURL() {
        JDFFileSpec fspec = this.getFileSpec();
        if (fspec == null) {
            return null;
        }
        return UrlUtil.getURLWithDirectory(this.getDirectory(), fspec.getURL());
    }

    @Override
    public void setPages(JDFIntegerRangeList value) {
        super.setPages(value);
        if (value == null) {
            return;
        }
        if (value.getDef() <= 0 && super.getNPage() > 0) {
            value = new JDFIntegerRangeList(value);
            value.setDef(super.getNPage());
        }
        if (value.getElementCount() > 0) {
            this.setNPage(value.getElementCount());
        }
    }

    public String getFileMimeType() {
        JDFFileSpec fspec = this.getFileSpec();
        if (fspec == null) {
            return null;
        }
        return fspec.getMimeType();
    }

    public JDFFileSpec getFileSpec() {
        JDFLayoutElement lay = this.getLayoutElement();
        if (lay == null) {
            return (JDFFileSpec)this.getElement("FileSpec");
        }
        return lay.getFileSpec();
    }

    public HashMap<String, VJDFAttributeMap> getCommonURLFileSpecMap() {
        VElement vE = this.getLeaves(false);
        HashMap<String, VJDFAttributeMap> fileMap = new HashMap<String, VJDFAttributeMap>();
        for (int i = 0; i < vE.size(); ++i) {
            JDFRunList rl = (JDFRunList)vE.elementAt(i);
            String url = rl.getFileURL();
            VJDFAttributeMap vPart = null;
            if (!fileMap.containsKey(url)) {
                vPart = new VJDFAttributeMap();
                vPart.addElement(rl.getPartMap());
                fileMap.put(url, vPart);
                continue;
            }
            vPart = fileMap.get(url);
            vPart.addElement(rl.getPartMap());
        }
        return fileMap;
    }

    @Override
    public Vector<JDFResource.EnumPartIDKey> getImplicitPartitions() {
        Vector<JDFResource.EnumPartIDKey> v = super.getImplicitPartitions();
        if ("Dynamic".equals(this.getAttribute("Automation"))) {
            return v;
        }
        if (v == null) {
            v = new Vector();
        }
        v.add(JDFResource.EnumPartIDKey.RunIndex);
        v.add(JDFResource.EnumPartIDKey.DocIndex);
        v.add(JDFResource.EnumPartIDKey.DocRunIndex);
        v.add(JDFResource.EnumPartIDKey.DocSheetIndex);
        v.add(JDFResource.EnumPartIDKey.SetIndex);
        v.add(JDFResource.EnumPartIDKey.PageNumber);
        return v;
    }

    public Iterator<JDFRunData> getPageIterator() {
        return new PageIterator(this);
    }

    public int getFirstIndex() {
        return this.getFirstIndex(null);
    }

    protected int getFirstIndex(JDFRunData last) {
        KElement e;
        if (this.hasAttribute("LogicalPage")) {
            return this.getLogicalPage();
        }
        if (!this.getIsPage() && (e = this.getParentNode_KElement()) instanceof JDFRunList) {
            return ((JDFRunList)e).getFirstIndex(last);
        }
        JDFRunList rl = (JDFRunList)this.getElement_KElement("RunList", null, 0);
        if (rl != null && rl.getIsPage()) {
            return rl.getFirstIndex(last);
        }
        JDFRunList previousRL = (JDFRunList)this.getPreviousSiblingElement("RunList", null);
        if (previousRL == null) {
            return 0;
        }
        int offset = 0;
        offset = last != null && previousRL == last.runList ? last.lastIndex : previousRL.getLastIndex(last);
        return offset + 1;
    }

    public VElement getPageLeaves() {
        VElement v = this.getLeaves(false);
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            JDFRunList rl;
            boolean bRep = false;
            for (rl = (JDFRunList)v.elementAt(i); rl != null && !rl.getIsPage(); rl = (JDFRunList)rl.getParentNode_KElement()) {
                bRep = true;
            }
            if (!bRep) continue;
            v.set(i, rl);
        }
        v.unify();
        return v;
    }

    public int getLastIndex() {
        return this.getLastIndex(null);
    }

    protected int getLastIndex(JDFRunData last) {
        KElement e;
        if (!this.getIsPage() && (e = this.getParentNode_KElement()) instanceof JDFRunList) {
            return ((JDFRunList)e).getLastIndex(last);
        }
        JDFRunList rl = (JDFRunList)this.getElement_KElement("RunList", null, -1);
        if (rl != null && rl.getIsPage()) {
            return rl.getLastIndex(last);
        }
        int offset = -1;
        if (this.hasAttribute("LogicalPage")) {
            offset = this.getLogicalPage() - 1;
        } else {
            JDFRunList previousRL = (JDFRunList)this.getPreviousSiblingElement("RunList", null);
            if (previousRL != null) {
                offset = last != null && last.runList == previousRL ? last.lastIndex : previousRL.getLastIndex(last);
            }
        }
        return offset + this.getNPage();
    }

    @Override
    public int getNPage() {
        int n = 0;
        if (!this.getIsPage()) {
            return 0;
        }
        if (this.hasAttribute_KElement("NPage", null, false)) {
            return super.getNPage();
        }
        if (this.hasAttribute_KElement("Pages", null, false)) {
            JDFIntegerRangeList pages = this.getPages();
            int nPage = pages.getElementCount();
            return nPage;
        }
        List<KElement> v = this.getChildArray_KElement(this.getLocalName(), this.getNamespaceURI(), null, true, 0);
        if (v != null) {
            for (KElement e : v) {
                int page = ((JDFRunList)e).getNPage();
                if (page < 0) {
                    return -1;
                }
                n += page;
            }
        }
        return n <= 0 ? super.getNPage() : n;
    }

    public JDFRunList getIndexPartition(int index) {
        VElement leaves = this.getPageLeaves();
        for (int i = 0; i < leaves.size(); ++i) {
            JDFRunList rl = (JDFRunList)leaves.elementAt(i);
            if (rl.getFirstIndex() > index || rl.getLastIndex() < index) continue;
            return rl;
        }
        return null;
    }

    public int getPageInFile(int runIndex) {
        JDFRunData ri = new JDFRunData();
        ri.firstIndex = this.getFirstIndex();
        if (runIndex < ri.firstIndex) {
            return -1;
        }
        ri.lastIndex = this.getLastIndex();
        if (runIndex > ri.lastIndex) {
            return -1;
        }
        ri.runIndex = runIndex;
        ri.runList = this;
        return ri.getPageInFile();
    }

    @Override
    public void collapse(boolean bCollapseToNode, boolean bCollapseElements) {
        super.collapse(bCollapseToNode, bCollapseElements);
        this.fixNPage();
    }

    @Override
    public void expand(boolean bDeleteFromNode) {
        this.fixNPage();
        super.expand(bDeleteFromNode);
    }

    public void fixNPage() {
        List<JDFResource> v2;
        int siz = 0;
        VElement v = this.getPageLeaves();
        if (v != null) {
            siz = v.size();
            for (int i = 0; i < siz; ++i) {
                JDFRunList pageLeaf = (JDFRunList)v.elementAt(i);
                int page = pageLeaf.getNPage();
                if (page <= 0) continue;
                pageLeaf.setNPage(page);
            }
        }
        if ((v2 = this.getLeafArray(true)) != null) {
            siz = v2.size();
            for (int i = siz - 1; i >= 0; --i) {
                JDFRunList rl = (JDFRunList)v2.get(i);
                if (v != null && v.contains(rl)) {
                    v2.remove(rl);
                    continue;
                }
                rl.removeAttribute("NPage");
            }
        }
        if (v2 != null) {
            siz = v2.size();
            for (int i = siz - 1; i >= 0; --i) {
                JDFRunList rl = (JDFRunList)v2.get(i);
                int page = rl.getNPage();
                if (page <= 0) continue;
                rl.setNPage(page);
            }
        }
    }

    public JDFRunList getTruePage() {
        JDFRunList rl = this;
        while (true) {
            if (rl.getIsPage()) {
                return rl;
            }
            KElement parent = rl.getParentNode_KElement();
            if (!(parent instanceof JDFRunList)) break;
            rl = (JDFRunList)parent;
        }
        return null;
    }

    public boolean isPageLeaf() {
        if (!this.getIsPage()) {
            return false;
        }
        VElement v1 = new VElement();
        v1.addAll(this.getChildArray_KElement(this.getLocalName(), this.getNamespaceURI(), null, true, 0));
        VElement v = v1;
        if (v != null) {
            int siz = v.size();
            for (int i = 0; i < siz; ++i) {
                JDFRunList rl = (JDFRunList)v.elementAt(i);
                if (!rl.getIsPage()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public JDFIntegerRangeList getPages() {
        int nPage;
        JDFIntegerRangeList irl = super.getPages();
        if (irl == null) {
            irl = new JDFIntegerRangeList(new JDFIntegerRange(0, -1));
        }
        if ((nPage = this.getFileSpecNPage()) == 0) {
            nPage = super.getNPage();
        }
        if (nPage > 0) {
            irl.setDef(nPage);
        }
        return irl;
    }

    public int getFileSpecNPage() {
        JDFFileSpec fs = this.getFileSpec();
        return fs == null ? 0 : fs.getNPage();
    }

    @Override
    public JDFIntegerRangeList getPageListIndex() {
        JDFIntegerRangeList list = super.getPageListIndex();
        if (list == null) {
            list = new JDFIntegerRangeList();
        }
        JDFPageList pl = this.getPageList();
        int nPage = 0;
        if (pl != null) {
            nPage = pl.getNPage();
        }
        if (nPage <= 0) {
            nPage = this.getNPage();
        }
        list.setDef(nPage);
        return list;
    }

    static {
        JDFRunList.atrInfoTable[0] = new AtrInfoTable("DocCopies", 0x33333333L, AttributeInfo.EnumAttributeType.integer, null, "1");
    }

    private class PageIterator
    implements Iterator<JDFRunData> {
        private final JDFRunList rl;
        private int index;
        private final int maxIndex;
        private final JDFRunData[] vRunIndex;
        private int lastIndex = 0;

        public PageIterator(JDFRunList list) {
            this.rl = (JDFRunList)list.getResourceRoot();
            this.index = list.getFirstIndex();
            this.maxIndex = list.getLastIndex();
            VElement leaves = this.rl.getPageLeaves();
            this.vRunIndex = new JDFRunData[leaves.size()];
            JDFRunData last = null;
            for (int i = 0; i < leaves.size(); ++i) {
                JDFRunList _rl = (JDFRunList)leaves.elementAt(i);
                int firstIndex = _rl.getFirstIndex(last);
                int _lastIndex = firstIndex + _rl.getNPage() - 1;
                JDFRunData ri = new JDFRunData();
                ri.runList = _rl;
                ri.firstIndex = firstIndex;
                ri.lastIndex = _lastIndex;
                this.vRunIndex[i] = ri;
                last = ri;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index <= this.maxIndex;
        }

        @Override
        public JDFRunData next() {
            for (int i = this.lastIndex; i < this.vRunIndex.length; ++i) {
                JDFRunData ri = this.vRunIndex[i];
                if (ri.firstIndex > this.index || ri.lastIndex < this.index) continue;
                JDFRunData ri2 = new JDFRunData(ri);
                ri2.runIndex = this.index++;
                this.lastIndex = i;
                return ri2;
            }
            return null;
        }

        @Override
        public void remove() throws JDFException {
            throw new JDFException("remove not implented");
        }
    }

    public class JDFRunData {
        protected JDFRunList runList;
        protected int runIndex;
        protected int firstIndex;
        protected int lastIndex;

        public JDFRunData(JDFRunData other) {
            this.runList = other.runList;
            this.runIndex = other.runIndex;
            this.firstIndex = other.firstIndex;
            this.lastIndex = other.lastIndex;
        }

        protected JDFRunData() {
            this.runList = null;
            this.runIndex = 0;
            this.firstIndex = 0;
            this.lastIndex = 0;
        }

        public int getPageInFile() {
            int page = -1;
            int delta = this.runIndex - this.firstIndex;
            if (this.runList.hasAttribute("Pages")) {
                int[] pages = this.runList.getPages().getIntegerList().getIntArray();
                if (delta >= pages.length) {
                    throw new JDFException("getPageInFile: Pages is kaputt");
                }
                page = pages[delta];
            } else {
                page = this.runList.getFirstPage() + delta;
            }
            return page;
        }

        public int getLastIndex() {
            return this.lastIndex;
        }

        public int getRunIndex() {
            return this.runIndex;
        }

        public JDFRunList getRunList() {
            return this.runList;
        }

        public int getFirstIndex() {
            return this.firstIndex;
        }
    }
}

