/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.span;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.StringUtil;

public abstract class JDFSpanBase
extends JDFElement {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[2];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFSpanBase(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFSpanBase(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFSpanBase(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Deprecated
    public final String getValue() {
        return null;
    }

    public void setDataType(EnumDataType value) {
        this.setAttribute("DataType", value, null);
    }

    public EnumDataType getDataType() {
        return EnumDataType.getEnum(this.getAttribute("DataType", null, null));
    }

    public EnumPriority getPriority() {
        return EnumPriority.getEnum(this.getAttribute("Priority", null, null));
    }

    public void setPriority(EnumPriority p) {
        this.setAttribute("Priority", p, null);
    }

    @Deprecated
    public String getName() {
        return this.getNodeName();
    }

    public boolean preferredToActual() {
        boolean preferredExists;
        boolean bl = preferredExists = !this.hasAttribute("Actual") && this.hasAttribute("Preferred");
        if (preferredExists) {
            this.setAttribute("Actual", this.guessActual(), null);
        }
        return preferredExists;
    }

    public String guessActual() {
        String range;
        VString v;
        int n;
        if (this.hasAttribute("Actual")) {
            return this.getAttribute("Actual");
        }
        if (this.hasAttribute("Preferred")) {
            return this.getAttribute("Preferred");
        }
        if (this.hasAttribute("Range") && (n = (v = StringUtil.tokenize(range = this.getAttribute("Range"), "~ ", false)).size() / 2) > 0) {
            return v.get(n);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " -->" + super.toString() + " ]";
    }

    static {
        JDFSpanBase.atrInfoTable[0] = new AtrInfoTable("DataType", 0x22222222L, AttributeInfo.EnumAttributeType.enumeration, EnumDataType.getEnum(0), null);
        JDFSpanBase.atrInfoTable[1] = new AtrInfoTable("Priority", 0x44444433L, AttributeInfo.EnumAttributeType.enumeration, EnumPriority.getEnum(0), null);
    }

    public static class EnumDataType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumDataType DurationSpan = new EnumDataType("DurationSpan");
        public static final EnumDataType IntegerSpan = new EnumDataType("IntegerSpan");
        public static final EnumDataType NumberSpan = new EnumDataType("NumberSpan");
        public static final EnumDataType OptionSpan = new EnumDataType("OptionSpan");
        public static final EnumDataType NameSpan = new EnumDataType("NameSpan");
        public static final EnumDataType EnumerationSpan = new EnumDataType("EnumerationSpan");
        public static final EnumDataType ShapeSpan = new EnumDataType("ShapeSpan");
        public static final EnumDataType StringSpan = new EnumDataType("StringSpan");
        public static final EnumDataType TimeSpan = new EnumDataType("TimeSpan");
        public static final EnumDataType XYPairSpan = new EnumDataType("XYPairSpan");

        private EnumDataType(String name) {
            super(name, m_startValue++);
        }

        public static EnumDataType getEnum(String enumName) {
            return (EnumDataType)EnumDataType.getEnum(EnumDataType.class, enumName);
        }

        public static EnumDataType getEnum(int enumValue) {
            return (EnumDataType)EnumDataType.getEnum(EnumDataType.class, enumValue);
        }

        public static Map getEnumMap() {
            return EnumDataType.getEnumMap(EnumDataType.class);
        }

        public static List getEnumList() {
            return EnumDataType.getEnumList(EnumDataType.class);
        }

        public static Iterator iterator() {
            return EnumDataType.iterator(EnumDataType.class);
        }
    }

    public static class EnumPriority
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPriority None = new EnumPriority("None");
        public static final EnumPriority Suggested = new EnumPriority("Suggested");
        public static final EnumPriority Required = new EnumPriority("Required");

        protected EnumPriority(String name) {
            super(name, m_startValue++);
        }

        public static EnumPriority getEnum(String enumName) {
            return (EnumPriority)EnumPriority.getEnum(EnumPriority.class, enumName);
        }

        public static EnumPriority getEnum(int enumValue) {
            return (EnumPriority)EnumPriority.getEnum(EnumPriority.class, enumValue);
        }

        public static Map getEnumMap() {
            return EnumPriority.getEnumMap(EnumPriority.class);
        }

        public static List getEnumList() {
            return EnumPriority.getEnumList(EnumPriority.class);
        }

        public static Iterator iterator() {
            return EnumPriority.iterator(EnumPriority.class);
        }
    }
}

