/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StreamUtil;
import org.cip4.jdflib.util.thread.DelayedPersist;
import org.cip4.jdflib.util.thread.IPersistable;

public class ByteArrayIOFileStream
extends ByteArrayIOStream {
    private static final Log log = LogFactory.getLog(ByteArrayIOFileStream.class);
    private final long maxLength;
    private File file;
    private RandomAccessFile os;
    private boolean isTmpFile;
    private boolean isCopy;
    private boolean hasCopy;
    private final int id;
    private static AtomicInteger n = new AtomicInteger();

    public static ByteArrayIOStream.ByteArrayIOInputStream getBufferedInputStream(InputStream is, long maxLen) {
        if (is == null) {
            return null;
        }
        if (is instanceof ByteArrayIOStream.ByteArrayIOInputStream) {
            return ((ByteArrayIOStream.ByteArrayIOInputStream)is).getNewStream();
        }
        ByteArrayIOFileStream byteArrayIOStream = new ByteArrayIOFileStream(is, maxLen);
        ByteArrayIOStream.ByteArrayIOInputStream inputStream = ((ByteArrayIOStream)byteArrayIOStream).getInputStream();
        return inputStream;
    }

    public ByteArrayIOFileStream(long maxLength) {
        this.maxLength = maxLength;
        this.file = null;
        this.isTmpFile = false;
        this.os = null;
        this.id = n.incrementAndGet();
        this.isCopy = false;
        this.hasCopy = false;
    }

    public ByteArrayIOFileStream(InputStream is, long maxLength) {
        this(maxLength);
        this.setStream(is);
    }

    public ByteArrayIOFileStream(File f, long maxLength, boolean readOnly) {
        this(maxLength);
        if (f == null) {
            return;
        }
        this.file = f;
        if (f.length() > maxLength) {
            try {
                this.os = new RandomAccessFile(f, readOnly ? "r" : "rw");
            }
            catch (FileNotFoundException e) {
                log.error((Object)("cannot open file " + String.valueOf(f)), (Throwable)e);
            }
        } else {
            BufferedInputStream fis = FileUtil.getBufferedInputStream(f);
            this.setStream(fis);
            StreamUtil.close(fis);
        }
    }

    @Override
    public ByteArrayIOStream.ByteArrayIOInputStream getInputStream() {
        if (this.os != null) {
            ByteArrayIOFileInputStream byteArrayIOFileInputStream = new ByteArrayIOFileInputStream(this);
            byteArrayIOFileInputStream.seek(0L);
            return byteArrayIOFileInputStream;
        }
        return super.getInputStream();
    }

    @Override
    public synchronized void write(int b) {
        this.ensureStream((long)this.count + 1L);
        if (this.os != null) {
            try {
                this.os.write(b);
            }
            catch (IOException iOException) {}
        } else {
            super.write(b);
        }
    }

    private void ensureStream(long newSize) {
        if (newSize > this.maxLength && this.os == null) {
            if (this.file == null) {
                try {
                    this.isTmpFile = true;
                    this.file = File.createTempFile("ByteArray.", null);
                    log.info((Object)("ensuring " + this.id + " " + String.valueOf(this.file)));
                }
                catch (IOException e) {
                    log.error((Object)"Cannot create temp file ", (Throwable)e);
                }
            }
            try {
                this.os = new RandomAccessFile(this.file, "rw");
                this.os.write(this.buf, this.pos, this.count);
                this.buf = null;
                this.pos = this.count;
                this.count = 0;
            }
            catch (Exception e) {
                log.error((Object)("cannot create file " + this.id + " " + String.valueOf(this.file)));
            }
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.ensureStream((long)this.count + (long)len);
        if (this.os != null) {
            try {
                this.os.write(b, off, len);
            }
            catch (IOException iOException) {}
        } else {
            super.write(b, off, len);
        }
    }

    @Override
    public void close() {
        try {
            if (this.os != null && !this.isCopy) {
                log.info((Object)("closing random access temp file " + this.id + " " + String.valueOf(this.file)));
                this.os.close();
                this.os = null;
            }
            if (this.isTmpFile && this.file != null) {
                log.info((Object)("deleting temp file " + this.id + " " + String.valueOf(this.file)));
                this.file.delete();
                this.file = null;
                this.isTmpFile = false;
            }
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isCopy) {
            if (this.hasCopy) {
                DelayedPersist.getDelayedPersist().queue(new CloseRunner(), 123456L);
            } else {
                this.close();
            }
        }
        super.finalize();
    }

    @Override
    void setStream(InputStream is) {
        if (is instanceof ByteArrayIOFileInputStream) {
            ByteArrayIOFileInputStream bais = (ByteArrayIOFileInputStream)is;
            this.file = bais.ios.file;
            bais.ios.hasCopy = true;
            this.isTmpFile = false;
            this.isCopy = true;
            this.os = bais.ios.os;
            log.info((Object)("updating " + this.id + " " + String.valueOf(this.file) + " from " + bais.ios.id));
        } else if (is != null) {
            int avail = 0;
            try {
                int n = avail = is instanceof ByteArrayIOStream.ByteArrayIOInputStream ? 0 : is.available();
                if ((long)avail > this.maxLength) {
                    this.ensureStream(avail);
                    IOUtils.copy((InputStream)is, (OutputStream)this);
                } else {
                    super.setStream(is);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized int size() {
        if (this.os != null) {
            try {
                return (int)this.os.length();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.size();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public synchronized String toString() {
        return "ByteArrayIOFileStream [maxLength=" + this.maxLength + ", " + (String)(this.file != null ? "file=" + String.valueOf(this.file) + ", " : "") + "isTmpFile=" + this.isTmpFile + ", isCopy=" + this.isCopy + ", id=" + this.id + "]";
    }

    public class ByteArrayIOFileInputStream
    extends ByteArrayIOStream.ByteArrayIOInputStream {
        private final ByteArrayIOFileStream ios;
        private long filePos;
        private long fileMark;

        ByteArrayIOFileInputStream(ByteArrayIOFileStream ios) {
            super(new byte[1], 0);
            this.ios = ios;
            this.fileMark = 0L;
            try {
                this.filePos = ios.os.getFilePointer();
            }
            catch (IOException e) {
                this.filePos = 0L;
            }
        }

        @Override
        public ByteArrayIOStream.ByteArrayIOInputStream getNewStream() {
            ByteArrayIOFileInputStream byteArrayIOFileInputStream = new ByteArrayIOFileInputStream(this.ios);
            byteArrayIOFileInputStream.filePos = this.filePos;
            return byteArrayIOFileInputStream;
        }

        @Override
        public synchronized String toString() {
            return "ByteArrayIOFileInputStream: " + String.valueOf(this.ios);
        }

        @Override
        public long getCount() {
            try {
                return this.ios.os.length();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        @Override
        public void seek(long pos) {
            if (pos < 0L) {
                pos += this.getCount();
            }
            try {
                if (this.ios.os.getFilePointer() != pos) {
                    this.ios.os.seek(pos);
                    this.filePos = pos;
                }
            }
            catch (IOException e) {
                throw new JDFException(e.getMessage());
            }
        }

        @Override
        public long tell() {
            return this.filePos;
        }

        @Override
        public byte[] getBuf() {
            return null;
        }

        @Override
        public synchronized int read() {
            try {
                this.ios.os.seek(this.filePos);
                int read = this.ios.os.read();
                if (read >= 0) {
                    ++this.filePos;
                }
                return read;
            }
            catch (IOException e) {
                return -1;
            }
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) {
            try {
                this.seek(this.filePos);
                int read = this.ios.os.read(b, off, len);
                if (read > 0) {
                    this.filePos += (long)read;
                }
                return read;
            }
            catch (IOException e) {
                return 0;
            }
        }

        @Override
        public synchronized long skip(long n) {
            try {
                this.filePos += n;
                this.ios.os.seek(this.filePos);
                return this.filePos;
            }
            catch (IOException e) {
                return 0L;
            }
        }

        @Override
        public synchronized int available() {
            return (int)(this.getCount() - this.filePos);
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.fileMark = this.filePos;
        }

        @Override
        public synchronized void reset() {
            this.seek(this.fileMark);
        }

        @Override
        public void close() throws IOException {
        }

        public void closeAll() {
            this.ios.close();
        }
    }

    private class CloseRunner
    implements IPersistable {
        private CloseRunner() {
        }

        @Override
        public boolean persist() {
            ByteArrayIOFileStream.this.close();
            return true;
        }
    }
}

