/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ByteArrayIOFileStream;
import org.cip4.jdflib.util.FileUtil;

public class ByteArrayIOStream
extends ByteArrayOutputStream {
    private static final Log log = LogFactory.getLog(ByteArrayIOStream.class);
    int pos;

    public static ByteArrayIOInputStream getBufferedInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        if (is instanceof ByteArrayIOInputStream) {
            return ((ByteArrayIOInputStream)is).getNewStream();
        }
        ByteArrayIOStream byteArrayIOStream = new ByteArrayIOStream(is);
        ByteArrayIOInputStream inputStream = byteArrayIOStream.getInputStream();
        byteArrayIOStream.close();
        return inputStream;
    }

    public ByteArrayIOStream() {
        this.pos = 0;
    }

    public ByteArrayIOStream(int i) {
        super(i);
        this.pos = 0;
    }

    public ByteArrayIOStream(InputStream is) {
        super(1000);
        this.setStream(is);
    }

    void setStream(InputStream is) {
        if (is == null) {
            return;
        }
        if (is instanceof ByteArrayIOInputStream && !(is instanceof ByteArrayIOFileStream.ByteArrayIOFileInputStream)) {
            ByteArrayIOInputStream bis = (ByteArrayIOInputStream)is;
            this.buf = bis.getBuf();
            this.count = (int)bis.getCount();
            this.pos = (int)bis.tell();
        } else {
            try {
                int available = is.available();
                if (available > 1000) {
                    this.buf = new byte[available + 1000];
                }
                IOUtils.copy((InputStream)is, (OutputStream)this);
            }
            catch (IOException e) {
                log.error((Object)"error copying streams to buffer", (Throwable)e);
            }
        }
    }

    public ByteArrayIOStream(File f) throws IOException {
        super(10);
        if (f != null && f.length() > 10L) {
            this.buf = new byte[(int)f.length() + 100];
        }
        BufferedInputStream fis = FileUtil.getBufferedInputStream(f);
        this.setStream(fis);
    }

    public ByteArrayIOStream(byte[] b) {
        this.buf = b;
        this.count = b.length;
    }

    public ByteArrayIOInputStream getInputStream() {
        ByteArrayIOInputStream is = new ByteArrayIOInputStream(this.buf, this.pos, this.count);
        return is;
    }

    public ByteArrayIOInputStream getNewStream() {
        ByteArrayIOInputStream is = new ByteArrayIOInputStream(this.buf, 0, this.count);
        return is;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    @Override
    public synchronized String toString() {
        return "ByteArrayIOStream: " + this.count;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class ByteArrayIOInputStream
    extends ByteArrayInputStream {
        public void seek(long pos) {
            if (pos < 0L) {
                pos = (long)this.count + pos;
            }
            if (pos < 0L) {
                pos = 0L;
            }
            if (pos > (long)this.count) {
                pos = this.count;
            }
            this.pos = (int)pos;
        }

        public long tell() {
            return this.pos;
        }

        public ByteArrayIOInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        protected ByteArrayIOInputStream(byte[] buf, int count) {
            super(buf, 0, count);
        }

        protected ByteArrayIOInputStream(InputStream is) {
            super(new byte[1]);
            ByteArrayIOStream bos = new ByteArrayIOStream(is);
            this.buf = bos.getBuf();
            this.count = bos.count;
            bos.close();
        }

        public ByteArrayIOInputStream getNewStream() {
            return new ByteArrayIOInputStream(this.buf, this.pos, this.count);
        }

        public synchronized String toString() {
            return "ByteArrayIOInputStream: +count=" + this.count + " pos=" + this.pos + new String(this.buf, 0, this.count);
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public long getCount() {
            return this.count;
        }

        public String asString(int maxLen) {
            if (maxLen <= 0 || maxLen > this.count) {
                maxLen = this.count;
            }
            return new String(this.buf, 0, maxLen);
        }
    }
}

