/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.enums.EnumUtils;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.JavaEnumUtil;
import org.cip4.jdflib.util.StringUtil;

public class EnumUtil {
    private static final String NULL = "null";

    private EnumUtil() {
    }

    public static VString getNamesVector(Class<? extends ValuedEnum> e) {
        if (e == null) {
            return null;
        }
        VString namesVector = new VString();
        Iterator it = EnumUtils.iterator(e);
        while (it.hasNext()) {
            namesVector.addElement(((ValuedEnum)it.next()).getName());
        }
        return namesVector;
    }

    public static StringArray getNamesList(Class<? extends ValuedEnum> e) {
        if (e == null) {
            return null;
        }
        StringArray list = new StringArray();
        Iterator it = EnumUtils.iterator(e);
        while (it.hasNext()) {
            list.add(((ValuedEnum)it.next()).getName());
        }
        return list;
    }

    public static Vector<ValuedEnum> getEnumsVector(Class<? extends ValuedEnum> e) {
        Vector<ValuedEnum> v = new Vector<ValuedEnum>();
        Iterator it = EnumUtils.iterator(e);
        while (it.hasNext()) {
            v.addElement((ValuedEnum)it.next());
        }
        return v;
    }

    public static ValuedEnum min(ValuedEnum e1, ValuedEnum e2) {
        if (e1 == null || e2 == null) {
            return null;
        }
        return e1.getValue() < e2.getValue() ? e1 : e2;
    }

    public static ValuedEnum max(ValuedEnum e1, ValuedEnum e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        return e1.getValue() > e2.getValue() ? e1 : e2;
    }

    public static String getName(ValuedEnum en) {
        return en == null ? NULL : en.getName();
    }

    public static String getEnumName(ValuedEnum en) {
        return en == null ? null : StringUtil.token(en.getClass().getName(), -1, "$");
    }

    public static boolean aLessThanB(ValuedEnum a, ValuedEnum b) {
        int bb;
        int aa = EnumUtil.getValue(a);
        return aa < (bb = EnumUtil.getValue(b));
    }

    public static int getValue(ValuedEnum a) {
        return a == null ? -1 : a.getValue();
    }

    public static boolean aLessEqualsThanB(ValuedEnum a, ValuedEnum b) {
        int bb;
        int aa = EnumUtil.getValue(a);
        return aa <= (bb = EnumUtil.getValue(b));
    }

    public static ValuedEnum getEnumIgnoreCase(Class<? extends ValuedEnum> clazz, Enum<?> e) {
        String s = e == null ? null : e.name();
        return EnumUtil.getEnumIgnoreCase(clazz, s);
    }

    public static <T extends Enum<T>> T getEnum(Class<T> c, ValuedEnum val) {
        return JavaEnumUtil.getEnumIgnoreCase(c, EnumUtil.getName(val));
    }

    public static ValuedEnum getEnumIgnoreCase(Class<? extends ValuedEnum> clazz, String s) {
        if (!StringUtil.isEmpty(s) && clazz != null) {
            Iterator it = EnumUtils.iterator(clazz);
            while (it.hasNext()) {
                ValuedEnum next = (ValuedEnum)it.next();
                if (!s.equalsIgnoreCase(next.getName())) continue;
                return (ValuedEnum)EnumUtils.getEnum(clazz, next.getName());
            }
        }
        return null;
    }

    public static <T extends Enum<T>> T getJavaEnumIgnoreCase(Class<T> c, String val) {
        return JavaEnumUtil.getEnumIgnoreCase(c, val, null);
    }

    public static <T extends Enum<T>> T getJavaEnum(ValuedEnum val) {
        Class c = EnumUtil.getJavaEnumClass(val);
        return c == null ? null : (T)JavaEnumUtil.getEnumIgnoreCase(c, EnumUtil.getName(val));
    }

    public static <J extends Enum<J>> Class<J> getJavaEnumClass(ValuedEnum val) {
        if (val == null) {
            return null;
        }
        String name = val.getClass().getName();
        String simple = StringUtil.token(name, -1, ".$");
        String newsimple = "E" + StringUtil.rightStr(simple, -4);
        String newname = StringUtil.replaceToken(name, -1, ".$", newsimple);
        try {
            return Class.forName(newname);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T extends ValuedEnum, E extends Enum<E>> T getOldEnum(E val) {
        Class c = EnumUtil.getOldEnumClass(val);
        return (T)(c == null ? null : EnumUtil.getEnumIgnoreCase(c, JavaEnumUtil.getName(val)));
    }

    public static <O extends ValuedEnum, E extends Enum<E>> Class<O> getOldEnumClass(Enum<E> oldEnum) {
        if (oldEnum == null) {
            return null;
        }
        String name = oldEnum.getClass().getName();
        String simpleClass = StringUtil.token(name, -1, ".$");
        String newsimple = "Enum" + StringUtil.rightStr(simpleClass, -1);
        String newname = StringUtil.replaceToken(name, -1, ".$", newsimple);
        try {
            return Class.forName(newname);
        }
        catch (ClassNotFoundException x) {
            return null;
        }
    }
}

