/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.AttributeReplacer;
import org.cip4.jdflib.node.JDFAncestor;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.JDFSpawned;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.pool.JDFAncestorPool;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.PartitionGetter;
import org.cip4.jdflib.resource.process.JDFIdentical;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFSpawn {
    private JDFNode node;
    private JDFNode rootOut;
    private JDFNode informativeRoot;
    private final Map<JDFNode, HashSet<String>> mapAllRefs;
    private final Map<JDFResource, VString> mapRefs;
    private final Set<String> noIdentical;
    private final Set<String> hasIdentical;
    private final Set<String> isReduced;
    private final Map<String, KElement> mapResources;
    private boolean idCacheFilled;
    private static final Log log = LogFactory.getLog(JDFSpawn.class);
    public boolean bSpawnROPartsOnly = true;
    public boolean bSpawnRWPartsMultiple = false;
    public boolean bCopyNodeInfo = true;
    public boolean bSpawnIdentical = true;
    public boolean bCopyCustomerInfo = true;
    public boolean bCopyComments = true;
    public boolean bFixResources = true;
    public String parentURL = null;
    public String spawnURL = null;
    public VString vRWResources_in = null;
    public VJDFAttributeMap vSpawnParts = null;
    private VString vROSpawnParts;
    private final Set<JDFAttributeMap> setSpawnParts;
    private boolean bInformative = false;
    public static final int exAlreadyMerged = 10001;
    public static final int exMultiSpawnRW = 10002;
    static final String ro = JDFResource.EnumSpawnStatus.SpawnedRO.getName();

    public VString getvROSpawnParts() {
        return this.vROSpawnParts;
    }

    public void setvROSpawnParts(VString vROSpawnParts) {
        this.vROSpawnParts = vROSpawnParts;
        this.bSpawnROPartsOnly = !VString.isEmpty(vROSpawnParts);
    }

    public JDFSpawn(JDFNode nodeToSpawn) {
        this.node = nodeToSpawn;
        this.informativeRoot = null;
        this.mapRefs = new HashMap<JDFResource, VString>();
        this.mapAllRefs = new HashMap<JDFNode, HashSet<String>>();
        this.mapResources = new HashMap<String, KElement>();
        this.noIdentical = new HashSet<String>();
        this.isReduced = new HashSet<String>();
        this.hasIdentical = new HashSet<String>();
        this.idCacheFilled = false;
        this.setSpawnParts = new HashSet<JDFAttributeMap>();
    }

    public void setNode(JDFNode newNode) {
        if (!newNode.getOwnerDocument().equals(this.node.getOwnerDocument())) {
            throw new JDFException("Setting illegal node in spawn");
        }
        if (this.node != newNode) {
            this.idCacheFilled = false;
        }
        this.node = newNode;
    }

    public JDFNode spawn() {
        VString vRWResources = this.vRWResources_in == null ? new VString() : this.vRWResources_in;
        this.isReduced.clear();
        if (!this.bSpawnRWPartsMultiple) {
            this.checkMultipleRWRes();
        }
        this.prepareNodeInfos();
        this.rootOut = (JDFNode)this.node.cloneNewDoc();
        String spawnID = "Sp" + KElement.uniqueID(0);
        this.rootOut.setSpawnID(spawnID);
        this.rootOut.setVersion(this.node.getVersion(true));
        String nodeInfoNonAncestor = "NodeInfo:Input";
        if (!vRWResources.contains("NodeInfo:Input")) {
            vRWResources.addElement("NodeInfo:Input");
        }
        JDFNode spawnParentNode = null;
        if (!VJDFAttributeMap.isEmpty(this.vSpawnParts)) {
            VJDFAttributeMap preSpawnedParts;
            spawnParentNode = this.node;
            this.rootOut.removeChild("AuditPool", null, 0);
            this.rootOut.appendAuditPool();
            JDFAncestorPool ancpool = this.rootOut.getAncestorPool();
            VJDFAttributeMap vJDFAttributeMap = preSpawnedParts = ancpool == null ? null : ancpool.getPartMapVector();
            if (!VJDFAttributeMap.isEmpty(preSpawnedParts)) {
                this.vSpawnParts.overlapMap(preSpawnedParts);
            }
            if (this.vSpawnParts.isEmpty()) {
                throw new JDFException("JDFNode.Spawn attempting to spawn incompatible partitions");
            }
            this.setSpawnParts.addAll(this.vSpawnParts);
        } else {
            spawnParentNode = this.node.getParentJDF();
            if (spawnParentNode == null) {
                log.error((Object)"JDFNode.Spawn cannot spawn unpartitioned root node");
                throw new JDFException("JDFNode.Spawn cannot spawn unpartitioned root node");
            }
        }
        this.setSpawnParent(spawnParentNode);
        JDFSpawned spawnAudit = this.createSpawnAudit(spawnID, spawnParentNode);
        this.addSpawnedResources(spawnAudit);
        this.finalizeSpawn(spawnAudit);
        return this.rootOut;
    }

    private void prepareNodeInfos() {
        if (this.vSpawnParts == null) {
            return;
        }
        VElement vn = this.node.getvJDFNode(null, null, false);
        for (KElement e : vn) {
            JDFNode node = (JDFNode)e;
            node.prepareNodeInfo(this.vSpawnParts);
        }
    }

    private void checkMultipleRWRes() {
        Collection<JDFResource> vCheck = this.checkSpawnedResources();
        if (vCheck != null) {
            Object strIDs = "JDFNode.spawn: multiply spawned rw resources: ";
            VString vBad = new VString();
            for (JDFResource check : vCheck) {
                vBad.appendUnique(check.getID());
            }
            strIDs = (String)strIDs + StringUtil.setvString(vBad, " ", null, null);
            log.error(strIDs);
            throw new JDFException((String)strIDs, 10002);
        }
    }

    public Collection<JDFResource> cleanSpawnedResources() {
        Collection<JDFResource> multi = this.checkSpawnedResources();
        if (multi != null) {
            for (JDFResource r : multi) {
                r.removeInheritedAttributes("SpawnIDs", null);
                r.removeInheritedAttributes("SpawnStatus", null);
            }
        }
        return multi;
    }

    public Collection<JDFResource> checkSpawnedResources() {
        VString vRWResources = new VString(this.vRWResources_in);
        LinkedHashSet<JDFResource> vMultiRes = new LinkedHashSet<JDFResource>();
        if (!this.idCacheFilled) {
            this.node.getOwnerDocument_JDFElement().getCreateXMLDocUserData().fillIDCache();
            this.idCacheFilled = true;
        }
        HashSet<JDFElement> vRootLinks = this.node.getAllRefs(null, true);
        for (JDFElement e : vRootLinks) {
            this.checkSpawnedResource(vRWResources, vMultiRes, e);
        }
        return vMultiRes.isEmpty() ? null : vMultiRes;
    }

    void checkSpawnedResource(VString vRWResources, HashSet<JDFResource> vMultiRes, JDFElement liRoot) {
        JDFRefElement re;
        JDFResource r = null;
        boolean bResRW = false;
        if (liRoot instanceof JDFResourceLink) {
            bResRW = this.linkFitsRWRes((JDFResourceLink)liRoot, vRWResources);
            if (bResRW) {
                JDFResourceLink rl = (JDFResourceLink)liRoot;
                r = rl.getTarget();
            }
        } else if (liRoot instanceof JDFRefElement && (r = (re = (JDFRefElement)liRoot).getTarget()) != null) {
            bResRW = this.resFitsRWRes(r, vRWResources);
        }
        this.fillMultiRes(vMultiRes, r, bResRW);
    }

    void fillMultiRes(HashSet<JDFResource> vMultiRes, JDFResource r, boolean bResRW) {
        if (bResRW && r != null) {
            List<JDFResource> vRes = this.getSpawnLeaves(r);
            VString partIDKeys = r.getPartIDKeys();
            for (KElement kElement : vRes) {
                JDFResource rTarget = (JDFResource)kElement;
                if (!JDFResource.EnumSpawnStatus.SpawnedRW.equals(rTarget.getSpawnStatus()) || vMultiRes.contains(rTarget) || this.vSpawnParts != null && !this.vSpawnParts.overlapsMap(rTarget.getPartMap(partIDKeys))) continue;
                vMultiRes.add(rTarget);
            }
        }
    }

    List<JDFResource> getSpawnLeaves(JDFResource r) {
        ArrayList<JDFResource> vRes = new ArrayList();
        if (this.vSpawnParts == null || this.vSpawnParts.isEmpty()) {
            vRes = r.getLeafArray(false);
        } else {
            VElement partitionVector = r.getPartitionVector(this.vSpawnParts, null);
            if (ContainerUtil.isEmpty(partitionVector)) {
                partitionVector = r.getPartitionVector(this.vSpawnParts, JDFResource.EnumPartUsage.Implicit);
            }
            if (partitionVector != null) {
                for (KElement e : partitionVector) {
                    JDFResource rPart = (JDFResource)e;
                    vRes.addAll(rPart.getLeafArray(false));
                }
                ContainerUtil.unify(vRes);
            }
        }
        return vRes;
    }

    private VElement prepareSpawnLinks(JDFNode node) {
        VElement vn = node.getvJDFNode(null, null, false);
        int size = vn.size();
        VElement outLinks = new VElement();
        for (int i = 0; i < size; ++i) {
            JDFNode vnNode_i = (JDFNode)vn.elementAt(i);
            outLinks.addAll(vnNode_i.getResourceLinks(null));
        }
        outLinks.unify();
        return outLinks;
    }

    private void setSpawnParent(JDFNode parent) {
        VString vs = parent.getAncestorIDs();
        JDFAncestorPool ancestorPool = parent.getJDFRoot().getAncestorPool();
        String lastAncestorID = "";
        if (!parent.equals(this.node)) {
            int numAncestors;
            this.rootOut.removeChild("AncestorPool", null, 0);
            if (parent.getJDFRoot().hasChildElement("AncestorPool", null) && (numAncestors = (ancestorPool = (JDFAncestorPool)this.rootOut.copyElement(ancestorPool, null)).numChildElements("Ancestor", null)) > 0) {
                lastAncestorID = ancestorPool.getAncestor(numAncestors - 1).getNodeID();
            }
        }
        ancestorPool = this.rootOut.getCreateAncestorPool();
        ancestorPool.setPartMapVector(this.vSpawnParts);
        int startAncestorLoop = 0;
        if (!vs.isEmpty() && vs.elementAt(0).equals(lastAncestorID)) {
            startAncestorLoop = 1;
        }
        for (int i = startAncestorLoop; i < vs.size(); ++i) {
            JDFAncestor ancestor = ancestorPool.appendAncestor();
            ancestor.setNodeID(vs.elementAt(i));
            if (i != 0 || this.parentURL == null || this.parentURL.equals("")) continue;
            ancestor.setFileName(this.parentURL);
        }
        this.rootOut.setJobID(parent.getJobID(true));
        ancestorPool.copyNodeData(parent, this.bCopyNodeInfo, this.bCopyCustomerInfo, this.bCopyComments);
    }

    private JDFSpawned createSpawnAudit(String spawnID, JDFNode spawnParentNode) {
        JDFAuditPool p = spawnParentNode.getCreateAuditPool();
        JDFSpawned spawnAudit = p.addSpawned(this.rootOut, null, null, null, null);
        if (this.spawnURL != null && !this.spawnURL.equals("")) {
            if (this.spawnURL.indexOf("://") == -1) {
                spawnAudit.setURL("file://" + this.spawnURL);
            } else {
                spawnAudit.setURL(this.spawnURL);
            }
        }
        spawnAudit.setNewSpawnID(spawnID);
        return spawnAudit;
    }

    private int addSpawnedResources(JDFSpawned spawnAudit) {
        VString vRWResources = new VString(this.vRWResources_in);
        int nSpawned = 0;
        JDFResourcePool rPoolOut = this.rootOut.getCreateResourcePool();
        JDFAncestorPool ap = this.rootOut.getAncestorPool();
        if (ap != null) {
            ap = (JDFAncestorPool)this.node.copyElement(ap, null);
        }
        if (!this.idCacheFilled) {
            this.node.getOwnerDocument_JDFElement().getCreateXMLDocUserData().fillIDCache();
            this.idCacheFilled = true;
        }
        HashSet<JDFElement> vMainLinks = this.node.getAllRefs(null, false);
        HashSet<String> allIDsCopied = this.getAllIdsCopied();
        String spawnID = spawnAudit.getNewSpawnID();
        for (int loopRORW = 0; loopRORW < 2; ++loopRORW) {
            nSpawned = this.singleLoop(spawnAudit, vRWResources, nSpawned, rPoolOut, vMainLinks, allIDsCopied, spawnID, loopRORW);
        }
        if (ap != null) {
            ap.deleteNode();
        }
        return nSpawned;
    }

    int singleLoop(JDFSpawned spawnAudit, VString vRWResources, int nSpawned, JDFResourcePool rPoolOut, HashSet<JDFElement> vMainLinks, HashSet<String> allIDsCopied, String spawnID, int loopRORW) {
        for (JDFElement liRoot : vMainLinks) {
            boolean bRealyRW;
            if (liRoot.getDeepParent("ResourcePool", 0) != null) continue;
            String refID = liRoot.getAttribute("rRef");
            boolean bResRW = false;
            JDFResource rRoot = null;
            JDFResourceLink resLink = null;
            VJDFAttributeMap vLinkMap = null;
            if (liRoot instanceof JDFResourceLink) {
                resLink = (JDFResourceLink)liRoot;
                bResRW = this.linkFitsRWRes(resLink, vRWResources);
                vLinkMap = resLink.getPartMapVector();
            } else if (liRoot instanceof JDFRefElement) {
                rRoot = this.getNodeResource(refID);
                bResRW = this.resFitsRWRes(rRoot, vRWResources);
            }
            if (bResRW != (loopRORW != 0)) continue;
            boolean isThereAlready = allIDsCopied.contains(refID);
            JDFResource.EnumSpawnStatus copyStatus = bResRW ? JDFResource.EnumSpawnStatus.SpawnedRW : JDFResource.EnumSpawnStatus.SpawnedRO;
            LinkedHashSet<String> vvRO = new LinkedHashSet<String>();
            LinkedHashSet<String> vvRW = new LinkedHashSet<String>();
            if (rRoot == null) {
                rRoot = this.getNodeResource(refID);
            }
            if (rRoot == null) continue;
            this.copySpawnedResource(rPoolOut, rRoot, copyStatus, spawnID, vRWResources, vvRW, vvRO, allIDsCopied, vLinkMap);
            nSpawned += vvRO.size() + vvRW.size();
            VElement vRes = new VElement();
            VElement vResRoot = new VElement();
            if (resLink != null) {
                JDFResource r0;
                dummy = (JDFResourceLink)this.rootOut.getCreateResourceLinkPool().copyElement(liRoot, null);
                this.fixResLinks(bResRW, resLink, (JDFResourceLink)dummy);
                VJDFAttributeMap mainMap = resLink.getPartMapVector();
                mainMap = VJDFAttributeMap.isEmpty(mainMap) ? this.vSpawnParts : mainMap.getOrMaps(this.vSpawnParts);
                resLink.setPartMapVector(mainMap);
                ((JDFResourceLink)dummy).setPartMapVector(mainMap);
                ContainerUtil.addAll(vResRoot, ((JDFResourceLink)liRoot).getTargetVector(-1));
                ContainerUtil.addAll(vRes, ((JDFResourceLink)dummy).getTargetVector(-1));
                if (vRes.isEmpty() && (r0 = ((JDFResourceLink)dummy).getTarget()) != null) {
                    vRes.add(r0);
                }
                dummy.deleteNode();
                this.reduceLinkPartAmounts(resLink, vLinkMap);
            } else if (liRoot instanceof JDFRefElement) {
                vResRoot.add(((JDFRefElement)liRoot).getTarget());
                dummy = (JDFRefElement)this.rootOut.copyElement(liRoot, null);
                vRes.add(((JDFRefElement)dummy).getTarget());
                dummy.deleteNode();
            } else {
                log.error((Object)("we have a link that is neither ref nor link. Whazzup? " + String.valueOf(liRoot) == null ? " null" : liRoot.getNodeName()));
                continue;
            }
            this.addIdentical(vResRoot);
            this.addIdentical(vRes);
            int siz = vRes.size() < vResRoot.size() ? vRes.size() : vResRoot.size();
            boolean bl = bRealyRW = this.vSpawnParts == null || this.vSpawnParts.size() == 0;
            if (!bRealyRW && siz > 0 && (bResRW || this.bSpawnROPartsOnly)) {
                JDFResource copyRoot = ((JDFResource)vRes.elementAt(0)).getResourceRoot();
                this.reducePartitions(copyRoot, bResRW);
            } else {
                this.isReduced.add(rRoot.getID());
            }
            for (int resParts = 0; resParts < siz; ++resParts) {
                JDFResource r = (JDFResource)vRes.elementAt(resParts);
                try {
                    if (resParts == 0 && spawnID.equals(r.getAttribute("SpawnID"))) {
                        break;
                    }
                }
                catch (Exception x) {
                    log.error((Object)("snafu spawning " + String.valueOf(liRoot)), (Throwable)x);
                }
                JDFResource rRoot1 = (JDFResource)vResRoot.elementAt(resParts);
                PartSpawn partSpawner = new PartSpawn();
                if (!this.bInformative) {
                    partSpawner.spawnPart(rRoot1, spawnID, copyStatus, true, this.bSpawnROPartsOnly, vLinkMap);
                }
                partSpawner.spawnPart(r, spawnID, copyStatus, false, this.bSpawnROPartsOnly, vLinkMap);
                if (resParts != 0 || this.vSpawnParts == null || this.vSpawnParts.size() == 0 || !bResRW && !this.bSpawnROPartsOnly || !JDFResource.EnumSpawnStatus.SpawnedRW.equals(rRoot1.getSpawnStatus())) continue;
                bRealyRW = true;
            }
            if (!bRealyRW && JDFResource.EnumSpawnStatus.SpawnedRO.equals(copyStatus)) {
                bResRW = false;
                if (!vvRO.contains(rRoot.getID()) && !vvRW.contains(rRoot.getID())) {
                    vvRO.add(rRoot.getID());
                }
            }
            if (isThereAlready && bResRW) {
                vvRW.add(rRoot.getID());
            }
            this.calcAuditSpawnIDs(spawnAudit, vvRO, vvRW);
        }
        return nSpawned;
    }

    protected void calcAuditSpawnIDs(JDFSpawned spawnAudit, HashSet<String> vvRO, HashSet<String> vvRW) {
        VString rRefsRW = spawnAudit.getrRefsRWCopied();
        VString rRefsRO = spawnAudit.getrRefsROCopied();
        for (String s : vvRW) {
            rRefsRW.add(s);
            int ind = rRefsRO.index(s);
            if (ind < 0) continue;
            rRefsRO.remove(ind);
        }
        for (String s : vvRO) {
            rRefsRO.add(s);
        }
        rRefsRO.unify();
        rRefsRW.unify();
        if (rRefsRO.isEmpty()) {
            rRefsRO = null;
        }
        if (rRefsRW.isEmpty()) {
            rRefsRW = null;
        }
        spawnAudit.setrRefsROCopied(rRefsRO);
        spawnAudit.setrRefsRWCopied(rRefsRW);
    }

    private HashSet<String> getAllIdsCopied() {
        HashSet<String> allIDsCopied = this.mapAllRefs.get(this.node);
        if (allIDsCopied == null) {
            allIDsCopied = this.rootOut.fillHashSet("ID", null);
            this.mapAllRefs.put(this.node, allIDsCopied);
        }
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(allIDsCopied);
        return hs;
    }

    private JDFResource getNodeResource(String refID) {
        KElement rRoot = this.mapResources.get(refID);
        if (rRoot == null) {
            rRoot = this.node.getJDFRoot().getTarget(refID, "ID");
            this.mapResources.put(refID, rRoot);
        }
        if (!(rRoot instanceof JDFResource)) {
            rRoot = null;
        }
        return (JDFResource)rRoot;
    }

    private void addIdentical(VElement vRes) {
        if (!this.bSpawnIdentical || ContainerUtil.isEmpty(vRes) || VJDFAttributeMap.isEmpty(this.vSpawnParts) || vRes.get(0) == null) {
            return;
        }
        JDFResource jdfResource = (JDFResource)vRes.get(0);
        JDFResource resRoot = jdfResource.getResourceRoot();
        String id = resRoot.getID();
        if (this.noIdentical.contains(id)) {
            return;
        }
        List<JDFIdentical> identicals = resRoot.getChildArrayByClass(JDFIdentical.class, true, -1);
        if (ContainerUtil.isEmpty(identicals)) {
            this.noIdentical.add(id);
            return;
        }
        this.hasIdentical.add(id);
        for (JDFIdentical ident : identicals) {
            JDFResource identParent = (JDFResource)ident.getParentNode_KElement();
            JDFAttributeMap identMap = identParent.getPartMap();
            for (JDFAttributeMap mapPart : this.vSpawnParts) {
                if (!mapPart.subMap(identMap)) continue;
                vRes.add(identParent);
            }
        }
    }

    private void fixResLinks(boolean bResRW, JDFResourceLink liRootLink, JDFResourceLink dummy) {
        if (this.bFixResources && !VJDFAttributeMap.isEmpty(this.vSpawnParts) && bResRW) {
            JDFResource dummyRoot;
            VString rootPartIDKeys = this.rootOut.getJDFRoot().getPartIDKeys(this.vSpawnParts.elementAt(0));
            JDFResource linkRoot = liRootLink.getTarget();
            if (linkRoot != null) {
                try {
                    linkRoot.createPartitions(this.vSpawnParts, rootPartIDKeys);
                }
                catch (JDFException x) {
                    for (int i = 0; i < this.vSpawnParts.size(); ++i) {
                        this.fixSpawnPartitions(linkRoot.getPartition(this.vSpawnParts.elementAt(i), null), rootPartIDKeys);
                    }
                }
            }
            if ((dummyRoot = dummy.getTarget()) != null) {
                try {
                    dummyRoot.createPartitions(this.vSpawnParts, rootPartIDKeys);
                }
                catch (JDFException x) {
                    for (int i = 0; i < this.vSpawnParts.size(); ++i) {
                        this.fixSpawnPartitions(dummyRoot.getPartition(this.vSpawnParts.elementAt(i), null), rootPartIDKeys);
                    }
                }
            }
        }
    }

    private void finalizeSpawn(JDFSpawned spawnAudit) {
        VElement outLinks = this.prepareSpawnLinks(this.rootOut);
        VElement mainLinks = this.prepareSpawnLinks(this.node);
        if (!VJDFAttributeMap.isEmpty(this.vSpawnParts)) {
            this.finalizePartitions(spawnAudit, outLinks, mainLinks);
        }
        VString rw = spawnAudit.getrRefsRWCopied();
        this.removeRO(outLinks, spawnAudit.getNewSpawnID(), rw);
        this.removeRO(mainLinks, spawnAudit.getNewSpawnID(), rw);
        this.finalizeStatusAndAudits(spawnAudit);
    }

    private void removeRO(VElement outLinks, String spawnID, VString rw) {
        for (KElement e : outLinks) {
            JDFResourceLink rl = (JDFResourceLink)e;
            JDFResource linkRoot = rl.getLinkRoot();
            if (linkRoot == null) continue;
            List<JDFResource> v = linkRoot.getLeafArray(true);
            for (KElement kElement : v) {
                this.removeROFromLeaf(spawnID, rw, kElement);
            }
        }
    }

    void removeROFromLeaf(String spawnID, VString rw, KElement r) {
        if (ro.equals(r.getAttribute_KElement("SpawnStatus"))) {
            r.removeAttribute_KElement("SpawnStatus", null);
            r.removeFromAttribute("SpawnIDs", spawnID, null, null, 0);
        } else if (!rw.contains(r.getID()) && r.hasNonEmpty_KElement("SpawnIDs")) {
            r.removeFromAttribute("SpawnIDs", spawnID, null, null, 0);
            if (!r.hasNonEmpty_KElement("SpawnIDs")) {
                r.removeAttribute_KElement("SpawnStatus", null);
            }
        }
        if (r instanceof JDFElement) {
            this.removeROFromElement(spawnID, rw, r);
        }
    }

    void removeROFromElement(String spawnID, VString rw, KElement r) {
        List<JDFRefElement> refs = r.getChildArrayByClass_KElement(JDFRefElement.class, false, 0);
        if (refs != null) {
            for (KElement kElement : refs) {
                JDFResource targetRoot = ((JDFRefElement)kElement).getTarget();
                List<JDFResource> vT = targetRoot == null ? null : targetRoot.getLeafArray(true);
                if (vT == null) continue;
                for (KElement kElement2 : vT) {
                    if (ro.equals(kElement2.getAttribute_KElement("SpawnStatus"))) {
                        kElement2.removeFromAttribute("SpawnIDs", spawnID, null, null, 0);
                        kElement2.removeAttribute_KElement("SpawnStatus", null);
                        continue;
                    }
                    if (rw.contains(r.getID())) continue;
                    kElement2.removeFromAttribute("SpawnIDs", spawnID, null, null, 0);
                    if (kElement2.hasNonEmpty_KElement("SpawnIDs")) continue;
                    kElement2.removeAttribute_KElement("SpawnStatus", null);
                }
            }
        }
    }

    private void finalizePartitions(JDFSpawned spawnAudit, VElement outLinks, VElement mainLinks) {
        int outLinkSize = outLinks.size();
        String spawnID = spawnAudit.getNewSpawnID();
        for (int i = 0; i < outLinkSize; ++i) {
            JDFResourceLink link = (JDFResourceLink)outLinks.elementAt(i);
            JDFResource r = link.getTarget();
            if (r != null) {
                VJDFAttributeMap vPartMap = this.getSpawnLinkMap(this.vSpawnParts, r);
                VJDFAttributeMap vNewMap = this.getSpawnedLinkPartMap(link, vPartMap);
                this.reduceLinkPartAmounts(link, vNewMap);
                this.updateSpawnIDs(spawnID, link);
                String id = link.getrRef();
                link = (JDFResourceLink)mainLinks.elementAt(i);
                if (id.equals(link.getrRef())) {
                    this.updateSpawnIDsInMain(spawnID, link, vPartMap);
                    continue;
                }
                for (KElement e : mainLinks) {
                    link = (JDFResourceLink)e;
                    if (!id.equals(link.getrRef())) continue;
                    this.updateSpawnIDsInMain(spawnID, link, vPartMap);
                }
                continue;
            }
            log.warn((Object)("invalid link id=" + link.getrRef() + " Skipping " + this.rootOut.getJobID(true)));
        }
    }

    private void reduceLinkPartAmounts(JDFResourceLink link, VJDFAttributeMap vNewMap) {
        VElement partAmounts;
        if (!(this.linkFitsRWRes(link, this.vRWResources_in) || VString.isEmpty(this.vROSpawnParts) || VJDFAttributeMap.isEmpty(vNewMap))) {
            vNewMap = vNewMap.clone();
            VString pik = this.getPartIDKeys(link.getLinkRoot(), false);
            vNewMap.reduceMap(pik);
        }
        link.setPartMapVector(vNewMap);
        JDFAmountPool ap = link.getAmountPool();
        VElement vElement = partAmounts = ap == null ? null : ap.getChildElementVector("PartAmount", null);
        if (partAmounts != null) {
            for (KElement e : partAmounts) {
                JDFPartAmount pa = (JDFPartAmount)e;
                VJDFAttributeMap paVector = pa.getPartMapVector();
                if (paVector == null || paVector.overlapsMap(vNewMap)) continue;
                pa.deleteNode();
            }
        }
    }

    void updateSpawnIDsInMain(String spawnID, JDFResourceLink link, VJDFAttributeMap vPartMap) {
        VElement vMainPart;
        JDFResource rMain = link.getTarget();
        if (rMain == null) {
            rMain = link.getLinkRoot();
        }
        if (rMain == null) {
            rMain = this.getNodeResource(link.getrRef());
            if (rMain == null) {
                log.error((Object)("cannot find main resource for: " + link.getNodeName() + " " + link.getrRef()));
                return;
            }
            JDFNode parentNode = link.getParentJDF();
            parentNode.ensureValidRefsPosition(rMain);
        }
        if (ContainerUtil.isEmpty(vMainPart = rMain.getPartitionVector(vPartMap, null))) {
            vMainPart = new VElement();
            vMainPart.add(rMain);
        }
        this.updateSpawnIDsinMainParts(spawnID, vPartMap, vMainPart);
    }

    void updateSpawnIDsinMainParts(String spawnID, VJDFAttributeMap vPartMap, VElement vMainPart) {
        for (KElement e : vMainPart) {
            KElement ee;
            JDFResource rMainLeaf;
            JDFResource rMainPart = (JDFResource)e;
            if (rMainPart == null) continue;
            List<JDFResource> leaves = rMainPart.getLeafArray(true);
            boolean bSpawnID = false;
            Iterator<JDFResource> iterator = leaves.iterator();
            while (iterator.hasNext() && !(bSpawnID = (rMainLeaf = (JDFResource)(ee = (KElement)iterator.next())).includesMatchingAttribute("SpawnIDs", spawnID, AttributeInfo.EnumAttributeType.NMTOKENS))) {
            }
            if (bSpawnID = bSpawnID || !this.bSpawnIdentical && vPartMap != null && !vPartMap.subMap(rMainPart.getPartMap())) continue;
            rMainPart.appendSpawnIDs(spawnID);
            rMainPart.setLocked(true);
            rMainPart.setSpawnStatus(JDFResource.EnumSpawnStatus.SpawnedRW);
        }
    }

    private VJDFAttributeMap getSpawnedLinkPartMap(JDFResourceLink link, VJDFAttributeMap vPartMap) {
        VJDFAttributeMap vLinkMap = link.getPartMapVector();
        VJDFAttributeMap vNewMap = new VJDFAttributeMap();
        if (VJDFAttributeMap.isEmpty(vLinkMap)) {
            vNewMap = vPartMap;
        } else if (VJDFAttributeMap.isEmpty(vPartMap)) {
            vNewMap = vLinkMap;
        } else {
            for (JDFAttributeMap linkMap : vLinkMap) {
                if (this.setSpawnParts.contains(linkMap)) {
                    vNewMap.add(linkMap);
                    continue;
                }
                for (JDFAttributeMap m : vPartMap) {
                    if ((m = m.clone().orMap(linkMap)).isEmpty()) continue;
                    vNewMap.add(m);
                }
            }
            vNewMap.unify();
        }
        return vNewMap;
    }

    private void updateSpawnIDs(String spawnID, JDFResourceLink link) {
        VElement vRes = link.getTargetVector(-1);
        for (KElement e : vRes) {
            JDFResource res = (JDFResource)e;
            if (res.includesMatchingAttribute("SpawnIDs", spawnID, AttributeInfo.EnumAttributeType.NMTOKENS)) continue;
            res.appendSpawnIDs(spawnID);
            res.setLocked(false);
        }
    }

    private void finalizeStatusAndAudits(JDFSpawned spawnAudit) {
        spawnAudit.setPartMapVector(this.vSpawnParts);
        JDFElement.EnumNodeStatus partStatus = this.vSpawnParts != null && !this.vSpawnParts.isEmpty() ? this.node.getPartStatus(this.vSpawnParts.elementAt(0), 0) : this.node.getPartStatus(null, 0);
        if (partStatus != null) {
            spawnAudit.setStatus(partStatus);
        }
        VJDFAttributeMap vMap = this.getNIPartitions();
        this.node.setPartStatus(vMap, JDFElement.EnumNodeStatus.Spawned, null);
    }

    private VJDFAttributeMap getNIPartitions() {
        VJDFAttributeMap vMap;
        if (this.vSpawnParts != null) {
            VElement vNI;
            JDFNodeInfo nodeInfo = this.node.getNodeInfo();
            VElement vElement = vNI = nodeInfo == null ? null : nodeInfo.getPartitionVector(this.vSpawnParts, JDFResource.EnumPartUsage.Explicit);
            if (vNI != null) {
                vMap = new VJDFAttributeMap();
                for (KElement e : vNI) {
                    vMap.add(((JDFResource)e).getPartMap());
                }
            } else {
                vMap = this.vSpawnParts;
            }
        } else {
            vMap = this.vSpawnParts;
        }
        return vMap;
    }

    private VJDFAttributeMap getSpawnLinkMap(VJDFAttributeMap vLocalSpawnParts, JDFResource r) {
        VJDFAttributeMap vPartMap = new VJDFAttributeMap(vLocalSpawnParts);
        if (!JDFResource.EnumPartUsage.Implicit.equals(r.getPartUsage())) {
            VString vPartKeys = r.getPartIDKeys();
            Vector<JDFResource.EnumPartIDKey> vImplicitPartitions = r.getImplicitPartitions();
            if (vImplicitPartitions != null) {
                for (JDFResource.EnumPartIDKey e : vImplicitPartitions) {
                    vPartKeys.add(e.getName());
                }
            }
            vPartMap.reduceMap(vPartKeys.getSet());
        }
        return vPartMap;
    }

    private boolean linkFitsRWRes(JDFResourceLink li, VString vRWResources) {
        if (vRWResources == null) {
            return false;
        }
        boolean bResRW = vRWResources.contains(li.getNamedProcessUsage());
        if (!bResRW) {
            bResRW = vRWResources.contains(li.getLinkedResourceName());
        }
        if (!bResRW) {
            bResRW = vRWResources.contains(li.getrRef());
        }
        if (!bResRW) {
            bResRW = vRWResources.contains(li.getAttribute("Usage"));
        }
        return bResRW;
    }

    private Set<KElement> reducePartitions(JDFResource r, String nodeName, String nsURI, VString partIDKeys, int partIDPos, JDFAttributeMap parentMap, VElement identical) {
        HashSet<KElement> bad = new HashSet<KElement>();
        VElement children = r.getChildElementVector_KElement(nodeName, nsURI, null, true, -1);
        if (children != null) {
            int kidSize = children.size();
            for (int i = 0; i < kidSize; ++i) {
                String val;
                JDFResource child = (JDFResource)children.elementAt(i);
                String key = partIDKeys.get(partIDPos);
                if (key == null || (val = child.getAttribute_KElement(key, null, null)) == null) continue;
                JDFAttributeMap testMap = new JDFAttributeMap(parentMap);
                testMap.put(key, val);
                if (this.overlapsPartMap(testMap)) {
                    int iii;
                    JDFIdentical id = child.getIdentical();
                    if (id != null) {
                        if (this.bSpawnIdentical) {
                            this.addIdentical(r, identical, testMap);
                        } else {
                            bad.add(child);
                        }
                    }
                    if (partIDPos + 1 < partIDKeys.size()) {
                        bad.addAll(this.reducePartitions(child, nodeName, nsURI, partIDKeys, partIDPos + 1, testMap, identical));
                        continue;
                    }
                    List<JDFIdentical> v = child.getChildArrayByClass(JDFIdentical.class, true, 0);
                    if (v == null || v.isEmpty()) continue;
                    VElement v2 = new VElement();
                    for (iii = 0; iii < v.size(); ++iii) {
                        KElement parentNode_KElement = v.get(iii).getParentNode_KElement();
                        if (parentNode_KElement == child) continue;
                        v2.add(parentNode_KElement);
                    }
                    v2.unify();
                    for (iii = 0; iii < v2.size(); ++iii) {
                        JDFResource identParent = (JDFResource)v2.get(iii);
                        if (this.bSpawnIdentical) {
                            this.addIdentical(identParent, identical, identParent.getIdenticalMap());
                            continue;
                        }
                        identParent.deleteNode();
                    }
                    continue;
                }
                if (this.bSpawnIdentical) {
                    bad.addAll(child.getLeaves(true));
                    continue;
                }
                bad.add(child);
            }
            if (bad.size() >= children.size() && !this.bSpawnIdentical && !r.isResourceRoot() && bad.containsAll(children)) {
                bad.add(r);
            }
        }
        return bad;
    }

    private void addIdentical(JDFResource r, VElement identical, JDFAttributeMap testMap) {
        JDFResource resourceRoot = r.getResourceRoot();
        for (JDFResource partition = resourceRoot.getPartition(testMap, null); partition != resourceRoot && partition != null; partition = (JDFResource)partition.getParentNode_KElement()) {
            identical.add(partition);
        }
    }

    private boolean overlapsPartMap(JDFAttributeMap testMap) {
        if (this.vSpawnParts == null || testMap == null) {
            return true;
        }
        if (this.setSpawnParts.contains(testMap)) {
            return true;
        }
        Set keys = testMap.keySet();
        for (JDFAttributeMap map : this.vSpawnParts) {
            boolean bOK = true;
            for (String key : keys) {
                String linkValue = map.get(key);
                if (linkValue == null || JDFPart.matchesPart(key, testMap.get(key), linkValue, false)) continue;
                bOK = false;
                break;
            }
            if (!bOK) continue;
            return true;
        }
        return keys.isEmpty();
    }

    private void reducePartitions(JDFResource r, boolean bRW) {
        if (r == null || this.vSpawnParts == null || this.vSpawnParts.size() == 0 || this.isReduced.contains(r.getID())) {
            return;
        }
        VString partIDKeys = this.getPartIDKeys(r, bRW);
        if (VString.isEmpty(partIDKeys)) {
            return;
        }
        String id = r.getID();
        if (!this.bSpawnIdentical) {
            this.reduceFast(r, partIDKeys, 0, new JDFAttributeMap());
        }
        int nMax = 999;
        VElement vSubParts = r.getPartitionVector(this.vSpawnParts, JDFResource.EnumPartUsage.Implicit);
        for (int j = 0; j < vSubParts.size(); ++j) {
            int mapSize;
            JDFResource rr = (JDFResource)vSubParts.get(j);
            JDFAttributeMap partMap = rr.getPartMap(partIDKeys);
            int n = mapSize = partMap == null ? 0 : partMap.size();
            if (mapSize >= nMax || (nMax = mapSize) != 0) continue;
            return;
        }
        for (int i = partIDKeys.size() - 1; i >= nMax; --i) {
            partIDKeys.remove(i);
        }
        String nodeName = r.getLocalName();
        String nsURI = r.getNamespaceURI();
        VElement identical = new VElement();
        Set<KElement> vBad = this.reducePartitions(r, nodeName, nsURI, partIDKeys, 0, new JDFAttributeMap(), identical);
        if (identical.size() > 0) {
            identical.unify();
            vBad.removeAll(identical);
        }
        for (KElement bad : vBad) {
            bad.deleteNode();
        }
        this.isReduced.add(id);
    }

    private void reduceFast(JDFResource r, VString partIDKeys, int depth, JDFAttributeMap currentMap) {
        String key0 = partIDKeys.get(depth);
        int size = partIDKeys.size();
        List<? extends KElement> firstLevel = r.getDirectPartitionArray();
        if (firstLevel != null) {
            for (KElement kElement : firstLevel) {
                JDFResource rFirstLevel = (JDFResource)kElement;
                String partValue = rFirstLevel.getAttribute_KElement(key0, null, null);
                currentMap.put(key0, partValue);
                if (!JDFPart.overlapPartMap(currentMap, this.vSpawnParts, false)) {
                    kElement.deleteNode();
                    continue;
                }
                if (depth + 1 >= size) continue;
                this.reduceFast(rFirstLevel, partIDKeys, depth + 1, currentMap);
            }
            currentMap.remove(key0);
        }
    }

    private boolean resFitsRWRes(JDFResource r, VString vRWResources) {
        if (r == null) {
            return false;
        }
        boolean bResRW = vRWResources.contains(r.getLocalName());
        if (!bResRW) {
            bResRW = vRWResources.contains("*");
        }
        if (!bResRW) {
            bResRW = vRWResources.contains(r.getID());
        }
        return bResRW;
    }

    private void copySpawnedResource(JDFResourcePool targetResPool, JDFResource r, JDFResource.EnumSpawnStatus copyStatus, String spawnID, VString vRWResources, HashSet<String> vRWIDs, HashSet<String> vROIDs, HashSet<String> allIDsCopied, VJDFAttributeMap vLinkMap) {
        VString vs;
        if (r == null) {
            log.error((Object)"attempting to copy null resource - bailing out");
            return;
        }
        boolean bRW = copyStatus == JDFResource.EnumSpawnStatus.SpawnedRW;
        String rID = r.getID();
        if (!allIDsCopied.contains(rID)) {
            JDFResource rNew = this.copyPart(targetResPool, r, bRW);
            PartSpawn partSpawner = new PartSpawn();
            if (!this.bInformative) {
                copyStatus = partSpawner.spawnPart(r, spawnID, copyStatus, true, this.bSpawnROPartsOnly, vLinkMap);
            }
            boolean bl = bRW = (copyStatus = partSpawner.spawnPart(rNew, spawnID, copyStatus, false, this.bSpawnROPartsOnly, vLinkMap)) == JDFResource.EnumSpawnStatus.SpawnedRW;
            if (bRW) {
                vRWIDs.add(rID);
            } else {
                vROIDs.add(rID);
            }
            allIDsCopied.add(rID);
        }
        if ((vs = this.mapRefs.get(r)) == null) {
            vs = r.getHRefs(new VString(), false, false);
            this.mapRefs.put(r, vs);
        }
        for (String id : vs) {
            JDFResource next;
            if (allIDsCopied.contains(id) || (next = this.getNodeResource(id)) == null) continue;
            if (bRW) {
                copyStatus = this.resFitsRWRes(next, vRWResources) ? JDFResource.EnumSpawnStatus.SpawnedRW : JDFResource.EnumSpawnStatus.SpawnedRO;
            } else if (this.resFitsRWRes(next, vRWResources)) continue;
            this.copySpawnedResource(targetResPool, next, copyStatus, spawnID, vRWResources, vRWIDs, vROIDs, allIDsCopied, vLinkMap);
        }
    }

    private JDFResource copyPart(JDFResourcePool targetResPool, JDFResource r, boolean bRW) {
        JDFResource rNew;
        VString partIDKeys = this.getPartIDKeys(r, bRW);
        if ((bRW || this.bSpawnROPartsOnly) && !VString.isEmpty(partIDKeys)) {
            String resName = r.getNodeName();
            rNew = (JDFResource)targetResPool.appendElement(resName);
            rNew.setAttributesRaw(r);
            VJDFAttributeMap linkedIdentical = this.bSpawnIdentical ? new VJDFAttributeMap() : null;
            this.copyPartImpl(r, rNew, partIDKeys, 0, new JDFAttributeMap(), linkedIdentical, resName);
            if (!VJDFAttributeMap.isEmpty(linkedIdentical)) {
                linkedIdentical.unify();
                VString idParts = r.getPartIDKeys();
                for (JDFAttributeMap idMap : linkedIdentical) {
                    this.copySingle(rNew, r, idMap, idParts, 0);
                }
            }
        } else {
            rNew = (JDFResource)targetResPool.copyElement(r, null);
        }
        this.isReduced.add(r.getID());
        return rNew;
    }

    VString getPartIDKeys(JDFResource r, boolean bRW) {
        VString partIDKeys;
        VString vString = partIDKeys = r == null ? null : r.getPartIDKeys();
        if (!bRW && partIDKeys != null && !VString.isEmpty(this.vROSpawnParts)) {
            int lastPart = partIDKeys.size();
            for (int i = 0; i < lastPart; ++i) {
                if (this.vROSpawnParts.contains(partIDKeys.get(i))) continue;
                for (int j = i; j < lastPart; ++j) {
                    partIDKeys.remove(i);
                }
                break;
            }
        }
        return partIDKeys;
    }

    private void copySingle(JDFResource rNew, JDFResource r, JDFAttributeMap idMap, VString partIDKeys, int depth) {
        int size;
        int n = size = partIDKeys == null ? 0 : partIDKeys.size();
        if (depth < size) {
            String key0 = partIDKeys.get(depth);
            String val = idMap.get(key0);
            String nodeName = r.getNodeName();
            JDFResource rChild = (JDFResource)r.getChildWithAttribute(nodeName, key0, null, val, 0, true);
            if (rChild != null) {
                JDFResource rNewChild = (JDFResource)rNew.getChildWithAttribute(nodeName, key0, null, val, 0, true);
                if (rNewChild == null) {
                    rNewChild = (JDFResource)rNew.appendElement(nodeName);
                    rNewChild.setAttributesRaw(rChild);
                    for (KElement child = rChild.getFirstChildElement(); child != null; child = child.getNextSiblingElement()) {
                        if (nodeName.equals(child.getNodeName())) continue;
                        rNewChild.copyElement(child, null);
                    }
                }
                this.copySingle(rNewChild, rChild, idMap, partIDKeys, depth + 1);
            }
        }
    }

    private void copyPartImpl(JDFResource r, JDFResource target, VString partIDKeys, int depth, JDFAttributeMap currentMap, VJDFAttributeMap linkedIdentical, String resName) {
        String key0 = partIDKeys.get(depth);
        int size = partIDKeys.size();
        for (KElement child = r.getFirstChildElement(); child != null; child = child.getNextSiblingElement()) {
            if (resName.equals(child.getNodeName())) {
                String partValue = child.getAttribute_KElement(key0, null, null);
                currentMap.put(key0, partValue);
                if (!JDFPart.overlapPartMap(currentMap, this.vSpawnParts, false)) continue;
                if (depth + 1 < size) {
                    KElement newTarget = target.appendElement(resName);
                    newTarget.setAttributesRaw(child);
                    this.copyPartImpl((JDFResource)child, (JDFResource)newTarget, partIDKeys, depth + 1, currentMap, linkedIdentical, resName);
                    continue;
                }
                VJDFAttributeMap idMap = this.getIdenticals((JDFResource)child);
                if (linkedIdentical != null) {
                    target.copyElement(child, null);
                    if (idMap == null) continue;
                    linkedIdentical.addAll(idMap);
                    continue;
                }
                if (child.getElement("Identical") != null) continue;
                JDFResource copied = (JDFResource)target.copyElement(child, null);
                if (idMap == null) continue;
                List<JDFResource> cLeaves = copied.getLeafArray(false);
                for (JDFResource leaf : cLeaves) {
                    if (!leaf.hasChildElement("Identical", null)) continue;
                    leaf.deleteNode();
                }
                continue;
            }
            target.copyElement(child, null);
        }
        currentMap.remove(key0);
    }

    VJDFAttributeMap getIdenticals(JDFResource child) {
        VJDFAttributeMap ret = new VJDFAttributeMap();
        List<JDFResource> leaves = child.getLeafArray(false);
        for (JDFResource leaf : leaves) {
            JDFAttributeMap single = leaf.getIdenticalMap();
            if (single == null) continue;
            ret.add(single);
        }
        ret.unify();
        return VJDFAttributeMap.isEmpty(ret) ? null : ret;
    }

    private void fixSpawnPartitions(JDFResource r, VString rootPartIDKeys) {
        if (r == null) {
            return;
        }
        VString oldParts = r.getPartIDKeys();
        if (!ContainerUtil.isEmpty(rootPartIDKeys) && oldParts.containsAny(rootPartIDKeys)) {
            throw new JDFException("fixSpawnPartitions - adding incompatible resources");
        }
        List<KElement> ve = r.getChildArray_KElement(r.getNodeName(), r.getNamespaceURI(), null, true, 9999999);
        KElement[] tmp = new KElement[ve.size()];
        int n = 0;
        for (KElement e : ve) {
            tmp[n++] = e.deleteNode();
        }
        r.removeAttribute("PartIDKeys");
        VElement vNew = r.getResourceRoot().createPartitions(this.vSpawnParts, rootPartIDKeys);
        for (int i = 0; i < vNew.size(); ++i) {
            for (int j = 0; j < tmp.length; ++j) {
                vNew.item(i).copyElement(tmp[j], null);
            }
        }
        VString partIDKeys = r.getPartIDKeys();
        partIDKeys.appendUnique(oldParts);
        r.setPartIDKeys(partIDKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDFNode spawnInformative() {
        this.bInformative = true;
        if (this.informativeRoot == null) {
            JDFDoc docNew = new JDFDoc("JDF");
            this.informativeRoot = (JDFNode)docNew.getRoot();
            JDFNode thisRoot = this.node.getJDFRoot();
            docNew.setInitOnCreate(false);
            this.informativeRoot.copyInto(thisRoot, true);
            docNew.setInitOnCreate(true);
        }
        JDFNode copyOfThis = this.informativeRoot.getChildJDFNode(this.node.getID(), false);
        JDFNode tmp = this.node;
        this.node = copyOfThis;
        if (tmp != this.node) {
            this.mapResources.clear();
        }
        VString vRWTmp = this.vRWResources_in;
        boolean spawnMultKeep = this.bSpawnRWPartsMultiple;
        JDFNode nodeNew = null;
        try {
            this.bSpawnRWPartsMultiple = true;
            nodeNew = this.spawn();
            nodeNew.setActivation(JDFNode.EnumActivation.Informative);
        }
        finally {
            this.node = tmp;
            this.bSpawnRWPartsMultiple = spawnMultKeep;
            this.vRWResources_in = vRWTmp;
        }
        return nodeNew;
    }

    public JDFNode spawn(String _parentURL, String _spawnURL, VString _vRWResources_in, VJDFAttributeMap _vSpawnParts, boolean _bSpawnROPartsOnly, boolean _bCopyNodeInfo, boolean _bCopyCustomerInfo, boolean _bCopyComments) {
        this.bCopyComments = _bCopyComments;
        this.bCopyCustomerInfo = _bCopyCustomerInfo;
        this.bCopyNodeInfo = _bCopyNodeInfo;
        this.bSpawnROPartsOnly = _bSpawnROPartsOnly;
        this.vSpawnParts = _vSpawnParts;
        this.vRWResources_in = new VString(_vRWResources_in);
        this.spawnURL = _spawnURL;
        this.parentURL = _parentURL;
        this.bInformative = false;
        return this.spawn();
    }

    public JDFNode spawnInformative(String _parentURL, String _spawnURL, VJDFAttributeMap _vSpawnParts, boolean _bSpawnROPartsOnly, boolean _bCopyNodeInfo, boolean _bCopyCustomerInfo, boolean _bCopyComments) {
        this.bCopyComments = _bCopyComments;
        this.bCopyCustomerInfo = _bCopyCustomerInfo;
        this.bCopyNodeInfo = _bCopyNodeInfo;
        this.bSpawnROPartsOnly = _bSpawnROPartsOnly;
        this.vSpawnParts = _vSpawnParts;
        this.vRWResources_in = null;
        this.spawnURL = _spawnURL;
        this.parentURL = _parentURL;
        return this.spawnInformative();
    }

    public JDFNode unSpawn(String spawnID) {
        JDFSpawned spawnAudit;
        log.info((Object)("Unspawning node ID=" + spawnID));
        JDFNode nodeParent = this.findUnSpawnNode(this.node, spawnID);
        if (nodeParent != null && spawnID == null && (spawnAudit = (JDFSpawned)nodeParent.getAuditPool().getAudit(0, JDFAudit.EnumAuditType.Spawned, null, null)) != null) {
            spawnID = spawnAudit.getNewSpawnID();
            log.info((Object)("calculating spawnID from parent: SpawnID=" + spawnID));
        }
        return new Unspawn(nodeParent, spawnID).unSpawnNode();
    }

    private JDFNode findUnSpawnNode(JDFNode myNode, String spawnID) {
        VElement vJDFNodes = myNode.getvJDFNode(null, null, false);
        JDFAttributeMap mapSpawn = new JDFAttributeMap("NewSpawnID", spawnID);
        int i = 0;
        int size = vJDFNodes.size();
        for (i = 0; i < size; ++i) {
            JDFAttributeMap mapMerge;
            JDFAudit mergedAudit;
            JDFAudit spawnAudit;
            JDFNode nodeParent = (JDFNode)vJDFNodes.elementAt(i);
            JDFAuditPool auditPool = nodeParent.getAuditPool();
            if (auditPool == null || (spawnAudit = auditPool.getAudit(0, JDFAudit.EnumAuditType.Spawned, mapSpawn, null)) == null || (mergedAudit = auditPool.getAudit(0, JDFAudit.EnumAuditType.Merged, mapMerge = new JDFAttributeMap("MergeID", spawnID), null)) != null) continue;
            return nodeParent;
        }
        JDFNode parent = myNode.getParentJDF();
        return parent == null ? null : this.findUnSpawnNode(parent, spawnID);
    }

    public String toString() {
        String jpID = this.node == null ? " - " : this.node.getJobPartID(false);
        return "[JDFSpawn JobPartID=" + jpID + "\nParts: " + String.valueOf(this.vSpawnParts) + "\nRW: " + String.valueOf(this.vRWResources_in);
    }

    public void unSpawnChild(JDFNode childNode) {
        childNode.removeChild("AncestorPool", null, 0);
        JDFAttributeMap spawnStuff = new JDFAttributeMap();
        spawnStuff.put("SpawnID", (String)null);
        spawnStuff.put("SpawnIDs", (String)null);
        spawnStuff.put("SpawnStatus", (String)null);
        spawnStuff.put("Locked", (String)null);
        new AttributeReplacer(spawnStuff, null).replace(childNode);
    }

    private class PartSpawn {
        private PartSpawn() {
        }

        JDFResource.EnumSpawnStatus spawnPart(JDFResource r, String spawnID, JDFResource.EnumSpawnStatus copyStatus, boolean bStayinMain, boolean partsRO, VJDFAttributeMap vLinkMap) {
            boolean isRW = JDFResource.EnumSpawnStatus.SpawnedRW.equals(copyStatus);
            if (!VJDFAttributeMap.isEmpty(JDFSpawn.this.vSpawnParts) && (JDFResource.EnumSpawnStatus.SpawnedRW.equals(copyStatus) || partsRO)) {
                copyStatus = this.spawnPartitionedPart(r, spawnID, copyStatus, bStayinMain, vLinkMap, isRW);
            } else {
                this.spawnComplete(r, spawnID, copyStatus, bStayinMain, isRW);
            }
            return copyStatus;
        }

        void spawnComplete(JDFResource r, String spawnID, JDFResource.EnumSpawnStatus copyStatus, boolean bStayinMain, boolean isRW) {
            if (bStayinMain) {
                if (isRW || !JDFResource.EnumSpawnStatus.SpawnedRW.equals(r.getSpawnStatus())) {
                    r.setSpawnStatus(copyStatus);
                    r.setLocked(isRW);
                }
                r.appendSpawnIDs(spawnID);
            } else {
                r.setLocked(!isRW);
                r.setSpawnIDs(new VString(spawnID, null));
            }
        }

        JDFResource.EnumSpawnStatus spawnPartitionedPart(JDFResource r, String spawnID, JDFResource.EnumSpawnStatus copyStatus, boolean bStayinMain, VJDFAttributeMap vLinkMap, boolean isRW) {
            JDFAttributeMap partMap = r.getPartMap();
            VElement vSubParts = this.getSubParts(r, partMap, vLinkMap);
            if (ContainerUtil.isEmpty(vSubParts)) {
                return this.spawnPart(r, spawnID, JDFResource.EnumSpawnStatus.SpawnedRO, bStayinMain, false, vLinkMap);
            }
            for (KElement e : vSubParts) {
                JDFResource pLeaf = (JDFResource)e;
                if (bStayinMain) {
                    if (isRW || !JDFResource.EnumSpawnStatus.SpawnedRW.equals(pLeaf.getSpawnStatus())) {
                        pLeaf.setSpawnStatus(copyStatus);
                        pLeaf.setLocked(isRW);
                    }
                    pLeaf.appendSpawnIDs(spawnID);
                    continue;
                }
                pLeaf.setLocked(!isRW);
                pLeaf.setSpawnIDs(spawnID);
            }
            return copyStatus;
        }

        private VElement getSubParts(JDFResource r, JDFAttributeMap partMap, VJDFAttributeMap vLinkMap) {
            VElement vSubParts;
            if (JDFSpawn.this.setSpawnParts.contains(partMap)) {
                vSubParts = new VElement();
                vSubParts.add(r);
            } else {
                PartitionGetter partitionGetter = new PartitionGetter(r.getResourceRoot());
                partitionGetter.setFollowIdentical(JDFSpawn.this.bSpawnIdentical);
                vSubParts = partitionGetter.getPartitionVector(JDFSpawn.this.vSpawnParts, null);
                if (JDFSpawn.this.bSpawnIdentical && (vSubParts == null || vSubParts.size() == 0) && !JDFResource.EnumPartUsage.Implicit.equals(r.getPartUsage())) {
                    VJDFAttributeMap other;
                    if (!VJDFAttributeMap.isEmpty(vLinkMap)) {
                        VJDFAttributeMap linkMapClone = vLinkMap.clone();
                        linkMapClone.overlapMap(JDFSpawn.this.vSpawnParts);
                        VJDFAttributeMap spawnClone = new VJDFAttributeMap(JDFSpawn.this.vSpawnParts);
                        spawnClone.overlapMap(vLinkMap);
                        other = vLinkMap.getOrMaps(spawnClone);
                    } else {
                        other = JDFSpawn.this.vSpawnParts;
                    }
                    vSubParts = partitionGetter.getPartitionVector(other, JDFResource.EnumPartUsage.Implicit);
                }
            }
            return vSubParts;
        }
    }

    private class Unspawn {
        private final String strSpawnID;
        private final JDFNode parent;

        public Unspawn(JDFNode parent, String strSpawnID) {
            this.parent = parent;
            this.strSpawnID = strSpawnID;
        }

        JDFNode unSpawnNode() {
            if (this.parent == null) {
                log.warn((Object)"No parent to unspawn, bailing out");
                return null;
            }
            JDFSpawned spawnAudit = null;
            JDFNode localNode = null;
            if (StringUtil.getNonEmpty(this.strSpawnID) != null) {
                spawnAudit = this.findSpawnAudit();
            }
            if (spawnAudit != null) {
                VJDFAttributeMap parts = this.unspawnRO(spawnAudit);
                this.unspawnRW(spawnAudit);
                localNode = (JDFNode)this.parent.getTarget(spawnAudit.getjRef(), "ID");
                this.unspawnLocal(localNode);
                this.updateStatus(spawnAudit, localNode, parts);
                spawnAudit.deleteNode();
            }
            return localNode;
        }

        private JDFSpawned findSpawnAudit() {
            JDFAuditPool auditPool = this.parent.getAuditPool();
            if (auditPool != null) {
                JDFAttributeMap mapSpawn = new JDFAttributeMap("NewSpawnID", this.strSpawnID);
                JDFSpawned spawnAudit = (JDFSpawned)auditPool.getAudit(0, JDFAudit.EnumAuditType.Spawned, mapSpawn, null);
                if (spawnAudit == null) {
                    log.warn((Object)"No parent audit to unspawn, bailing out");
                }
                return spawnAudit;
            }
            return null;
        }

        private void unspawnRW(JDFSpawned spawnAudit) {
            VString vRWCopied = spawnAudit.getrRefsRWCopied();
            if (vRWCopied != null) {
                for (String rwCopied : vRWCopied) {
                    JDFResource oldRes = (JDFResource)this.parent.getTarget(rwCopied, "ID");
                    if (oldRes == null) continue;
                    oldRes.unSpawnPart(this.strSpawnID, JDFResource.EnumSpawnStatus.SpawnedRW);
                }
            }
        }

        private void updateStatus(JDFSpawned spawnAudit, JDFNode localNode, VJDFAttributeMap parts) {
            JDFElement.EnumNodeStatus status = JDFElement.EnumNodeStatus.Waiting;
            boolean fHasAuditStatus = spawnAudit.hasAttribute("Status");
            if (fHasAuditStatus) {
                status = spawnAudit.getStatus();
            }
            if (parts != null) {
                JDFElement.EnumNodeStatus parentStatus = this.parent.getStatus();
                if (JDFElement.EnumNodeStatus.Pool.equals(parentStatus) || JDFElement.EnumNodeStatus.Part.equals(parentStatus)) {
                    for (JDFAttributeMap part : parts) {
                        if (!fHasAuditStatus && !JDFElement.EnumNodeStatus.Spawned.equals(this.parent.getPartStatus(part, 0))) continue;
                        this.parent.setPartStatus(part, status, null);
                    }
                } else if (JDFElement.EnumNodeStatus.Spawned.equals(parentStatus) || spawnAudit.hasAttribute("Status")) {
                    this.parent.setStatus(status);
                }
            } else if (localNode != null && (JDFElement.EnumNodeStatus.Spawned.equals(localNode.getStatus()) || spawnAudit.hasAttribute("Status"))) {
                localNode.setStatus(status);
            }
        }

        private void unspawnLocal(JDFNode localNode) {
            VElement vn;
            VElement vElement = vn = localNode == null ? null : localNode.getvJDFNode(null, null, false);
            if (vn != null) {
                for (int nod = 0; nod < vn.size(); ++nod) {
                    JDFNode deepNode = (JDFNode)vn.elementAt(nod);
                    JDFResourcePool resPool = deepNode.getResourcePool();
                    if (resPool == null) continue;
                    VElement vRes = resPool.getPoolChildren(null, null, null);
                    for (int i = 0; i < vRes.size(); ++i) {
                        JDFResource res1 = (JDFResource)vRes.elementAt(i);
                        res1.unSpawnPart(this.strSpawnID, JDFResource.EnumSpawnStatus.SpawnedRW);
                    }
                }
            }
        }

        private VJDFAttributeMap unspawnRO(JDFSpawned spawnAudit) {
            VJDFAttributeMap parts = spawnAudit.getPartMapVector();
            VString vROCopied = spawnAudit.getrRefsROCopied();
            if (vROCopied != null) {
                for (String roCopied : vROCopied) {
                    JDFResource oldRes = (JDFResource)this.parent.getTarget(roCopied, "ID");
                    if (oldRes == null) continue;
                    oldRes.unSpawnPart(this.strSpawnID, JDFResource.EnumSpawnStatus.SpawnedRO);
                }
            }
            return parts;
        }
    }
}

