/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JavaEnumUtil {
    private JavaEnumUtil() {
    }

    public static <T extends Enum<T>> T min(T e1, T e2) {
        if (e1 == null || e2 == null) {
            return null;
        }
        return e1.ordinal() < e2.ordinal() ? e1 : e2;
    }

    public static <T extends Enum<T>> T max(T e1, T e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        return e1.ordinal() > e2.ordinal() ? e1 : e2;
    }

    public static String getName(Enum<?> en) {
        return en == null ? null : en.name();
    }

    public static <T extends Enum<T>> boolean aLessThanB(T a, T b) {
        int aa = a == null ? -1 : a.ordinal();
        int bb = b == null ? -1 : b.ordinal();
        return aa < bb;
    }

    public static <T extends Enum<T>> boolean aLessEqualsThanB(T a, T b) {
        int aa = a == null ? -1 : a.ordinal();
        int bb = b == null ? -1 : b.ordinal();
        return aa <= bb;
    }

    public static <T extends Enum<T>> T getEnumIgnoreCase(Class<T> c, String val) {
        return JavaEnumUtil.getEnumIgnoreCase(c, val, null);
    }

    public static <T extends Enum<T>> T getEnumIgnoreCase(Class<T> c, String val, T def) {
        block4: {
            if (!StringUtil.isEmpty(val = StringUtil.trim(val, null))) {
                try {
                    return Enum.valueOf(c, val);
                }
                catch (Exception x) {
                    Enum[] vals = (Enum[])c.getEnumConstants();
                    if (vals == null) break block4;
                    for (Enum e : vals) {
                        if (!e.name().equalsIgnoreCase(val)) continue;
                        return (T)e;
                    }
                }
            }
        }
        return def;
    }

    public static <T extends Enum<T>> List<String> getNamesList(Class<T> c) {
        Enum[] vals;
        Enum[] enumArray = vals = c == null ? null : (Enum[])c.getEnumConstants();
        if (vals != null) {
            StringArray ret = new StringArray();
            for (Enum e : vals) {
                ret.add(e.name());
            }
            return ret;
        }
        return null;
    }

    public static <T extends Enum<T>> StringArray getNameList(Collection<T> esn, boolean unique) {
        StringArray ret = new StringArray();
        if (!ContainerUtil.isEmpty(esn)) {
            for (Enum e : esn) {
                ret.add(e.name());
            }
            if (unique) {
                ret.unify();
            }
        }
        return ret;
    }

    public static <T extends Enum<T>> List<T> getEnumList(Class<T> c, Collection<String> strings, boolean unique) {
        ArrayList ret = new ArrayList();
        if (!StringUtil.isEmpty(strings)) {
            for (String s : strings) {
                ContainerUtil.add(ret, JavaEnumUtil.getEnumIgnoreCase(c, s));
            }
            if (unique) {
                ContainerUtil.unify(ret);
            }
        }
        return ret;
    }

    public static <T extends Enum<T>> List<T> getEnumList(Class<T> c, String strings, boolean unique) {
        StringArray lst = StringArray.getVString(strings, null);
        return JavaEnumUtil.getEnumList(c, lst, unique);
    }
}

