/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.StringUtil;

public class MyArgs {
    private VString m_onlyArgs;
    private String m_switchParameterString;
    private String m_argumentParameterString;
    private String m_requiredParameterString;
    private final HashSet<String> m_flags = new HashSet();
    private final HashMap<String, String> m_Parameters = new HashMap();
    private VString m_argV;

    @Deprecated
    public MyArgs(String[] argv, String switchParameterString, String argumentParameterString) {
        this.initMyArgs(argv, switchParameterString, argumentParameterString, null);
    }

    public MyArgs(String[] argv, String switchParameterString, String argumentParameterString, String requiredParameterString) {
        this.initMyArgs(argv, switchParameterString, argumentParameterString, requiredParameterString);
    }

    private void initMyArgs(String[] argv, String strSwitchParameter, String strArgumentParameter, String strRequiredParameter) {
        String[] argvLocal = argv;
        if (argvLocal == null) {
            argvLocal = new String[]{};
        }
        this.m_switchParameterString = strSwitchParameter;
        this.m_argumentParameterString = strArgumentParameter;
        this.m_requiredParameterString = strRequiredParameter == null ? "" : strRequiredParameter;
        this.m_argV = new VString(argvLocal);
        this.m_onlyArgs = new VString();
        for (int i = 0; i < argvLocal.length; ++i) {
            String tempString = argvLocal[i];
            if (tempString.startsWith("-")) {
                String whazzLeft = tempString.substring(1);
                while (whazzLeft.length() > 0) {
                    String flag = whazzLeft.substring(0, 1);
                    if (this.m_switchParameterString != null && this.m_switchParameterString.indexOf(flag) >= 0) {
                        this.m_flags.add(flag);
                        whazzLeft = whazzLeft.substring(1);
                        continue;
                    }
                    if (this.m_argumentParameterString != null && this.m_argumentParameterString.indexOf(flag) >= 0) {
                        String wl2 = whazzLeft.substring(1);
                        if (wl2.length() == 0 && argvLocal.length > i + 1) {
                            wl2 = argvLocal[i + 1];
                            ++i;
                        }
                        this.m_Parameters.put(flag, wl2);
                        whazzLeft = "";
                        continue;
                    }
                    whazzLeft = whazzLeft.substring(1);
                    if (flag.equals("-")) continue;
                    System.out.println("unknown flag:" + flag);
                }
                continue;
            }
            this.m_onlyArgs.add(tempString);
        }
    }

    public String toString() {
        Object s = "\n\tMyArgs: \n";
        s = (String)s + "\t\t switchParameterString=" + this.m_switchParameterString + "\n";
        s = (String)s + "\t\t argumentParameterString=" + this.m_argumentParameterString + "\n";
        s = (String)s + "\t\t requiredParameterString=" + this.m_requiredParameterString + "\n";
        s = (String)s + "\t\t argC    =" + this.m_argV.size() + "\n";
        s = (String)s + "\t\t argV    =" + String.valueOf(this.m_argV) + "\n";
        s = (String)s + "\t\t Nargs   =" + this.nargs() + "\n";
        s = (String)s + "\t\t Flags:  =";
        Iterator<String> it = this.m_flags.iterator();
        while (it.hasNext()) {
            s = (String)s + it.next() + ", ";
        }
        s = (String)s + "\n";
        it = this.m_Parameters.keySet().iterator();
        s = (String)s + "\t\t Parameters: \n";
        while (it.hasNext()) {
            String key = it.next();
            s = (String)s + "\t\t\t " + key + " = " + this.m_Parameters.get(key) + "\n";
        }
        s = (String)s + "\t\t onlyArgs=" + String.valueOf(this.m_onlyArgs) + "\n";
        s = (String)s + "\n";
        return s;
    }

    public String missingArgs() {
        Object missing = "";
        for (int i = 0; i < this.m_requiredParameterString.length(); ++i) {
            if (this.hasParameter(this.m_requiredParameterString.charAt(i))) continue;
            missing = (String)missing + this.m_requiredParameterString.charAt(i);
        }
        return StringUtil.getNonEmpty((String)missing);
    }

    public String parameter(String c) {
        return this.parameter(c.charAt(0));
    }

    public String parameter(char c) {
        return this.m_Parameters.get("" + c);
    }

    public String parameterString(String s) {
        return this.parameterString(s.charAt(0));
    }

    public String parameterString(char c) {
        return this.parameter(c);
    }

    public int nargs() {
        return this.m_onlyArgs.size();
    }

    public String argument(int m) {
        if (m >= this.nargs()) {
            return null;
        }
        return this.m_onlyArgs.get(m);
    }

    public String argumentString(int m) {
        return this.argument(m);
    }

    public int intParameter(char c, int defaultValue, int radix) {
        return this.intParameter("" + c, defaultValue, radix);
    }

    public int intParameter(String s, int defaultValue, int radix) {
        String paramString = this.parameter(s);
        try {
            return Integer.parseInt(paramString, radix);
        }
        catch (NumberFormatException e) {
            System.out.println("WARNING: Int-Parameter[" + s + "] has no Int-Argument or does not exist (= [" + paramString + "] ) ==> use default value: " + defaultValue);
            return defaultValue;
        }
    }

    public double floatParameter(char c, double defaultValue) {
        return this.floatParameter("" + c, defaultValue);
    }

    public double floatParameter(String s, double defaultValue) {
        String paramString = this.parameter(s);
        try {
            return Double.parseDouble(paramString);
        }
        catch (NumberFormatException e) {
            System.out.println("WARNING: Float-Parameter[" + s + "] has no Double-Argument or does not exist (= [" + paramString + "] ) ==> use default value: " + defaultValue);
            return defaultValue;
        }
    }

    public boolean boolParameter(char c) {
        return this.boolParameter("" + c);
    }

    @Deprecated
    public boolean boolParameter(char c, boolean defaultValue) {
        return this.boolParameter("" + c, defaultValue);
    }

    public void setFlag(char c, boolean val) {
        if (val) {
            this.m_flags.add("" + c);
        } else {
            this.m_flags.remove("" + c);
        }
    }

    public void setParam(char c, String val) {
        if (val != null) {
            this.m_Parameters.put("" + c, val);
        } else {
            this.m_Parameters.remove("" + c);
        }
    }

    @Deprecated
    public boolean boolParameter(String s, boolean defaultValue) {
        return this.m_flags.contains(s) ? true : defaultValue;
    }

    public boolean boolParameter(String s) {
        return this.m_flags.contains(s);
    }

    public String usage(String paramString) {
        Object usageTable = paramString == null ? "" : paramString;
        usageTable = (String)usageTable + "\n.\n.\n.usage: ";
        if (this.m_argV.size() > 0) {
            usageTable = (String)usageTable + this.m_argV.get(0);
        }
        if (this.m_switchParameterString != null) {
            usageTable = (String)usageTable + "\n\t switches:   -" + this.m_switchParameterString;
        }
        if (this.m_argumentParameterString != null) {
            usageTable = (String)usageTable + "\n\t Parameters: -" + this.m_argumentParameterString;
        }
        if (this.m_requiredParameterString != null) {
            usageTable = (String)usageTable + "\n\t Required:   -" + this.m_requiredParameterString;
        }
        usageTable = (String)usageTable + "\n\t Argument(s)\n";
        return usageTable;
    }

    public boolean hasParameter(char c) {
        return this.m_switchParameterString != null && this.m_switchParameterString.indexOf(c) > -1 && this.m_flags.contains("" + c) || this.parameter(c) != null;
    }
}

