/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.span.JDFSpanBase;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JavaEnumUtil;
import org.cip4.jdflib.util.NumberFormatter;
import org.cip4.jdflib.util.StringUtil;

public class UnitParser {
    static final Set<String> unitKeys = UnitParser.getUnitKeys();
    private int precision;
    private static final UnitParser roundTrip = UnitParser.getRoundTrip();

    public UnitParser() {
        this.setPrecision(4);
    }

    public void convertUnits(KElement element, boolean recurse) {
        this.convertUnits(element);
        if (recurse) {
            List<KElement> v = element.getChildList();
            for (KElement e : v) {
                this.convertUnits(e, recurse);
            }
        }
    }

    public void convertUnits(KElement element) {
        JDFAttributeMap map = element.getAttributeMap_KElement();
        boolean elemSpan = element instanceof JDFSpanBase && this.isUnit(element.getLocalName());
        for (Map.Entry e : map.entrySet()) {
            JDFDate d;
            String newVal;
            String key = (String)e.getKey();
            if (!elemSpan && !this.isUnit(key)) continue;
            String val = (String)e.getValue();
            if (!val.equals(newVal = this.extractUnits(val))) {
                element.setAttribute(key, newVal);
            }
            if (!(element instanceof JDFElement) || !AttributeInfo.EnumAttributeType.dateTime.equals(((JDFElement)element).getAttributeInfo().getAttributeType(key)) || (d = JDFDate.createDate(val)) == null || val.equals(d.getDateTimeISO())) continue;
            element.setAttribute(key, d.getDateTimeISO());
        }
    }

    public boolean isUnit(String key) {
        return unitKeys.contains(key);
    }

    public void addUnitKey(String key) {
        unitKeys.add(key);
    }

    private static Set<String> getUnitKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (keys.isEmpty()) {
            keys.add("AbsoluteBox");
            keys.add("AbsoluteHeight");
            keys.add("AbsoluteWidth");
            keys.add("AdvanceDistance");
            keys.add("Backing");
            keys.add("BackOverfold");
            keys.add("BlankDimensionsX");
            keys.add("BlankDimensionsY");
            keys.add("BleedBottom");
            keys.add("BleedFace");
            keys.add("BleedFoot");
            keys.add("BleedHead");
            keys.add("BleedLeft");
            keys.add("BleedRight");
            keys.add("BleedSpine");
            keys.add("BottomFoldIn");
            keys.add("Box");
            keys.add("BoundingBox");
            keys.add("BurnOutArea");
            keys.add("CartonTopFlaps");
            keys.add("CaseRadius");
            keys.add("Center");
            keys.add("ClampSize");
            keys.add("ClipBox");
            keys.add("CoverWidth");
            keys.add("CutBox");
            keys.add("CutWidth");
            keys.add("Diameter");
            keys.add("Dimension");
            keys.add("Dimensions");
            keys.add("ExpansionBox");
            keys.add("Extent");
            keys.add("FinishedDimensions");
            keys.add("FlatDimensions");
            keys.add("FoldingDistance");
            keys.add("FoldingWidth");
            keys.add("FoldingWidthBack");
            keys.add("FrontFoldIn");
            keys.add("FrontOverfold");
            keys.add("GlueLineWidth");
            keys.add("GluingPattern");
            keys.add("GutterX");
            keys.add("GutterX2");
            keys.add("GutterY");
            keys.add("GutterY2");
            keys.add("Height");
            keys.add("HorizontalExcess");
            keys.add("HorizontalExcessBack");
            keys.add("InnerCoreDiameter");
            keys.add("InnerDimensions");
            keys.add("JointWidth");
            keys.add("KnockoutBleed");
            keys.add("LaminatingBox");
            keys.add("Length");
            keys.add("LengthOverall");
            keys.add("MarginBottom");
            keys.add("MarginLeft");
            keys.add("MarginRight");
            keys.add("MarginTop");
            keys.add("MaxHeight");
            keys.add("MillingDepth");
            keys.add("MinGutter");
            keys.add("NeedlePositions");
            keys.add("NipWidth");
            keys.add("NotchingDepth");
            keys.add("NotchingDistance");
            keys.add("Offset");
            keys.add("OuterCoreDiameter");
            keys.add("Overfold");
            keys.add("Overhang");
            keys.add("OverhangOffset");
            keys.add("Pitch");
            keys.add("Position");
            keys.add("RollCut");
            keys.add("RollDiameter");
            keys.add("Rounding");
            keys.add("Size");
            keys.add("Spine");
            keys.add("SpineWidth");
            keys.add("StartPosition");
            keys.add("StitchPositions");
            keys.add("StitchWidth");
            keys.add("StrapPositions");
            keys.add("StripLength");
            keys.add("SurfaceContentsBox");
            keys.add("TabExtensionDistance");
            keys.add("TabOffset");
            keys.add("TabWidth");
            keys.add("Thickness");
            keys.add("ThreadLength");
            keys.add("ThreadPositions");
            keys.add("ThreadStitchWidth");
            keys.add("ThreadThickness");
            keys.add("TopExcess");
            keys.add("TopFoldIn");
            keys.add("TotalDimensions");
            keys.add("Travel");
            keys.add("TrimBottom");
            keys.add("TrimBox");
            keys.add("TrimFace");
            keys.add("TrimFoot");
            keys.add("TrimHead");
            keys.add("TrimLeft");
            keys.add("TrimmingOffset");
            keys.add("TrimRight");
            keys.add("TrimSize");
            keys.add("TrimTop");
            keys.add("VisibleLength");
            keys.add("Width");
            keys.add("WireGauge");
            keys.add("WorkingDirection");
            keys.add("WorkingLength");
            keys.add("WorkingPath");
            keys.add("ZoneHeight");
            keys.add("ZoneWidth");
        }
        return keys;
    }

    public double getFactor(String unit) {
        return eParserUnit.getFactor(unit);
    }

    public String extractUnits(String key, String val) {
        if (ContainerUtil.contains(unitKeys, key)) {
            return this.extractUnits(val);
        }
        return val;
    }

    public String getUnitString(String key, eParserUnit pu, String val0, String sep) {
        if (this.isUnit(key)) {
            return this.getUnitString(pu, val0, sep);
        }
        return val0;
    }

    public String getUnitString(eParserUnit pu, String val0, String sep) {
        String val = roundTrip.extractUnits(val0);
        if (val == null) {
            return val;
        }
        StringArray v = StringArray.getVString(val, null);
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (String v0 : v) {
            if (StringUtil.isNumber(v0)) {
                if (!first) {
                    ret.append(' ');
                }
                double d = StringUtil.parseDouble(v0, 0.0);
                ret.append(this.getNoUnitString(pu, d, sep));
                first = false;
                continue;
            }
            return val0;
        }
        return ret.toString();
    }

    private static UnitParser getRoundTrip() {
        UnitParser p = new UnitParser();
        p.setPrecision(42);
        return p;
    }

    public String extractUnits(String val) {
        if (val == null) {
            return val;
        }
        StringArray v = StringArray.getVString(val, null);
        StringArray keep = new StringArray(v);
        boolean oneGood = false;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            String tmp = v.get(i).toLowerCase();
            double factor = 1.0;
            eParserUnit pu = eParserUnit.getEnum(StringUtil.rightStr(tmp, 2));
            if (pu != null) {
                factor = pu.getFactor();
                tmp = StringUtil.leftStr(tmp, -2);
            }
            if (factor > 0.0 && i > 0 && tmp == null && StringUtil.isNumber(keep.get(i - 1))) {
                if (i < 2 || !"\"".equals(v.get(i - 2))) {
                    tmp = v.get(i - 1);
                    v.set(i - 1, "\"");
                } else {
                    oneGood = false;
                    break;
                }
            }
            if (!StringUtil.isNumber(tmp)) {
                factor = 0.0;
            }
            if (factor != 0.0) {
                if (factor == 1.0 && (tmp.startsWith("0") || tmp.startsWith("-0")) && StringUtil.isInteger(tmp)) {
                    v.set(i, tmp);
                    continue;
                }
                oneGood = true;
                double dbl = StringUtil.parseDouble(tmp, -1.0) * factor;
                v.set(i, new NumberFormatter().formatDouble(dbl, this.precision));
                continue;
            }
            oneGood = false;
            break;
        }
        if (oneGood) {
            val = StringUtil.setvString(v, " ", null, null);
            val = StringUtil.replaceString(val, "\" ", "");
        }
        return val;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public String getNoUnitString(eParserUnit unit, double points, String separator) {
        return StringUtil.formatDouble(points / unit.getFactor(), this.precision) + separator + unit.name();
    }

    public String getNoUnitString(eParserUnit unit, double points) {
        return this.getNoUnitString(unit, points, " ");
    }

    public int getPrecision() {
        return this.precision;
    }

    public String toString() {
        return "UnitParser [precision=" + this.precision + "]";
    }

    public static enum eParserUnit {
        in,
        cm,
        mm,
        pt;


        public static eParserUnit getEnum(String val) {
            return JavaEnumUtil.getEnumIgnoreCase(eParserUnit.class, val);
        }

        public static double getFactor(String val) {
            eParserUnit pu = eParserUnit.getEnum(val);
            return pu == null ? 1.0 : pu.getFactor();
        }

        public double getFactor() {
            switch (this) {
                case mm: {
                    return 2.834645669291339;
                }
                case cm: {
                    return 28.346456692913385;
                }
                case in: {
                    return 72.0;
                }
            }
            return 1.0;
        }
    }
}

