/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.core.XMLParser;
import org.cip4.jdflib.core.XMLParserFactory;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.util.ByteArrayIOFileStream;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.net.IPollDetails;

public class UrlPart
implements IPollDetails,
IStreamWriter {
    private final int rc;
    private InputStream inStream;
    private final String contentType;
    private ByteArrayIOStream bufferStream;
    public long contentLength;
    private final URLConnection connection;
    private final String url;

    @Override
    public int getResponseCode() {
        return this.rc;
    }

    @Override
    public void writeStream(OutputStream os) throws IOException {
        this.buffer();
        IOUtils.copy((InputStream)this.getResponseStream(), (OutputStream)os);
        os.flush();
        os.close();
    }

    public UrlPart(HttpURLConnection connection) throws IOException {
        this(connection, true);
    }

    public UrlPart(URLConnection connection, boolean isHttp) throws IOException {
        this.connection = connection;
        this.contentType = connection.getContentType();
        this.contentLength = connection.getContentLength();
        this.url = UrlUtil.urlToString(connection.getURL());
        if (isHttp) {
            try {
                this.inStream = connection.getInputStream();
            }
            catch (IOException x) {
                this.inStream = null;
            }
            if (this.inStream == null) {
                this.inStream = ((HttpURLConnection)connection).getErrorStream();
            }
            this.rc = ((HttpURLConnection)connection).getResponseCode();
        } else {
            this.inStream = connection.getInputStream();
            this.rc = 200;
        }
        this.bufferStream = null;
    }

    public UrlPart(BodyPart part) throws MessagingException, IOException {
        this.inStream = part.getInputStream();
        this.contentLength = part.getSize();
        this.contentType = part.getContentType();
        this.connection = null;
        this.bufferStream = null;
        this.url = part.getFileName();
        this.rc = 200;
    }

    public UrlPart(File f) throws IOException {
        this.inStream = FileUtil.getBufferedInputStream(f);
        if (f == null) {
            this.contentLength = 0L;
            this.contentType = null;
            this.url = null;
        } else {
            this.contentLength = f.length();
            this.contentType = UrlUtil.getMimeTypeFromURL(f.getName());
            this.url = f.getAbsolutePath();
        }
        this.connection = null;
        this.rc = f == null ? 500 : (this.inStream == null ? 404 : 200);
        this.bufferStream = null;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setInStream(InputStream inStream) {
        this.inStream = inStream;
        this.bufferStream = null;
    }

    @Override
    public InputStream getResponseStream() {
        return this.bufferStream == null ? this.inStream : this.bufferStream.getInputStream();
    }

    public String getResponseString(int maxLen) {
        this.buffer();
        ByteArrayIOStream.ByteArrayIOInputStream bios = this.bufferStream.getInputStream();
        return bios.asString(maxLen);
    }

    public XMLDoc getXMLDoc() {
        XMLParser p = XMLParserFactory.getFactory().get();
        p.setInputID(this.url);
        XMLDoc d = p.parseStream(this.getResponseStream());
        XMLParserFactory.getFactory().push(p);
        return d;
    }

    public void buffer() {
        if (this.bufferStream == null) {
            this.bufferStream = new ByteArrayIOFileStream(this.inStream, 12345678L);
        }
    }

    public JDFAttributeMap getHeaders() {
        JDFAttributeMap ret = new JDFAttributeMap();
        if (this.connection != null) {
            Map<String, List<String>> map = this.connection.getHeaderFields();
            for (Map.Entry<String, List<String>> e : map.entrySet()) {
                ret.put(e.getKey(), StringUtil.setvString(e.getValue()));
            }
        }
        return ret;
    }

    public String toString() {
        return "URLPart: " + this.contentType + " length=" + this.contentLength + " rc=" + this.rc + " URL=" + this.url + "\n" + (this.bufferStream == null ? " <not buffered>" : this.getResponseString(1234));
    }

    public URLConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isPush() {
        return false;
    }

    protected void finalize() throws Throwable {
        if (this.bufferStream != null) {
            this.bufferStream.close();
        }
        super.finalize();
    }

    public static boolean isReturnCodeOK(UrlPart p) {
        return UrlUtil.isReturnCodeOK(UrlPart.getReturnCode(p));
    }

    public static int getReturnCode(UrlPart p) {
        return p == null ? -1 : p.getResponseCode();
    }

    public String getHeader(String string) {
        return this.getHeaders().get(string);
    }

    public String getAuthorizationUser() {
        String authHeader = this.getAuthorizationHeader();
        return StringUtil.token(authHeader, 0, ":");
    }

    public String getAuthorizationPassword() {
        String authHeader = this.getAuthorizationHeader();
        return StringUtil.removeToken(authHeader, 0, ":");
    }

    public String getAuthorizationHeader() {
        String authHeader = this.getHeader("Authorization");
        return UrlUtil.getAuthorizationHeader(authHeader);
    }
}

