/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.MyLong;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.IPersistable;
import org.cip4.jdflib.util.thread.MyMutex;

public class DelayedPersist
extends Thread {
    private final HashMap<IPersistable, MyLong> persistQueue;
    private boolean stop = false;
    private static DelayedPersist theDelayed = null;
    private MyMutex waitMutex;
    private final Log log = LogFactory.getLog(this.getClass());

    private DelayedPersist() {
        super("DelayedPersist");
        this.persistQueue = new HashMap();
        this.waitMutex = new MyMutex();
        this.start();
    }

    public static DelayedPersist getDelayedPersist() {
        if (theDelayed == null) {
            theDelayed = new DelayedPersist();
        }
        return theDelayed;
    }

    public static DelayedPersist getCurrentDelayedPersist() {
        return theDelayed;
    }

    public static void shutDown() {
        if (theDelayed != null) {
            DelayedPersist tmp = theDelayed;
            theDelayed = null;
            tmp._shutDown();
        }
    }

    private void _shutDown() {
        this.log.info((Object)("shutting down " + String.valueOf(this)));
        this.stop = true;
        this.persistQueues();
        ThreadUtil.notifyAll(this.waitMutex);
        ThreadUtil.sleep(10);
        if (this.waitMutex != null) {
            this.log.info((Object)"waiting for persist of delayed persist");
            if (this.waitMutex != null) {
                ThreadUtil.wait(this.waitMutex, 120000);
            }
            this.log.info((Object)"finished waiting for persist of delayed persist");
        }
        theDelayed = null;
    }

    public void queueRunnable(Runnable r, long deltaTime) {
        this.queue(r == null ? null : new RunnablePersist(r), deltaTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(IPersistable persistable, long deltaTime) {
        if (persistable == null) {
            this.log.warn((Object)"Cannot queue null IPersistable");
            return;
        }
        HashMap<IPersistable, MyLong> hashMap = this.persistQueue;
        synchronized (hashMap) {
            MyLong l = this.persistQueue.get(persistable);
            long t = System.currentTimeMillis();
            if (l == null) {
                this.persistQueue.put(persistable, new MyLong(t + deltaTime));
            } else if (t + deltaTime < l.i) {
                l.i = t + deltaTime;
            }
        }
        ThreadUtil.notifyAll(this.waitMutex);
    }

    @Override
    public void run() {
        block3: {
            int tWait;
            this.log.info((Object)"starting queue persist loop");
            do {
                tWait = 10000;
                try {
                    tWait = this.persistQueues();
                }
                catch (Exception e) {
                    this.log.error((Object)"whazzup queueing delayedPersist ", (Throwable)e);
                }
                if (!this.stop) continue;
                this.log.info((Object)"end of queue persist loop");
                ThreadUtil.notifyAll(this.waitMutex);
                this.waitMutex = null;
                break block3;
            } while (tWait <= 0 || ThreadUtil.wait(this.waitMutex, tWait));
            this._shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int persistQueues() {
        long t0 = 424242L;
        if (this.persistQueue.size() == 0) {
            return (int)t0;
        }
        long t = System.currentTimeMillis();
        Vector<IPersistable> theList = new Vector<IPersistable>();
        HashMap<IPersistable, MyLong> hashMap = this.persistQueue;
        synchronized (hashMap) {
            Collection<IPersistable> v = ContainerUtil.getKeyArray(this.persistQueue);
            if (v == null) {
                return (int)t0;
            }
            for (IPersistable qp : v) {
                MyLong l = this.persistQueue.get(qp);
                if (l == null) {
                    this.persistQueue.remove(qp);
                    this.log.error((Object)("Snafu persisting mismatche key pair: " + qp.getClass().getCanonicalName()));
                    continue;
                }
                if (this.stop || l.i < t) {
                    theList.add(qp);
                    this.persistQueue.remove(qp);
                    continue;
                }
                if (l.i - t >= t0) continue;
                t0 = l.i - t;
            }
        }
        for (IPersistable qp : theList) {
            qp.persist();
        }
        if (theList.size() > 0) {
            t0 -= System.currentTimeMillis() - t;
            return this.persistQueues();
        }
        return (int)t0;
    }

    @Override
    public String toString() {
        return "DelayedPersist Stop=" + this.stop + " queue size: " + this.persistQueue.size();
    }

    private static class RunnablePersist
    implements IPersistable {
        private final Runnable runner;

        RunnablePersist(Runnable runner) {
            this.runner = runner;
        }

        @Override
        public boolean persist() {
            if (this.runner == null) {
                return false;
            }
            this.runner.run();
            return true;
        }

        public String toString() {
            return "RunablePersist [runner=" + String.valueOf(this.runner) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.runner == null ? 0 : this.runner.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RunnablePersist other = (RunnablePersist)obj;
            return ContainerUtil.equals(other, this);
        }
    }
}

