/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.MultiJobTaskQueue;
import org.cip4.jdflib.util.thread.OrderedTaskQueue;

public class MultiTaskQueue
extends OrderedTaskQueue {
    private int maxParallel = 0;
    private ThreadPoolExecutor executor;
    private final Vector<OrderedTaskQueue.TaskRunner> current = new Vector();
    int nThread;
    private static final Log log = LogFactory.getLog(MultiJobTaskQueue.class);
    private static int percentQueue = 100;

    public static int getPercentQueue() {
        return percentQueue;
    }

    public static void setPercentQueue(int percentQueue) {
        MultiTaskQueue.percentQueue = percentQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiTaskQueue getCreateQueue(String name, int maxParallel) {
        name = MultiTaskQueue.getThreadName(name);
        AtomicReference atomicReference = theMap;
        synchronized (atomicReference) {
            Map map = (Map)theMap.get();
            OrderedTaskQueue orderedTaskQueue = (OrderedTaskQueue)map.get(name);
            if (!(orderedTaskQueue instanceof MultiTaskQueue)) {
                orderedTaskQueue = new MultiTaskQueue(name);
                map.put(name, orderedTaskQueue);
            }
            MultiTaskQueue multiTaskQueue = (MultiTaskQueue)orderedTaskQueue;
            multiTaskQueue.setMaxParallel(maxParallel);
            theMap.set(map);
            return multiTaskQueue;
        }
    }

    public void setMaxParallel(int maxParallel) {
        int maxParallelTmp = maxParallel * percentQueue / 100;
        maxParallelTmp = Math.max(1, maxParallelTmp);
        if ((maxParallelTmp = Math.min(42, maxParallelTmp)) != this.maxParallel) {
            this.maxParallel = maxParallelTmp;
            if (this.executor != null) {
                this.executor.shutdown();
            }
            this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(maxParallelTmp, new MyThreadFactory());
        }
    }

    public int getCurrentRunning() {
        return this.current.size();
    }

    @Override
    public boolean interruptCurrent(int minAge) {
        ArrayList<OrderedTaskQueue.TaskRunner> currentCopy = new ArrayList<OrderedTaskQueue.TaskRunner>();
        currentCopy.addAll(this.current);
        boolean bRet = false;
        for (OrderedTaskQueue.TaskRunner next : currentCopy) {
            if (next.getRunTime() < (long)minAge) continue;
            this.interruptRunner(next);
            bRet = bRet || !this.current.contains(next);
        }
        return bRet;
    }

    public boolean interruptTask(Runnable theRunner) {
        ArrayList<OrderedTaskQueue.TaskRunner> currentCopy = new ArrayList<OrderedTaskQueue.TaskRunner>();
        currentCopy.addAll(this.current);
        boolean bRet = false;
        for (OrderedTaskQueue.TaskRunner next : currentCopy) {
            if (next.theTask != theRunner) continue;
            this.interruptRunner(next);
            bRet = !this.current.contains(next);
            break;
        }
        return bRet;
    }

    private void interruptRunner(OrderedTaskQueue.TaskRunner next) {
        int n = 1;
        if (next.myThread == null) {
            this.current.remove(next);
            log.info((Object)("Zapped idle " + String.valueOf(next)));
        } else {
            while (this.current.contains(next)) {
                next.interrupt();
                if (ThreadUtil.sleep(++n) && n <= 10) continue;
                break;
            }
        }
    }

    ArrayList<Runnable> getCurrent(int minAge) {
        ArrayList<OrderedTaskQueue.TaskRunner> currentCopy = new ArrayList<OrderedTaskQueue.TaskRunner>();
        currentCopy.addAll(this.current);
        ArrayList<Runnable> vReturn = new ArrayList<Runnable>();
        for (OrderedTaskQueue.TaskRunner next : currentCopy) {
            if (next.getRunTime() < (long)minAge) continue;
            vReturn.add(next.theTask);
        }
        return vReturn;
    }

    MultiTaskQueue(String name) {
        super(name);
        this.setMaxParallel(2);
        this.nThread = 1;
        super.start();
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getName() + " " + String.valueOf(this.idle) + " queue: " + String.valueOf(this.queue);
    }

    @Override
    void runTask(OrderedTaskQueue.TaskRunner r) {
        this.idle.set(0);
        NextRunner nr = new NextRunner(r);
        this.current.add(nr);
        this.executor.submit(nr);
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    @Override
    public void shutDown() {
        super.shutDown();
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    @Override
    public int executing() {
        return this.executor == null ? 0 : this.executor.getActiveCount();
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, MultiTaskQueue.this.getName() + "_" + MultiTaskQueue.this.nThread++);
            t.setDaemon(true);
            return t;
        }
    }

    private class NextRunner
    extends OrderedTaskQueue.TaskRunner {
        NextRunner(OrderedTaskQueue.TaskRunner r) {
            super(MultiTaskQueue.this, r.theTask);
            this.tQueue = r.tQueue;
            this.tStart = r.tStart;
            this.tEnd = r.tEnd;
        }

        @Override
        public void run() {
            super.run();
            MultiTaskQueue.this.current.remove(this);
            ThreadUtil.notifyAll(MultiTaskQueue.this.mutex);
            MultiTaskQueue.this.idle.set(0);
        }
    }
}

