/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.MyMutex;

public abstract class WaitTimeout<a>
implements Runnable {
    private MyMutex mutex;
    private long t0;
    private final int waitMillis;
    private final AtomicReference<a> theObject;
    private static final AtomicInteger threadNumber = new AtomicInteger(0);
    private Thread myThread = null;
    protected String baseName;

    protected abstract a handle();

    protected void setup() {
        this.baseName = "WaitThread";
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public int getWaitMillis() {
        return this.waitMillis;
    }

    public WaitTimeout(int millis) {
        this.waitMillis = millis;
        this.theObject = new AtomicReference();
        this.setup();
        this.mutex = new MyMutex();
        this.myThread = new Thread((Runnable)this, this.baseName + threadNumber.incrementAndGet());
        this.myThread.setDaemon(true);
        this.t0 = System.currentTimeMillis();
    }

    public final void start() {
        this.myThread.start();
    }

    @Override
    public final void run() {
        this.t0 = System.currentTimeMillis();
        this.theObject.set(this.handle());
        this.myThread = null;
        MyMutex tmp = this.mutex;
        this.mutex = null;
        ThreadUtil.notifyAll(tmp);
    }

    public final a getWaitedObject() {
        long t1 = System.currentTimeMillis();
        if (t1 - this.t0 < (long)this.waitMillis && this.mutex != null) {
            long dt = (long)this.waitMillis - (t1 - this.t0);
            ThreadUtil.wait(this.mutex, (int)dt);
            if (this.mutex != null && this.myThread != null) {
                this.myThread.interrupt();
            }
            this.mutex = null;
        }
        return this.theObject.get();
    }

    public final a peekWaitedObject() {
        return this.theObject.get();
    }

    public String toString() {
        return "WaitTimeout [t0=" + this.t0 + ", waitMillis=" + this.waitMillis + ", theObject=" + String.valueOf(this.theObject) + "]";
    }
}

