/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.printtalk;

import java.util.Currency;
import java.util.Locale;
import java.util.Vector;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.NumberFormatter;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.printtalk.AbstractPrintTalk;
import org.cip4.printtalk.Additional;
import org.cip4.printtalk.Pricing;

public class Price
extends AbstractPrintTalk {
    public static String ELEMENT_PRICE = "Price";
    public static String ATTR_PRICE = "Price";
    public static String ATTR_UNITPRICE = "UnitPrice";
    public static String ATTR_AMOUNT = "Amount";
    public static String ATTR_LINEID = "LineID";
    public static String ATTR_LINEIDREFS = "LineIDRefs";
    static int currencyPrecision = Currency.getInstance(Locale.getDefault()).getDefaultFractionDigits();

    public static int getCurrencyPrecision() {
        return currencyPrecision;
    }

    public static void setCurrencyPrecision(int currencyPrecision) {
        Price.currencyPrecision = currencyPrecision;
    }

    public Price(KElement theElement) {
        super(theElement);
    }

    public Pricing getParentPricing() {
        return this.theElement.getParentNode_KElement() == null ? null : new Pricing(this.theElement.getParentNode_KElement());
    }

    public void setPrice(double price) {
        String amount = new NumberFormatter().formatDouble(price, currencyPrecision);
        this.setAttribute(ATTR_PRICE, amount);
    }

    public double getPrice() {
        return this.theElement.getRealAttribute(ATTR_PRICE, null, 0.0);
    }

    public void setUnitPrice(double price) {
        String amount = new NumberFormatter().formatDouble(price, currencyPrecision);
        this.setAttribute(ATTR_UNITPRICE, amount);
    }

    public double getUnitPrice() {
        return this.theElement.getRealAttribute(ATTR_UNITPRICE, null, 0.0);
    }

    public void setAmount(double price) {
        String amount = new NumberFormatter().formatDouble(price);
        this.setAttribute(ATTR_AMOUNT, amount);
    }

    public double getAmount() {
        return this.theElement.getRealAttribute(ATTR_AMOUNT, null, 0.0);
    }

    public void setLineID(String lineID) {
        this.theElement.setAttribute(ATTR_LINEID, lineID);
    }

    public boolean isReferenced() {
        String lineID = this.getLineID();
        if (lineID == null) {
            return false;
        }
        Pricing parent = this.getParentPricing();
        if (parent == null) {
            return false;
        }
        Vector<Price> v = parent.getPriceVector();
        if (v == null) {
            this.log.error((Object)"whazzup - my parent ain't got me...");
            return false;
        }
        for (Price p : v) {
            if (this.equals(p) || !p.getLineIDRefs().contains((Object)lineID)) continue;
            return true;
        }
        return false;
    }

    public void setLineIDRefs(VString lineIDRefs) {
        this.theElement.setAttribute(ATTR_LINEIDREFS, lineIDRefs, null);
    }

    public void addLineIDRef(String lineIDRef) {
        this.theElement.appendAttribute(ATTR_LINEIDREFS, lineIDRef, null, " ", true);
    }

    public void refPrice(Price subPrice) {
        if (subPrice == null) {
            return;
        }
        VString v = this.getLineIDRefs();
        v.appendUnique(subPrice.getLineID());
        this.theElement.setAttribute(ATTR_LINEIDREFS, v, null);
    }

    public VString getLineIDRefs() {
        String s = this.theElement.getAttribute(ATTR_LINEIDREFS, null, null);
        return StringUtil.tokenize((String)s, null, (boolean)false);
    }

    public String getLineID() {
        return this.theElement.getAttribute(ATTR_LINEID, null, null);
    }

    public Additional addAdditional(double amount, double price) {
        Additional a = new Additional(this.theElement.appendElement(Additional.ELEMENT_Additional));
        a.setAmount(amount);
        a.setPrice(price);
        return a;
    }

    public Additional getAdditional(int i) {
        KElement a = this.theElement.getElement(Additional.ELEMENT_Additional, null, i);
        return a == null ? null : new Additional(a);
    }
}

