/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.printtalk;

import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.printtalk.AbstractPrintTalk;
import org.cip4.printtalk.BusinessObject;
import org.cip4.printtalk.HeaderBase;

public class PrintTalk
extends AbstractPrintTalk {
    public static final String PRINT_TALK = "PrintTalk";
    public static final String MIME_PRINT_TALK = "application/vnd.cip4-ptk+xml";
    private int version = 3;

    public static PrintTalk getPrintTalk(KElement theElement) {
        if (theElement == null || !PRINT_TALK.equalsIgnoreCase(theElement.getLocalName())) {
            return null;
        }
        return new PrintTalk(theElement);
    }

    public PrintTalk(KElement theElement) {
        super(theElement);
    }

    public PrintTalk() {
        super(null);
        XMLDoc doc = new XMLDoc(PRINT_TALK, this.getNamespaceURI());
        doc = new JDFDoc(doc);
        ((DocumentJDFImpl)doc.getMemberDocument()).bInitOnCreate = true;
        this.setRoot(doc.getRoot());
        this.init();
    }

    public static String getNamespaceURI(int version) {
        if (version == 0) {
            version = 13;
        } else if (version <= 2) {
            version *= 10;
        }
        return "http://www.printtalk.org/schema_" + version;
    }

    public String getNamespaceURI() {
        return PrintTalk.getNamespaceURI(this.version);
    }

    @Override
    public void init() {
        super.init();
        this.theElement.setAttribute("version", this.getVersionString("."));
        String dateTimeISO = new JDFDate().getDateTimeISO();
        this.theElement.setAttribute("Timestamp", dateTimeISO);
        this.theElement.setAttribute("payloadID", JDFAudit.software() + dateTimeISO);
    }

    private String getVersionString(String sep) {
        return this.getVersion() < 10 ? "1" + sep + this.getVersion() : "2" + sep + (this.getVersion() - 20);
    }

    public void setHeader(Header header, String name, String value) {
        String type = header.name();
        this.getCreateXPathElement("Header/" + type + "/Credential[@domain=\"" + name + "\"]").getCreateElement("Identity").setText(value);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public JDFDate getTimestamp() {
        return this.theElement == null ? null : JDFDate.createDate((String)this.theElement.getAttribute("Timestamp", null, null));
    }

    public BusinessObject appendRequest(EnumBusinessObject bo, PrintTalk ref) throws IllegalArgumentException {
        BusinessObject oldBO = this.getBusinessObject();
        if (oldBO != null) {
            throw new IllegalArgumentException("BusinessObject already exists: " + oldBO.theElement.getLocalName());
        }
        String boName = bo.name();
        KElement e = this.theElement.getCreateElement("Request").appendElement(boName);
        BusinessObject businessObject = BusinessObject.getBusinessObject(e);
        businessObject.init();
        businessObject.setRef(ref);
        return businessObject;
    }

    public BusinessObject getRequest() {
        return this.getBusinessObject();
    }

    public BusinessObject getBusinessObject() {
        KElement request = this.getElement("Request");
        KElement oldBO = request == null ? null : request.getElement(null);
        return oldBO == null ? null : BusinessObject.getBusinessObject(oldBO);
    }

    public HeaderBase getHeader(HeaderBase.EnumHeaderType headerType) {
        KElement request = headerType == null ? null : this.getElement("Header");
        KElement header = request == null ? null : request.getElement(headerType.name());
        return header == null ? null : new HeaderBase(header);
    }

    @Override
    public PrintTalk getPrintTalk() {
        return this;
    }

    public static enum EnumBusinessObject {
        RFQ,
        Quotation,
        PurchaseOrder,
        Confirmation,
        Cancellation,
        Refusal,
        OrderStatusRequest,
        OrderStatusResponse,
        ProofApprovalRequest,
        ProofApprovalResponse,
        Invoice,
        ReturnJob,
        StockLevelRequest,
        StockLevelResponse;

    }

    public static enum Header {
        From,
        To,
        Sender;

    }
}

