/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.printtalk;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.printtalk.AbstractPrintTalk;
import org.cip4.printtalk.Price;
import org.cip4.printtalk.StockLevelRequest;

public class StockLevel
extends AbstractPrintTalk
implements IMatches {
    public static String ELEMENT_STOCKLEVEL = "StockLevel";
    public static String ATTR_PRODUCTIONDURATION = "ProductionDuration";
    public static String ATTR_LOT = "Lot";

    public StockLevel(KElement theElement) {
        super(theElement);
    }

    public boolean matches(Object stockLevelRequest) {
        if (stockLevelRequest == null) {
            return true;
        }
        if (stockLevelRequest instanceof String) {
            return StringUtil.matchesSimple((String)this.getProductID(), (String)((String)stockLevelRequest));
        }
        if (!(stockLevelRequest instanceof StockLevelRequest)) {
            return false;
        }
        StockLevel stockLevelReq = (StockLevel)stockLevelRequest;
        String productFilter = stockLevelReq.getProductID();
        return StringUtil.matchesSimple((String)this.getProductID(), (String)productFilter);
    }

    public void setProductID(String productID) {
        this.setAttribute("ProductID", productID);
    }

    public String getProductID() {
        return this.getAttribute("ProductID");
    }

    public String getLot() {
        return this.getAttribute(ATTR_LOT);
    }

    public void setLot(String lot) {
        this.setAttribute(ATTR_LOT, lot);
    }

    public int getAmount() {
        return StringUtil.parseInt((String)this.getAttribute("Amount"), (int)-1);
    }

    public void setAmount(int amount) {
        this.setAttribute("Amount", "" + amount);
    }

    public JDFDuration getProductionDuration() {
        return JDFDuration.createDuration((String)this.getAttribute(ATTR_PRODUCTIONDURATION));
    }

    public void setProductionDuration(JDFDuration dur) {
        this.setAttribute(ATTR_PRODUCTIONDURATION, dur == null ? null : dur.getDurationISO());
    }

    public Price getPrice() {
        KElement element = this.getElement(Price.ELEMENT_PRICE);
        return element == null ? null : new Price(element);
    }

    public Price getCreatePrice() {
        KElement element = this.getCreateElement(Price.ELEMENT_PRICE);
        return element == null ? null : new Price(element);
    }
}

