/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.printtalk;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.XJDF20;
import org.cip4.printtalk.AbstractPrintTalk;
import org.cip4.printtalk.Cancellation;
import org.cip4.printtalk.Confirmation;
import org.cip4.printtalk.Invoice;
import org.cip4.printtalk.OrderStatusRequest;
import org.cip4.printtalk.OrderStatusResponse;
import org.cip4.printtalk.PrintTalk;
import org.cip4.printtalk.ProofApprovalRequest;
import org.cip4.printtalk.ProofApprovalResponse;
import org.cip4.printtalk.PurchaseOrder;
import org.cip4.printtalk.Quotation;
import org.cip4.printtalk.RFQ;
import org.cip4.printtalk.Refusal;
import org.cip4.printtalk.ReturnJob;
import org.cip4.printtalk.StockLevelRequest;
import org.cip4.printtalk.StockLevelResponse;

public abstract class BusinessObject
extends AbstractPrintTalk {
    public static final String ATTR_BUSINESSREFID = "BusinessRefID";
    public static final String ATTR_BUSINESSID = "BusinessID";
    public static String ATTR_CURRENCY = "Currency";
    public static String ATTR_EXPIRES = "Expires";

    public KElement getCreateJDFRoot(String rootName, int iSkip) {
        String schemaURL = JDFElement.getSchemaURL();
        if ("XJDF".equals(rootName)) {
            schemaURL = XJDF20.getSchemaURL();
        }
        KElement element = this.theElement.getCreateElement(rootName, schemaURL, iSkip);
        element.init();
        return element;
    }

    public BusinessObject(KElement theElement) {
        super(theElement);
    }

    @Override
    public void init() {
        super.init();
        this.setBusinessID(this.theElement.getLocalName() + KElement.uniqueID((int)0));
    }

    public String getBusinessID() {
        return this.getAttribute(ATTR_BUSINESSID);
    }

    public void setBusinessID(String id) {
        this.setAttribute(ATTR_BUSINESSID, id);
    }

    public String getBusinessRefID() {
        return this.getAttribute(ATTR_BUSINESSREFID, null);
    }

    public void setBusinessRefID(String id) {
        this.theElement.setAttribute(ATTR_BUSINESSREFID, id);
    }

    public void setRef(PrintTalk ref) {
        BusinessObject boRef;
        BusinessObject businessObject = boRef = ref == null ? null : ref.getBusinessObject();
        if (ref != null) {
            this.setBusinessRefID(boRef.getBusinessID());
        }
    }

    static BusinessObject getBusinessObject(KElement e) {
        BusinessObject businessObject;
        if (e == null) {
            return null;
        }
        String boName = e.getLocalName();
        if (PrintTalk.EnumBusinessObject.RFQ.name().equals(boName)) {
            businessObject = new RFQ(e);
        } else if (PrintTalk.EnumBusinessObject.Quotation.name().equals(boName)) {
            businessObject = new Quotation(e);
        } else if (PrintTalk.EnumBusinessObject.PurchaseOrder.name().equals(boName)) {
            businessObject = new PurchaseOrder(e);
        } else if (PrintTalk.EnumBusinessObject.Confirmation.name().equals(boName)) {
            businessObject = new Confirmation(e);
        } else if (PrintTalk.EnumBusinessObject.Cancellation.name().equals(boName)) {
            businessObject = new Cancellation(e);
        } else if (PrintTalk.EnumBusinessObject.Refusal.name().equals(boName)) {
            businessObject = new Refusal(e);
        } else if (PrintTalk.EnumBusinessObject.OrderStatusRequest.name().equals(boName)) {
            businessObject = new OrderStatusRequest(e);
        } else if (PrintTalk.EnumBusinessObject.OrderStatusResponse.name().equals(boName)) {
            businessObject = new OrderStatusResponse(e);
        } else if (PrintTalk.EnumBusinessObject.ProofApprovalRequest.name().equals(boName)) {
            businessObject = new ProofApprovalRequest(e);
        } else if (PrintTalk.EnumBusinessObject.ProofApprovalResponse.name().equals(boName)) {
            businessObject = new ProofApprovalResponse(e);
        } else if (PrintTalk.EnumBusinessObject.Invoice.name().equals(boName)) {
            businessObject = new Invoice(e);
        } else if (PrintTalk.EnumBusinessObject.ReturnJob.name().equals(boName)) {
            businessObject = new ReturnJob(e);
        } else if (PrintTalk.EnumBusinessObject.StockLevelRequest.name().equals(boName)) {
            businessObject = new StockLevelRequest(e);
        } else if (PrintTalk.EnumBusinessObject.StockLevelResponse.name().equals(boName)) {
            businessObject = new StockLevelResponse(e);
        } else {
            throw new IllegalArgumentException("BusinessObject type not yet implemented: " + boName);
        }
        return businessObject;
    }
}

