/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.printtalk;

import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.printtalk.AbstractPrintTalk;
import org.cip4.printtalk.BusinessObject;
import org.cip4.printtalk.HeaderBase;

public class PrintTalk
extends AbstractPrintTalk {
    public static final String REQUEST = "Request";
    public static final String RESPONSE = "Response";
    public static final String PRINT_TALK = "PrintTalk";
    public static final String AGENT_ID = "jdf:AgentID";
    public static final String MIME_PRINT_TALK = "application/vnd.cip4-ptk+xml";
    private static int defaultVersion = 15;
    private int version = 0;

    public static int getDefaultVersion() {
        return defaultVersion;
    }

    public static void setDefaultVersion(int defaultVersion) {
        PrintTalk.defaultVersion = defaultVersion;
    }

    public static PrintTalk getPrintTalk(KElement theElement) {
        if (theElement == null || !PRINT_TALK.equalsIgnoreCase(theElement.getLocalName())) {
            return null;
        }
        return new PrintTalk(theElement);
    }

    public PrintTalk(KElement theElement) {
        super(theElement);
    }

    public PrintTalk() {
        super(null);
        XMLDoc doc = new XMLDoc(PRINT_TALK, this.getNamespaceURI());
        doc = new JDFDoc(doc);
        ((DocumentJDFImpl)doc.getMemberDocument()).bInitOnCreate = true;
        this.setRoot(doc.getRoot());
        this.init();
    }

    public static String getNamespaceURI(int version) {
        if (version == 0) {
            version = defaultVersion;
        }
        return "http://www.printtalk.org/schema_" + version;
    }

    public String getNamespaceURI() {
        return PrintTalk.getNamespaceURI(this.version);
    }

    @Override
    public void init() {
        super.init();
        this.theElement.setAttribute("version", this.getVersionString("."));
        String dateTimeISO = new JDFDate().getDateTimeISO();
        this.theElement.setAttribute("Timestamp", dateTimeISO);
        this.theElement.setAttribute("payloadID", JDFAudit.software() + dateTimeISO);
    }

    private String getVersionString(String sep) {
        return this.getVersion() < 10 ? "1" + sep + this.getVersion() : "2" + sep + (this.getVersion() - 20);
    }

    public void setCredential(HeaderBase.EnumHeaderType headerType, String domain, String identity) {
        HeaderBase header = this.getCreateHeader(headerType);
        header.setCredential(domain, identity);
    }

    public String getCredentialIdentity(HeaderBase.EnumHeaderType headerType, String domain) {
        HeaderBase header = this.getHeader(headerType);
        return header == null ? null : header.getCredentialIdentity(domain);
    }

    public HeaderBase getCreateHeader(HeaderBase.EnumHeaderType headerType) {
        HeaderBase header = this.getHeader(headerType);
        if (header == null && headerType != null) {
            header = new HeaderBase(this.getCreateXPathElement("Header/" + headerType.name()));
        }
        return header;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public JDFDate getTimestamp() {
        return this.theElement == null ? null : JDFDate.createDate((String)this.theElement.getAttribute("Timestamp", null, null));
    }

    public BusinessObject appendRequest(EnumBusinessObject bo, PrintTalk ref) throws IllegalArgumentException {
        BusinessObject oldBO = this.getBusinessObject();
        if (oldBO != null || this.getElement(RESPONSE) != null) {
            throw new IllegalArgumentException("BusinessObject already exists: " + oldBO.theElement.getLocalName());
        }
        String boName = bo.name();
        KElement e = this.theElement.getCreateElement(REQUEST).appendElement(boName);
        BusinessObject businessObject = this.initBO(ref, e);
        return businessObject;
    }

    public BusinessObject appendResponse(EnumBusinessObject bo, PrintTalk ref) throws IllegalArgumentException {
        BusinessObject oldBO = this.getBusinessObject();
        if (oldBO != null || this.getElement(REQUEST) != null) {
            throw new IllegalArgumentException("BusinessObject already exists: " + oldBO.theElement.getLocalName());
        }
        String boName = bo.name();
        KElement e = this.theElement.getCreateElement(RESPONSE).appendElement(boName);
        BusinessObject businessObject = this.initBO(ref, e);
        return businessObject;
    }

    private BusinessObject initBO(PrintTalk ref, KElement e) {
        BusinessObject businessObject = BusinessObject.getBusinessObject(e);
        businessObject.init();
        businessObject.setRef(ref);
        return businessObject;
    }

    public BusinessObject getBusinessObject() {
        KElement request = this.getElement(REQUEST);
        if (request == null) {
            request = this.getElement(RESPONSE);
        }
        KElement oldBO = request == null ? null : request.getFirstChildElement();
        return BusinessObject.getBusinessObject(oldBO);
    }

    public HeaderBase getHeader(HeaderBase.EnumHeaderType headerType) {
        KElement request = headerType == null ? null : this.getElement("Header");
        KElement header = request == null ? null : request.getElement(headerType.name());
        return header == null ? null : new HeaderBase(header);
    }

    @Override
    public PrintTalk getPrintTalk() {
        return this;
    }

    public static enum EnumBusinessObject {
        RFQ,
        Quotation,
        PurchaseOrder,
        Confirmation,
        Cancellation,
        Refusal,
        OrderStatusRequest,
        OrderStatusResponse,
        ProofApprovalRequest,
        ProofApprovalResponse,
        Invoice,
        ReturnJob,
        StockLevelRequest,
        StockLevelResponse;

    }
}

