/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf;

import org.cip4.lib.xjdf.schema.jdf.Address;
import org.cip4.lib.xjdf.schema.jdf.ComChannel;
import org.cip4.lib.xjdf.schema.jdf.Company;
import org.cip4.lib.xjdf.schema.jdf.Contact;
import org.cip4.lib.xjdf.schema.jdf.FileSpec;
import org.cip4.lib.xjdf.schema.jdf.GeneralID;
import org.cip4.lib.xjdf.schema.jdf.ObjectFactory;
import org.cip4.lib.xjdf.schema.jdf.Product;
import org.cip4.lib.xjdf.schema.jdf.RunList;

public class XJdfNodeFactory
extends ObjectFactory {
    private XJdfNodeFactory() {
    }

    public static XJdfNodeFactory getInstance() {
        return new XJdfNodeFactory();
    }

    public GeneralID createGeneralID(String idUsage, String idValue) {
        GeneralID generalId = XJdfNodeFactory.getInstance().createGeneralID();
        generalId.setIDUsage(idUsage);
        generalId.setIDValue(idValue);
        return generalId;
    }

    public RunList createRunList(String fileSpecUrl) {
        RunList runList = super.createRunList();
        FileSpec fileSpec = this.createFileSpec();
        fileSpec.setURL(fileSpecUrl);
        runList.setFileSpec(fileSpec);
        return runList;
    }

    public Product createProduct(int amount) {
        Product product = super.createProduct();
        product.setAmount(amount);
        return product;
    }

    public ComChannel createComChannel(String channelType, String channelUsage, String locator) {
        ComChannel comChannel = super.createComChannel();
        comChannel.setChannelType(channelType);
        comChannel.getChannelUsages().add(channelUsage);
        comChannel.setLocator(locator);
        return comChannel;
    }

    public Address createAddress(String street, String postalCode, String city, String country) {
        Address address = super.createAddress();
        address.setStreet(street);
        address.setPostalCode(postalCode);
        address.setCity(city);
        address.setCountry(country);
        return address;
    }

    public Company createCompany(String name, String unit) {
        Company company = super.createCompany();
        company.setOrganizationName(name);
        company.setOrganizationalUnit(unit);
        return company;
    }

    public Contact createContact(String ... contactTypes) {
        Contact contact = super.createContact();
        for (int i = 0; contactTypes != null && i < contactTypes.length; ++i) {
            contact.getContactTypes().add(contactTypes[i]);
        }
        return contact;
    }
}

