/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractBuilder;
import org.cip4.lib.xjdf.schema.jdf.GeneralID;
import org.cip4.lib.xjdf.schema.jdf.Parameter;
import org.cip4.lib.xjdf.schema.jdf.ParameterSet;
import org.cip4.lib.xjdf.schema.jdf.ParameterType;
import org.cip4.lib.xjdf.schema.jdf.Part;
import org.cip4.lib.xjdf.schema.jdf.Product;
import org.cip4.lib.xjdf.schema.jdf.XJDF;
import org.cip4.lib.xjdf.xml.XmlConstants;

public class XJdfBuilder
extends AbstractBuilder<XJDF> {
    private final Map<String, ParameterSet> mapParameterSets = new HashMap<String, ParameterSet>(20);

    private XJdfBuilder() {
        super(XJdfNodeFactory.getInstance().createXJDF());
    }

    public static XJdfBuilder newInstance() {
        return new XJdfBuilder();
    }

    public XJDF getxJdf() {
        return (XJDF)this.getNode();
    }

    public XJdfBuilder addGeneralID(GeneralID generalId) {
        this.getxJdf().getGeneralIDs().add(generalId);
        return this;
    }

    public XJdfBuilder addProduct(Product product) {
        if (this.getxJdf().getProductList() == null) {
            this.getxJdf().setProductList(XJdfNodeFactory.getInstance().createProductList());
        }
        this.getxJdf().getProductList().getProducts().add(product);
        return this;
    }

    public XJdfBuilder addParameter(ParameterType parameter) {
        return this.addParameter(parameter, null);
    }

    public XJdfBuilder addParameter(ParameterType parameter, Part part) {
        ParameterSet parameterSet;
        String paramName = parameter.getClass().getSimpleName();
        Parameter param = XJdfNodeFactory.getInstance().createParameter();
        QName qname = new QName(XmlConstants.NAMESPACE_JDF20, paramName);
        JAXBElement obj = new JAXBElement(qname, parameter.getClass(), null, (Object)parameter);
        param.getParameterTypes().add((JAXBElement<? extends ParameterType>)obj);
        if (part != null) {
            param.getParts().add(part);
        }
        if (this.mapParameterSets.containsKey(paramName)) {
            parameterSet = this.mapParameterSets.get(paramName);
        } else {
            parameterSet = XJdfNodeFactory.getInstance().createParameterSet();
            parameterSet.setName(paramName);
            this.getxJdf().getSetTypes().add(XJdfNodeFactory.getInstance().createParameterSet(parameterSet));
            this.mapParameterSets.put(paramName, parameterSet);
        }
        parameterSet.getParameters().add(param);
        return this;
    }
}

