/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class ConversionUtil {
    private static final String patternUTC = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String patternGlobal = "yyyy-MM-dd'T'HH:mm:ssXXX";

    private ConversionUtil() {
    }

    public static String date2String(Calendar calendar) {
        SimpleDateFormat dateFormat = calendar.getTimeZone().getRawOffset() == 0 ? new SimpleDateFormat(patternUTC) : new SimpleDateFormat(patternGlobal);
        dateFormat.setTimeZone(calendar.getTimeZone());
        String result = dateFormat.format(calendar.getTime());
        return result;
    }

    public static Calendar string2Date(String strDate) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(patternGlobal);
        dateFormat.parse(strDate);
        Calendar result = dateFormat.getCalendar();
        String[] ids = TimeZone.getAvailableIDs(result.get(15));
        result.setTimeZone(TimeZone.getTimeZone(ids[0]));
        return result;
    }

    public static float mm2Dtp(float millimeter) {
        return millimeter / 25.4f * 72.0f;
    }

    public static float dtp2Mm(float dtp) {
        return dtp / 72.0f * 25.4f;
    }

    public static float dtp2MmS(String strDtp) {
        float val = Float.valueOf(strDtp).floatValue();
        return ConversionUtil.dtp2Mm(val);
    }

    public static String mm2DtpS(float millimeter) {
        float dtp = ConversionUtil.mm2Dtp(millimeter);
        return Float.toString(dtp);
    }
}

