/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator;

import org.cip4.lib.xjdf.schema.DeviceInfo;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.validator.ValidationResult;
import org.cip4.lib.xjdf.validator.Validator;

public class DeviceInfoValidator
implements Validator<DeviceInfo> {
    @Override
    public final ValidationResult validate(DeviceInfo deviceInfo) {
        ValidationResult result = new ValidationResult(new String[0]);
        this.validateFileSpec(deviceInfo, result);
        this.validateDeviceID(deviceInfo, result);
        this.validateIdleStartTime(deviceInfo, result);
        return result;
    }

    private void validateIdleStartTime(DeviceInfo deviceInfo, ValidationResult validationResult) {
        if (null != deviceInfo.getIdleStartTime() && null != deviceInfo.getJobPhase() && !deviceInfo.getJobPhase().isEmpty()) {
            validationResult.append("//DeviceInfo/@IdleStartTime SHALL NOT be specified if JobPhase Elements are present in the DeviceInfo");
        }
    }

    private void validateFileSpec(DeviceInfo deviceInfo, ValidationResult validationResult) {
        FileSpec fileSpec = deviceInfo.getFileSpec();
        if (null != fileSpec && !"Schema".equals(fileSpec.getResourceUsage())) {
            validationResult.append(String.format("Element DeviceInfo may only contain FileSpec with @ResourceUsage='Schema', but @ResourceUsage='%s' was given", fileSpec.getResourceUsage()));
        }
    }

    private void validateDeviceID(DeviceInfo deviceInfo, ValidationResult validationResult) {
        if (null != deviceInfo.getDeviceID() && null != deviceInfo.getDevice() && !deviceInfo.getDeviceID().equals(deviceInfo.getDevice().getDeviceID())) {
            validationResult.append(String.format("DeviceInfo/@DeviceID ('%s') SHALL match DeviceInfo/Device/@DeviceID ('%s') if Device is\nspecified in this DeviceInfo.", deviceInfo.getDeviceID(), deviceInfo.getDevice().getDeviceID()));
        }
    }
}

