/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator;

import org.cip4.lib.xjdf.schema.DeliveryParams;
import org.cip4.lib.xjdf.schema.Parameter;
import org.cip4.lib.xjdf.schema.ParameterSet;
import org.cip4.lib.xjdf.validator.DeliveryParamsValidator;
import org.cip4.lib.xjdf.validator.ValidationResult;
import org.cip4.lib.xjdf.validator.Validator;

public class ParameterSetValidator
implements Validator<ParameterSet> {
    private final Validator<DeliveryParams> deliveryParamsValidator;

    public ParameterSetValidator() {
        this(new DeliveryParamsValidator());
    }

    public ParameterSetValidator(Validator<DeliveryParams> deliveryParamsValidator) {
        this.deliveryParamsValidator = deliveryParamsValidator;
    }

    @Override
    public final ValidationResult validate(ParameterSet parameterSet) {
        ValidationResult result = new ValidationResult(new String[0]);
        if (null == parameterSet.getName()) {
            result.append("Attribute //ParameterSet/@Name may not be null.");
        } else if ("".equals(parameterSet.getName())) {
            result.append("Attribute //ParameterSet/@Name may not be empty.");
        } else {
            String parameterSetName = parameterSet.getName();
            for (Parameter parameter : parameterSet.getParameter()) {
                String parameterName = parameter.getParameterType().getName().getLocalPart();
                if (parameterName.equals(parameterSetName)) continue;
                result.append(String.format("ParameterSet with @Name='%s' may only contain Parameters of type '%s', but '%s' was found.", parameterSetName, parameterSetName, parameterName));
            }
            switch (parameterSetName) {
                case "DeliveryParams": {
                    for (Parameter parameter : parameterSet.getParameter()) {
                        result.append(this.deliveryParamsValidator.validate((DeliveryParams)parameter.getParameterType().getValue()));
                    }
                    break;
                }
            }
        }
        return result;
    }
}

