/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator;

import org.cip4.lib.xjdf.schema.FoldingIntent;
import org.cip4.lib.xjdf.schema.Intent;
import org.cip4.lib.xjdf.schema.ParameterSet;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.validator.FoldingIntentValidator;
import org.cip4.lib.xjdf.validator.ParameterSetValidator;
import org.cip4.lib.xjdf.validator.ValidationResult;
import org.cip4.lib.xjdf.validator.Validator;

public class XjdfValidator
implements Validator<XJDF> {
    private final Validator<FoldingIntent> foldingIntentValidator;
    private final Validator<ParameterSet> parameterSetValidator;

    public XjdfValidator() {
        this(new FoldingIntentValidator(), new ParameterSetValidator());
    }

    public XjdfValidator(Validator<FoldingIntent> foldingIntentValidator, Validator<ParameterSet> parameterSetValidator) {
        this.foldingIntentValidator = foldingIntentValidator;
        this.parameterSetValidator = parameterSetValidator;
    }

    @Override
    public final ValidationResult validate(XJDF xjdf) {
        ValidationResult result = new ValidationResult(new String[0]);
        if (null != xjdf.getProductList()) {
            for (Product product : xjdf.getProductList().getProduct()) {
                for (Intent intent : product.getIntent()) {
                    if (!(intent.getIntentType().getValue() instanceof FoldingIntent)) continue;
                    result.append(this.foldingIntentValidator.validate((FoldingIntent)intent.getIntentType().getValue()));
                }
            }
        }
        for (ParameterSet parameterSet : xjdf.getParameterSet()) {
            result.append(this.parameterSetValidator.validate(parameterSet));
        }
        return result;
    }
}

