/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.util;

import java.util.List;
import java.util.UUID;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.ResourceType;
import org.cip4.lib.xjdf.schema.SetType;
import org.cip4.lib.xjdf.util.Assets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Resources
extends Assets<ResourceSet, Resource, ResourceType> {
    public Resources(@NotNull List<? extends SetType> assetSets) {
        super(assetSets);
    }

    @Override
    @NotNull
    <V extends ResourceType> Resource createAsset(@NotNull V resourceType, @Nullable Part partition) {
        Resource resource = this.getNodeFactory().createResource(resourceType, partition);
        if (null == resource.getID()) {
            resource.setID(resource.getResourceType().getName().getLocalPart() + "_" + UUID.randomUUID());
        }
        return resource;
    }

    @Override
    @NotNull
    final String getAssetName(@NotNull Resource resource) {
        return resource.getResourceType().getName().getLocalPart();
    }

    @Override
    @NotNull
    final ResourceSet createSet() {
        return new ResourceSet();
    }

    @Override
    final void addAssets(@NotNull ResourceSet resourceSet, @NotNull Resource asset) {
        resourceSet.getResource().add(asset);
    }
}

