/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator;

import java.util.List;
import org.cip4.lib.xjdf.schema.DeviceInfo;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.validator.ValidationResult;
import org.cip4.lib.xjdf.validator.Validator;

public class DeviceInfoValidator
implements Validator<DeviceInfo> {
    @Override
    public final ValidationResult validate(DeviceInfo deviceInfo) {
        ValidationResult result = new ValidationResult(new String[0]);
        this.validateFileSpec(deviceInfo, result);
        this.validateIdleStartTime(deviceInfo, result);
        return result;
    }

    private void validateIdleStartTime(DeviceInfo deviceInfo, ValidationResult validationResult) {
        if (null != deviceInfo.getIdleStartTime() && null != deviceInfo.getJobPhase() && !deviceInfo.getJobPhase().isEmpty()) {
            validationResult.append("//DeviceInfo/@IdleStartTime SHALL NOT be specified if JobPhase Elements are present in the DeviceInfo");
        }
    }

    private void validateFileSpec(DeviceInfo deviceInfo, ValidationResult validationResult) {
        List<FileSpec> fileSpecs = deviceInfo.getFileSpec();
        for (FileSpec fileSpec : fileSpecs) {
            if ("Schema".equals(fileSpec.getResourceUsage()) || "CurrentSchema".equals(fileSpec.getResourceUsage())) continue;
            validationResult.append(String.format("Element DeviceInfo may only contain FileSpec with @ResourceUsage='Schema', but @ResourceUsage='%s' was given", fileSpec.getResourceUsage()));
        }
    }
}

