/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator;

import org.cip4.lib.xjdf.schema.FoldingIntent;
import org.cip4.lib.xjdf.schema.Intent;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.validator.FoldingIntentValidator;
import org.cip4.lib.xjdf.validator.ResourceSetValidator;
import org.cip4.lib.xjdf.validator.ValidationResult;
import org.cip4.lib.xjdf.validator.Validator;

public class XjdfValidator
implements Validator<XJDF> {
    private final Validator<FoldingIntent> foldingIntentValidator;
    private final Validator<ResourceSet> resourceSetValidator;

    public XjdfValidator() {
        this(new FoldingIntentValidator(), new ResourceSetValidator());
    }

    public XjdfValidator(Validator<FoldingIntent> foldingIntentValidator, Validator<ResourceSet> resourceSetValidator) {
        this.foldingIntentValidator = foldingIntentValidator;
        this.resourceSetValidator = resourceSetValidator;
    }

    @Override
    public final ValidationResult validate(XJDF xjdf) {
        ValidationResult result = new ValidationResult(new String[0]);
        if (null != xjdf.getProductList()) {
            for (Product product : xjdf.getProductList().getProduct()) {
                for (Intent intent : product.getIntent()) {
                    if (!(intent.getProductIntent().getValue() instanceof FoldingIntent)) continue;
                    result.append(this.foldingIntentValidator.validate((FoldingIntent)intent.getProductIntent().getValue()));
                }
            }
        }
        for (ResourceSet resourceSet : xjdf.getResourceSet()) {
            result.append(this.resourceSetValidator.validate(resourceSet));
        }
        return result;
    }
}

