/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.uri.resolver;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.cip4.lib.xjdf.uri.resolver.AbsoluteURIPathResolver;
import org.cip4.lib.xjdf.uri.resolver.AbsoluteURIResolver;
import org.cip4.lib.xjdf.uri.resolver.AuthorityURIResolver;
import org.cip4.lib.xjdf.uri.resolver.RelativeURIPathResolver;
import org.cip4.lib.xjdf.uri.resolver.URIResolverInterface;

public final class URIResolver {
    private static final List<URIResolverInterface> URI_RESOLVER_LIST = Arrays.asList(new AbsoluteURIResolver(), new AuthorityURIResolver(), new AbsoluteURIPathResolver(), new RelativeURIPathResolver());

    public static URI resolve(URI baseUri, String uriString) throws URISyntaxException {
        Objects.requireNonNull(uriString, "Parameter uriString must not be null");
        for (URIResolverInterface uriResolver : URI_RESOLVER_LIST) {
            if (!uriResolver.canResolve(uriString)) continue;
            return uriResolver.resolve(baseUri, uriString);
        }
        throw new RuntimeException(String.format("No resolver can resolve the passed URI '%s' against the base URI '%s'.", uriString, baseUri));
    }
}

